/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.justauth.autoconfigure;

import com.xingyuv.jushauth.cache.AuthDefaultStateCache;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.justauth.autoconfigure.JustAuthProperties;
import com.xingyuv.justauth.support.cache.RedisStateCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

abstract class JustAuthStateCacheConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JustAuthStateCacheConfiguration.class);

    JustAuthStateCacheConfiguration() {
    }

    @ConditionalOnProperty(name={"justauth.cache.type"}, havingValue="custom")
    static class Custom {
        Custom() {
        }

        @Bean
        @ConditionalOnMissingBean(value={AuthStateCache.class})
        public AuthStateCache authStateCache() {
            log.error("\u8bf7\u81ea\u884c\u5b9e\u73b0 com.xingyuv.jushauth.cache.AuthStateCache");
            throw new RuntimeException();
        }

        static {
            log.debug("JustAuth \u4f7f\u7528 \u81ea\u5b9a\u4e49\u7f13\u5b58\u5b58\u50a8 state \u6570\u636e");
        }
    }

    @ConditionalOnMissingBean(value={AuthStateCache.class})
    @ConditionalOnProperty(name={"justauth.cache.type"}, havingValue="default", matchIfMissing=true)
    static class Default {
        Default() {
        }

        @Bean
        public AuthStateCache authStateCache() {
            return AuthDefaultStateCache.INSTANCE;
        }

        static {
            log.debug("JustAuth \u4f7f\u7528 \u9ed8\u8ba4\u7f13\u5b58\u5b58\u50a8 state \u6570\u636e");
        }
    }

    @ConditionalOnClass(value={RedisTemplate.class})
    @ConditionalOnMissingBean(value={AuthStateCache.class})
    @AutoConfigureBefore(value={RedisAutoConfiguration.class})
    @ConditionalOnProperty(name={"justauth.cache.type"}, havingValue="redis", matchIfMissing=true)
    static class Redis {
        Redis() {
        }

        @Bean(name={"justAuthRedisCacheTemplate"})
        public RedisTemplate<String, String> justAuthRedisCacheTemplate(RedisConnectionFactory redisConnectionFactory) {
            RedisTemplate template = new RedisTemplate();
            template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            template.setValueSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer());
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        public AuthStateCache authStateCache(RedisTemplate<String, String> justAuthRedisCacheTemplate, JustAuthProperties justAuthProperties) {
            return new RedisStateCache(justAuthRedisCacheTemplate, justAuthProperties.getCache());
        }

        static {
            log.debug("JustAuth \u4f7f\u7528 Redis \u7f13\u5b58\u5b58\u50a8 state \u6570\u636e");
        }
    }
}

