/*
 * Decompiled with CFR 0.152.
 */
package de.ailis.pherialize;

import de.ailis.pherialize.Mixed;
import de.ailis.pherialize.Unserializer;
import de.ailis.pherialize.exceptions.SerializeException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Serializer {
    private final Charset charset;
    private final List<Object> history;

    public Serializer() {
        this(Charset.forName("UTF-8"));
    }

    public Serializer(Charset charset) {
        this.charset = charset;
        this.history = new ArrayList<Object>();
    }

    public String serialize(Object object) {
        StringBuffer buffer = new StringBuffer();
        this.serializeObject(object, buffer);
        return buffer.toString();
    }

    private void serializeObject(Object object, StringBuffer buffer) {
        this.serializeObject(object, buffer, true);
    }

    private void serializeObject(Object object, StringBuffer buffer, boolean allowReference) {
        if (object == null) {
            this.serializeNull(buffer);
        } else {
            if (allowReference && this.serializeReference(object, buffer)) {
                return;
            }
            if (object instanceof String) {
                this.serializeString((String)object, buffer);
            } else if (object instanceof Character) {
                this.serializeCharacter((Character)object, buffer);
            } else if (object instanceof Integer) {
                this.serializeInteger((Integer)object, buffer);
            } else if (object instanceof Short) {
                this.serializeInteger(((Short)object).intValue(), buffer);
            } else if (object instanceof Byte) {
                this.serializeInteger(((Byte)object).intValue(), buffer);
            } else if (object instanceof Long) {
                this.serializeLong((Long)object, buffer);
            } else if (object instanceof Double) {
                this.serializeDouble((Double)object, buffer);
            } else if (object instanceof Float) {
                this.serializeDouble(((Float)object).doubleValue(), buffer);
            } else if (object instanceof Boolean) {
                this.serializeBoolean((Boolean)object, buffer);
            } else {
                if (object instanceof Mixed) {
                    this.serializeMixed((Mixed)object, buffer);
                    return;
                }
                if (object instanceof Object[]) {
                    this.serializeArray((Object[])object, buffer);
                    return;
                }
                if (object instanceof Collection) {
                    this.serializeCollection((Collection)object, buffer);
                    return;
                }
                if (object instanceof Map) {
                    this.serializeMap((Map)object, buffer);
                    return;
                }
                if (object instanceof Serializable) {
                    this.serializeSerializable((Serializable)object, buffer);
                    return;
                }
                throw new SerializeException("Unable to serialize " + object.getClass().getName());
            }
        }
        this.history.add(object);
    }

    private boolean serializeReference(Object object, StringBuffer buffer) {
        if (object instanceof Number || object instanceof Boolean || object instanceof String) {
            return false;
        }
        Iterator<Object> iterator = this.history.iterator();
        int index = 0;
        boolean isReference = false;
        while (iterator.hasNext()) {
            if (iterator.next() == object) {
                buffer.append("R:");
                buffer.append(index + 1);
                buffer.append(';');
                isReference = true;
                break;
            }
            ++index;
        }
        return isReference;
    }

    private void serializeMixed(Mixed mixed, StringBuffer buffer) {
        this.serializeObject(mixed.getValue(), buffer);
    }

    private void serializeString(String string, StringBuffer buffer) {
        String decoded = Unserializer.decode(string, this.charset);
        buffer.append("s:");
        buffer.append(decoded.length());
        buffer.append(":\"");
        buffer.append(string);
        buffer.append("\";");
    }

    private void serializeCharacter(Character value, StringBuffer buffer) {
        buffer.append("s:1:\"");
        buffer.append(value);
        buffer.append("\";");
    }

    private void serializeNull(StringBuffer buffer) {
        buffer.append("N;");
    }

    private void serializeInteger(int number, StringBuffer buffer) {
        buffer.append("i:");
        buffer.append(number);
        buffer.append(';');
    }

    private void serializeLong(long number, StringBuffer buffer) {
        buffer.append("i:");
        buffer.append(number);
        buffer.append(';');
    }

    private void serializeDouble(double number, StringBuffer buffer) {
        buffer.append("d:");
        buffer.append(number);
        buffer.append(';');
    }

    private void serializeBoolean(Boolean value, StringBuffer buffer) {
        buffer.append("b:");
        buffer.append(value != false ? 1 : 0);
        buffer.append(';');
    }

    private void serializeCollection(Collection<?> collection, StringBuffer buffer) {
        this.history.add(collection);
        buffer.append("a:");
        buffer.append(collection.size());
        buffer.append(":{");
        Iterator<?> iterator = collection.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            this.serializeObject(index, buffer, false);
            this.history.remove(this.history.size() - 1);
            this.serializeObject(iterator.next(), buffer);
            ++index;
        }
        buffer.append('}');
    }

    private void serializeArray(Object[] array, StringBuffer buffer) {
        this.history.add(array);
        buffer.append("a:");
        int max = array.length;
        buffer.append(max);
        buffer.append(":{");
        for (int i = 0; i < max; ++i) {
            this.serializeObject(i, buffer, false);
            this.history.remove(this.history.size() - 1);
            this.serializeObject(array[i], buffer);
        }
        buffer.append('}');
    }

    private void serializeMap(Map<?, ?> map, StringBuffer buffer) {
        this.history.add(map);
        buffer.append("a:");
        buffer.append(map.size());
        buffer.append(":{");
        for (Object key : map.keySet()) {
            this.serializeObject(key, buffer, false);
            this.history.remove(this.history.size() - 1);
            this.serializeObject(map.get(key), buffer);
        }
        buffer.append('}');
    }

    private void serializeSerializable(Serializable object, StringBuffer buffer) {
        Class<?> c;
        this.history.add(object);
        String className = c.getSimpleName();
        buffer.append("O:");
        buffer.append(className.length());
        buffer.append(":\"");
        buffer.append(className);
        buffer.append("\":");
        StringBuffer fieldBuffer = new StringBuffer();
        int fieldCount = 0;
        for (c = object.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isVolatile(field.getModifiers())) continue;
                try {
                    field.setAccessible(true);
                    String key = field.getName();
                    Object value = field.get(object);
                    this.serializeObject(key, fieldBuffer);
                    this.history.remove(this.history.size() - 1);
                    this.serializeObject(value, fieldBuffer);
                    ++fieldCount;
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        buffer.append(fieldCount);
        buffer.append(":{");
        buffer.append(fieldBuffer);
        buffer.append("}");
    }
}

