/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.http.support.java11;

import com.xkcoding.http.config.HttpConfig;
import com.xkcoding.http.constants.Constants;
import com.xkcoding.http.exception.SimpleHttpException;
import com.xkcoding.http.support.AbstractHttp;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.support.java11.DefaultProxySelector;
import com.xkcoding.http.util.MapUtil;
import com.xkcoding.http.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;

public class HttpClientImpl
extends AbstractHttp {
    private final HttpClient.Builder clientBuilder;

    public HttpClientImpl() {
        this(new HttpConfig());
    }

    public HttpClientImpl(HttpConfig httpConfig) {
        this(HttpClient.newBuilder(), httpConfig);
    }

    public HttpClientImpl(HttpClient.Builder clientBuilder, HttpConfig httpConfig) {
        super(httpConfig);
        this.clientBuilder = clientBuilder;
    }

    private String exec(HttpRequest.Builder builder) {
        this.addHeader(builder);
        try {
            HttpClient client = null != this.httpConfig.getProxy() ? this.clientBuilder.connectTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).proxy(new DefaultProxySelector(this.httpConfig)).build() : this.clientBuilder.connectTimeout(Duration.ofMillis(this.httpConfig.getTimeout())).build();
            HttpRequest request = builder.build();
            return client.send(request, HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (IOException | InterruptedException e) {
            throw new SimpleHttpException(e);
        }
    }

    private void addHeader(HttpRequest.Builder builder) {
        builder.header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
    }

    @Override
    public String get(String url) {
        return this.get(url, null, false);
    }

    @Override
    public String get(String url, Map<String, String> params, boolean encode) {
        return this.get(url, params, null, encode);
    }

    @Override
    public String get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        String baseUrl = StringUtil.appendIfNotContain(url, "?", "&");
        String reqUrl = baseUrl + MapUtil.parseMapToString(params, encode);
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(reqUrl)).GET().timeout(Duration.ofMillis(3000L));
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), builder::header);
        }
        return this.exec(builder);
    }

    @Override
    public String post(String url) {
        return this.post(url, null);
    }

    @Override
    public String post(String url, String data) {
        return this.post(url, data, null);
    }

    @Override
    public String post(String url, String data, HttpHeader header) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofMillis(3000L));
        if (StringUtil.isNotEmpty(data)) {
            builder.POST(HttpRequest.BodyPublishers.ofString(data, Constants.DEFAULT_ENCODING));
            builder.header("Content-Encoding", Constants.DEFAULT_ENCODING.displayName());
            builder.header("Content-Type", "application/json; charset=utf-8");
        } else {
            builder.POST(HttpRequest.BodyPublishers.noBody());
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), builder::header);
        }
        return this.exec(builder);
    }

    @Override
    public String post(String url, Map<String, String> params, boolean encode) {
        return this.post(url, params, null, encode);
    }

    @Override
    public String post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        String baseUrl = StringUtil.appendIfNotContain(url, "?", "&");
        String reqUrl = baseUrl + MapUtil.parseMapToString(params, encode);
        return this.post(reqUrl, null, header);
    }
}

