/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.http.support.java11;

import com.xkcoding.http.constants.Constants;
import com.xkcoding.http.exception.SimpleHttpException;
import com.xkcoding.http.support.Http;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.MapUtil;
import com.xkcoding.http.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;

public class HttpClientImpl
implements Http {
    private final HttpClient client;

    public HttpClientImpl() {
        this(HttpClient.newBuilder().connectTimeout(Duration.ofMillis(3000L)).build());
    }

    public HttpClientImpl(HttpClient client) {
        this.client = client;
    }

    private String exec(HttpRequest request) {
        try {
            return this.client.send(request, HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (IOException | InterruptedException e) {
            throw new SimpleHttpException(e);
        }
    }

    @Override
    public String get(String url) {
        return this.get(url, null, false);
    }

    @Override
    public String get(String url, Map<String, String> params, boolean encode) {
        return this.get(url, params, null, encode);
    }

    @Override
    public String get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        String baseUrl = StringUtil.appendIfNotContain(url, "?", "&");
        String reqUrl = baseUrl + MapUtil.parseMapToString(params, encode);
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(reqUrl)).GET().timeout(Duration.ofMillis(3000L));
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), builder::header);
        }
        return this.exec(builder.build());
    }

    @Override
    public String post(String url) {
        return this.post(url, null);
    }

    @Override
    public String post(String url, String data) {
        return this.post(url, data, null);
    }

    @Override
    public String post(String url, String data, HttpHeader header) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofMillis(3000L));
        if (StringUtil.isNotEmpty(data)) {
            builder.POST(HttpRequest.BodyPublishers.ofString(data, Constants.DEFAULT_ENCODING));
            builder.header("Content-Encoding", Constants.DEFAULT_ENCODING.displayName());
            builder.header("Content-Type", "application/json; charset=utf-8");
        } else {
            builder.POST(HttpRequest.BodyPublishers.noBody());
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), builder::header);
        }
        return this.exec(builder.build());
    }

    @Override
    public String post(String url, Map<String, String> params, boolean encode) {
        return this.post(url, params, null, encode);
    }

    @Override
    public String post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        String baseUrl = StringUtil.appendIfNotContain(url, "?", "&");
        String reqUrl = baseUrl + MapUtil.parseMapToString(params, encode);
        return this.post(reqUrl, null, header);
    }
}

