/*
 * Decompiled with CFR 0.152.
 */
package com.xlvecle;

import ch.hsr.geohash.BoundingBox;
import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a9\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00022\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\u00020\u0004\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u0011\u00a8\u0006\u0012"}, d2={"geohashPoly", "", "", "polygon", "Lcom/vividsolutions/jts/geom/Polygon;", "precision", "", "mode", "threshold", "", "(Lcom/vividsolutions/jts/geom/Polygon;ILjava/lang/String;Ljava/lang/Double;)Ljava/util/List;", "envelopeBox", "Lcom/vividsolutions/jts/geom/Coordinate;", "toJTSPoint", "Lcom/vividsolutions/jts/geom/Point;", "Lch/hsr/geohash/WGS84Point;", "toJTSPolygon", "Lch/hsr/geohash/BoundingBox;", "geohash-poly"})
public final class GeohashPolyKt {
    @NotNull
    public static final List<Coordinate> envelopeBox(@NotNull Polygon $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Coordinate[] envelopeCoordinates = $receiver.getEnvelope().getCoordinates();
        return ArraysKt.slice((Object[])envelopeCoordinates, (IntRange)new IntRange(1, 4));
    }

    @NotNull
    public static final Polygon toJTSPolygon(@NotNull BoundingBox $receiver) {
        Polygon polygon;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Coordinate[] elements$iv = new Coordinate[]{new Coordinate($receiver.getMinLat(), $receiver.getMaxLon()), new Coordinate($receiver.getMaxLat(), $receiver.getMaxLon()), new Coordinate($receiver.getMaxLat(), $receiver.getMinLon()), new Coordinate($receiver.getMinLat(), $receiver.getMinLon()), new Coordinate($receiver.getMinLat(), $receiver.getMaxLon())};
        Coordinate[] points = (Coordinate[])((Object[])elements$iv);
        Polygon polygon2 = polygon = new GeometryFactory().createPolygon(new LinearRing((CoordinateSequence)new CoordinateArraySequence(points), new GeometryFactory()), (LinearRing[])null);
        Intrinsics.checkExpressionValueIsNotNull((Object)polygon2, (String)"polygon");
        return polygon2;
    }

    @NotNull
    public static final Point toJTSPoint(@NotNull WGS84Point $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Point point = new GeometryFactory().createPoint(new Coordinate($receiver.getLatitude(), $receiver.getLongitude()));
        Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"GeometryFactory().create\u2026atitude, this.longitude))");
        return point;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> geohashPoly(@NotNull Polygon polygon, int precision, @NotNull String mode, @Nullable Double threshold) {
        Intrinsics.checkParameterIsNotNull((Object)polygon, (String)"polygon");
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        List<Coordinate> b = GeohashPolyKt.envelopeBox(polygon);
        GeoHash hashNorthEast = GeoHash.withCharacterPrecision((double)b.get((int)1).x, (double)b.get((int)1).y, (int)precision);
        GeoHash hashSouthWest = GeoHash.withCharacterPrecision((double)b.get((int)3).x, (double)b.get((int)3).y, (int)precision);
        double perLat = hashNorthEast.getBoundingBox().getLatitudeSize();
        double perLng = hashNorthEast.getBoundingBox().getLongitudeSize();
        int latStep = (int)Math.floor((hashNorthEast.getBoundingBoxCenterPoint().getLatitude() - hashSouthWest.getBoundingBoxCenterPoint().getLatitude()) / perLat) + 1;
        int lngStep = (int)Math.floor((hashNorthEast.getBoundingBoxCenterPoint().getLongitude() - hashSouthWest.getBoundingBoxCenterPoint().getLongitude()) / perLng) + 1;
        List hashList = CollectionsKt.mutableListOf((Object[])new String[0]);
        List p = CollectionsKt.mutableListOf((Object[])new List[0]);
        GeoHash baseHash = hashSouthWest.getSouthernNeighbour().getSouthernNeighbour().getWesternNeighbour().getWesternNeighbour();
        int n = 0;
        int n2 = latStep + 1;
        if (n <= n2) {
            while (true) {
                void lat;
                GeoHash tmp = baseHash = baseHash.getNorthernNeighbour();
                int n3 = 0;
                int n4 = lngStep + 1;
                if (n3 <= n4) {
                    while (true) {
                        void lng;
                        GeoHash next = tmp.getEasternNeighbour();
                        p.add(CollectionsKt.listOf((Object[])new Double[]{next.getBoundingBoxCenterPoint().getLatitude(), next.getBoundingBoxCenterPoint().getLongitude()}));
                        if (Intrinsics.areEqual((Object)mode, (Object)"center")) {
                            if (GeohashPolyKt.toJTSPoint(next.getBoundingBoxCenterPoint()).within((Geometry)polygon)) {
                                String string = next.toBase32();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"next.toBase32()");
                                hashList.add(string);
                            }
                        } else {
                            BoundingBox bbox = next.getBoundingBox();
                            if (Intrinsics.areEqual((Object)mode, (Object)"inside")) {
                                if (polygon.contains((Geometry)GeohashPolyKt.toJTSPolygon(bbox))) {
                                    String string = next.toBase32();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"next.toBase32()");
                                    hashList.add(string);
                                }
                            } else if (Intrinsics.areEqual((Object)mode, (Object)"intersect")) {
                                if (threshold != null) {
                                    double intersectArea = polygon.intersection((Geometry)GeohashPolyKt.toJTSPolygon(bbox)).getArea();
                                    if (Double.compare(intersectArea / GeohashPolyKt.toJTSPolygon(bbox).getArea(), threshold) > 0) {
                                        String string = next.toBase32();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"next.toBase32()");
                                        hashList.add(string);
                                    }
                                } else if (polygon.intersects((Geometry)GeohashPolyKt.toJTSPolygon(bbox))) {
                                    String string = next.toBase32();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"next.toBase32()");
                                    hashList.add(string);
                                }
                            }
                        }
                        tmp = next;
                        if (lng == n4) break;
                        ++lng;
                    }
                }
                if (lat == n2) break;
                ++lat;
            }
        }
        return hashList;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List geohashPoly$default(Polygon polygon, int n, String string, Double d, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: geohashPoly");
        }
        if ((n2 & 2) != 0) {
            n = 7;
        }
        if ((n2 & 4) != 0) {
            string = "center";
        }
        if ((n2 & 8) != 0) {
            d = null;
        }
        return GeohashPolyKt.geohashPoly(polygon, n, string, d);
    }
}

