/*
 * Decompiled with CFR 0.152.
 */
package com.xlythe.view.floating;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.Log;
import androidx.annotation.DrawableRes;
import com.xlythe.view.floating.Bubbles;

public abstract class CreateShortcutActivity
extends Activity {
    private static final String TAG = "CreateShortcutActivity";
    private static final int REQUEST_CODE_WINDOW_OVERLAY_PERMISSION = 10001;
    private static final int REQUEST_CODE_BUBBLES_PERMISSION = 10002;

    @DrawableRes
    public abstract int getShortcutIcon();

    public abstract CharSequence getShortcutName();

    public abstract Intent getOpenShortcutActivityIntent();

    public void onCreate(Bundle state) {
        super.onCreate(state);
        if ("android.intent.action.CREATE_SHORTCUT".equals(this.getIntent().getAction())) {
            if (Build.VERSION.SDK_INT >= 30 && !Bubbles.canDisplayBubbles((Context)this)) {
                this.startActivityForResult(new Intent("android.settings.APP_NOTIFICATION_BUBBLE_SETTINGS").putExtra("android.provider.extra.APP_PACKAGE", this.getPackageName()), 10002);
            } else if (Build.VERSION.SDK_INT < 30 && Build.VERSION.SDK_INT >= 23 && !this.canDrawOverlays()) {
                this.startActivityForResult(new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this.getPackageName()))), 10001);
            } else {
                this.onSuccess();
            }
        } else {
            Log.w((String)TAG, (String)("CreateShortcutActivity called with unexpected Action " + this.getIntent().getAction()));
            this.onFailure();
        }
    }

    private void onSuccess() {
        Intent.ShortcutIconResource icon = Intent.ShortcutIconResource.fromContext((Context)this, (int)this.getShortcutIcon());
        Intent intent = new Intent();
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)this.getOpenShortcutActivityIntent());
        intent.putExtra("android.intent.extra.shortcut.NAME", this.getShortcutName());
        intent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)icon);
        this.setResult(-1, intent);
        this.finish();
    }

    private void onFailure() {
        this.setResult(0);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10001) {
            if (this.canDrawOverlays()) {
                this.onSuccess();
            } else {
                this.onFailure();
            }
        } else if (requestCode == 10002) {
            if (Bubbles.canDisplayBubbles((Context)this)) {
                this.onSuccess();
            } else {
                this.onFailure();
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    private boolean canDrawOverlays() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return Settings.canDrawOverlays((Context)this);
    }
}

