/*
 * Decompiled with CFR 0.152.
 */
package com.xlythe.view.floating;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Person;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;
import com.xlythe.view.floating.Bubbles;
import com.xlythe.view.floating.R;
import java.util.Collections;

public abstract class OpenShortcutActivity
extends Activity {
    private static final int REQUEST_CODE_WINDOW_OVERLAY_PERMISSION = 10001;
    private static final int REQUEST_CODE_BUBBLES_PERMISSION = 10002;
    private static final String SHORTCUT_ID = "floating.shortcutId";
    public static final String ACTION_OPEN = "com.xlythe.view.floating.OPEN";

    protected abstract Intent createServiceIntent();

    @RequiresApi(value=30)
    protected abstract Intent createActivityIntent();

    @RequiresApi(value=30)
    protected abstract Notification createNotification();

    public void onCreate(Bundle state) {
        super.onCreate(state);
        if (Build.VERSION.SDK_INT >= 30 && !Bubbles.canDisplayBubbles((Context)this, this.createNotification().getChannelId())) {
            this.startActivityForResult(new Intent("android.settings.APP_NOTIFICATION_BUBBLE_SETTINGS").putExtra("android.provider.extra.APP_PACKAGE", this.getPackageName()), 10002);
        } else if (Build.VERSION.SDK_INT < 30 && Build.VERSION.SDK_INT >= 23 && !this.canDrawOverlays()) {
            this.startActivityForResult(new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + this.getPackageName()))), 10001);
        } else {
            this.onSuccess();
        }
    }

    private void onSuccess() {
        if (Build.VERSION.SDK_INT >= 30) {
            Intent intent = this.createActivityIntent();
            Icon icon = this.getActivityIcon(intent);
            String name = this.getActivityName(intent);
            PendingIntent bubbleIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x2000000);
            Notification.BubbleMetadata bubbleData = new Notification.BubbleMetadata.Builder().setIntent(bubbleIntent).setIcon(icon).setDesiredHeight(600).setAutoExpandBubble(true).setSuppressNotification(true).build();
            Person person = new Person.Builder().setIcon(icon).setName((CharSequence)name).build();
            Notification.MessagingStyle style = new Notification.MessagingStyle(person);
            ShortcutManager shortcutManager = (ShortcutManager)this.getSystemService(ShortcutManager.class);
            ShortcutInfo shortcutInfo = new ShortcutInfo.Builder((Context)this, SHORTCUT_ID).setIcon(icon).setShortLabel((CharSequence)name).setPerson(person).setLongLived(true).setIntent(new Intent(ACTION_OPEN).setComponent(this.getComponentName())).build();
            shortcutManager.addDynamicShortcuts(Collections.singletonList(shortcutInfo));
            Notification notification = this.createNotification();
            Notification.Builder builder = new Notification.Builder((Context)this, notification.getChannelId()).setContentIntent(PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent(ACTION_OPEN).setComponent(this.getComponentName()), (int)0xA000000)).setContentTitle(notification.extras.getCharSequence("android.title")).setContentText(notification.extras.getCharSequence("android.text")).setSmallIcon(notification.getSmallIcon()).setBubbleMetadata(bubbleData).addPerson(person).setShortcutId(SHORTCUT_ID).setStyle((Notification.Style)style);
            NotificationManager notificationManager = (NotificationManager)this.getSystemService(NotificationManager.class);
            notificationManager.notify(0, builder.build());
            new Handler().postDelayed(() -> shortcutManager.removeDynamicShortcuts(Collections.singletonList(SHORTCUT_ID)), 5000L);
        } else {
            Intent intent = this.createServiceIntent();
            if (ACTION_OPEN.equals(this.getIntent().getAction()) && intent.getAction() == null) {
                intent.setAction(ACTION_OPEN);
            }
            if (Build.VERSION.SDK_INT >= 26) {
                this.startForegroundService(intent);
            } else {
                this.startService(intent);
            }
        }
        this.finish();
    }

    private void onFailure() {
        this.setResult(0);
        this.finish();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.blank, R.anim.blank);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10001) {
            if (this.canDrawOverlays()) {
                this.onSuccess();
            } else {
                this.onFailure();
            }
        } else if (requestCode == 10002) {
            if (Bubbles.canDisplayBubbles((Context)this)) {
                this.onSuccess();
            } else {
                this.onFailure();
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    @RequiresApi(value=26)
    public Icon getActivityIcon(Intent intent) {
        PackageManager packageManager = this.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 0);
        Preconditions.checkNotNull((Object)resolveInfo, (Object)("Failed to resolve " + intent));
        Drawable drawable = resolveInfo.loadIcon(packageManager);
        return Icon.createWithAdaptiveBitmap((Bitmap)OpenShortcutActivity.toBitmap(drawable));
    }

    public String getActivityName(Intent intent) {
        PackageManager packageManager = this.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 0);
        Preconditions.checkNotNull((Object)resolveInfo, (Object)("Failed to resolve " + intent));
        return this.getString(resolveInfo.activityInfo.labelRes);
    }

    public static Bitmap toBitmap(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private boolean canDrawOverlays() {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return Settings.canDrawOverlays((Context)this);
    }
}

