/*
 * Decompiled with CFR 0.152.
 */
package com.xlythe.view.floating;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Build;
import android.os.IBinder;
import android.os.Vibrator;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.xlythe.view.floating.AnimationFinishedListener;
import com.xlythe.view.floating.LimitedQueue;
import com.xlythe.view.floating.R;

@Deprecated
public abstract class FloatingView
extends Service
implements View.OnTouchListener {
    static final String TAG = "FloatingView";
    static final boolean DEBUG = false;
    private static final int MARGIN_VIEW = 20;
    private static final int MARGIN_VERTICAL = 5;
    private static final int MARGIN_HORIZONTAL = -10;
    private static final int VIBRATION = 25;
    private static final int DELETE_ANIM_DURATION = 300;
    private static final int NOTIFICATION_ID = 1;
    public static final String ACTION_OPEN = "com.xlythe.view.floating.OPEN";
    private int CLOSE_ANIMATION_DISTANCE;
    private int DRAG_DELTA;
    private int STARTING_POINT_Y;
    private int DELETE_BOX_WIDTH;
    private int DELETE_BOX_HEIGHT;
    private int MAGIC_OFFSET;
    private float mPrevDragX;
    private float mPrevDragY;
    private float mOrigX;
    private float mOrigY;
    private boolean mDragged;
    private int mIconSize;
    private final Point mStartingPositionPoint = new Point();
    private final Point mOpenPositionPoint = new Point();
    private ViewGroup mRootView;
    private BroadcastReceiver mBroadcastReceiver;
    private WindowManager mWindowManager;
    private View mDraggableIcon;
    private ViewGroup mInactiveButton;
    private WindowManager.LayoutParams mInactiveParams;
    private View mView;
    private ViewGroup mDeleteView;
    private View mDeleteBoxView;
    private boolean mDeleteBoxVisible = false;
    private boolean mIsDestroyed = false;
    private boolean mIsBeingDestroyed = false;
    private int mCurrentPosX = -1;
    private int mCurrentPosY = -1;
    private LimitedQueue<Float> mDeltaXArray;
    private LimitedQueue<Float> mDeltaYArray;
    private AnimationTask mAnimationTask;
    private final Point mIconPositionInDeleteModePoint = new Point();
    private boolean mIsViewOpen = false;
    private final Point mWiggle = new Point(0, 0);
    private boolean mEnableWiggle = false;
    private boolean mIsInDeleteMode = false;
    private boolean mIsAnimatingToDeleteMode = false;
    private View mDeleteIcon;
    private View mDeleteIconHolder;
    private boolean mIsAnimationLocked = false;
    private boolean mDontVibrate = false;
    private BroadcastReceiver mHomeKeyReceiver;

    @NonNull
    protected abstract View inflateButton(@NonNull ViewGroup var1);

    @NonNull
    protected abstract View inflateView(@NonNull ViewGroup var1);

    @NonNull
    protected abstract Notification createNotification();

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null && ACTION_OPEN.equals(intent.getAction())) {
            this.open();
        }
        return super.onStartCommand(intent, flags, startId);
    }

    @SuppressLint(value={"RtlHardcoded"})
    public void onCreate() {
        super.onCreate();
        this.startForeground(1, this.createNotification());
        ViewConfiguration vc = ViewConfiguration.get((Context)this.getContext());
        float density = this.getResources().getDisplayMetrics().density;
        this.CLOSE_ANIMATION_DISTANCE = (int)(250.0f * density);
        this.DRAG_DELTA = vc.getScaledTouchSlop();
        this.STARTING_POINT_Y = (int)(50.0f * density);
        this.DELETE_BOX_WIDTH = (int)this.getResources().getDimension(R.dimen.floating_window_delete_box_width);
        this.DELETE_BOX_HEIGHT = (int)this.getResources().getDimension(R.dimen.floating_window_delete_box_height);
        this.MAGIC_OFFSET = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mWindowManager = (WindowManager)this.getSystemService("window");
        this.mRootView = new FrameLayout(this.getContext()){

            public boolean dispatchKeyEvent(KeyEvent event) {
                if (event.getKeyCode() == 4) {
                    FloatingView.this.close();
                    return true;
                }
                return super.dispatchKeyEvent(event);
            }
        };
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -1, Build.VERSION.SDK_INT >= 26 ? 2038 : 2002, 262144, -3);
        this.mWindowManager.addView((View)this.mRootView, (ViewGroup.LayoutParams)params);
        this.mRootView.setVisibility(8);
        this.mInactiveButton = new FrameLayout(this.getContext());
        this.mInactiveButton.addView(this.inflateButton(this.mInactiveButton));
        params = this.mInactiveParams = new WindowManager.LayoutParams(-2, -2, Build.VERSION.SDK_INT >= 26 ? 2038 : 2002, 8, -3);
        params.gravity = 51;
        this.mWindowManager.addView((View)this.mInactiveButton, (ViewGroup.LayoutParams)params);
        this.mInactiveButton.setOnTouchListener((View.OnTouchListener)this);
        this.mDraggableIcon = this.inflateButton(this.mRootView);
        this.mDraggableIcon.setOnTouchListener((View.OnTouchListener)this);
        if (this.mDraggableIcon.getLayoutParams() == null) {
            this.mDraggableIcon.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        }
        this.mRootView.addView(this.mDraggableIcon);
        Point startingPosition = this.getStartingPosition();
        this.updateIconPosition(startingPosition.x, startingPosition.y);
        this.adjustInactivePosition();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.mBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent myIntent) {
                int x = FloatingView.this.mCurrentPosX <= 0 ? FloatingView.this.getIconHorizontalMargin() : FloatingView.this.getScreenWidth() - FloatingView.this.mIconSize - FloatingView.this.getIconHorizontalMargin();
                int y = FloatingView.this.mCurrentPosY;
                if (y <= 0) {
                    y = FloatingView.this.getIconVerticalMargin();
                }
                if (y >= FloatingView.this.getScreenHeight() - FloatingView.this.mDraggableIcon.getHeight()) {
                    y = FloatingView.this.getScreenHeight() - FloatingView.this.mDraggableIcon.getHeight() - FloatingView.this.getIconVerticalMargin();
                }
                FloatingView.this.updateIconPosition(x, y);
                FloatingView.this.adjustInactivePosition();
            }
        };
        this.registerReceiver(this.mBroadcastReceiver, filter);
        this.mRootView.measure(View.MeasureSpec.makeMeasureSpec((int)this.getScreenWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getScreenHeight(), (int)0x40000000));
        this.mIconSize = this.mDraggableIcon.getMeasuredWidth();
    }

    public void onDestroy() {
        this.mIsDestroyed = true;
        if (this.mRootView != null) {
            ((WindowManager)this.getSystemService("window")).removeView((View)this.mRootView);
            this.mRootView = null;
        }
        if (this.mInactiveButton != null) {
            ((WindowManager)this.getSystemService("window")).removeView((View)this.mInactiveButton);
            this.mInactiveButton = null;
        }
        if (this.mAnimationTask != null) {
            this.mAnimationTask.cancel();
            this.mAnimationTask = null;
        }
        if (this.mBroadcastReceiver != null) {
            this.unregisterReceiver(this.mBroadcastReceiver);
            this.mBroadcastReceiver = null;
        }
        super.onDestroy();
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mRootView == null) {
            return false;
        }
        this.mRootView.setVisibility(0);
        if (this.mInactiveButton != null) {
            this.mInactiveButton.setAlpha(0.0f);
        }
        switch (event.getAction()) {
            case 0: {
                this.mPrevDragX = this.mOrigX = event.getRawX();
                this.mPrevDragY = this.mOrigY = event.getRawY();
                this.mDragged = false;
                this.mDeltaXArray = new LimitedQueue(5);
                this.mDeltaYArray = new LimitedQueue(5);
                this.mDraggableIcon.setScaleX(0.92f);
                this.mDraggableIcon.setScaleY(0.92f);
                if (this.mAnimationTask == null) break;
                this.mAnimationTask.cancel();
                break;
            }
            case 1: {
                this.mIsAnimationLocked = false;
                if (this.mAnimationTask != null) {
                    this.mAnimationTask.cancel();
                }
                if (this.mDragged) {
                    this.mAnimationTask = new AnimationTask();
                    this.mAnimationTask.run();
                } else if (this.mIsViewOpen) {
                    this.close();
                } else {
                    this.open();
                }
                if (this.mIsInDeleteMode) {
                    this.stop();
                    break;
                }
                this.hideDeleteBox(false);
                this.mDraggableIcon.setScaleX(1.0f);
                this.mDraggableIcon.setScaleY(1.0f);
                break;
            }
            case 2: {
                int x = (int)(event.getRawX() - (float)(this.mDraggableIcon.getWidth() / 2));
                int y = (int)(event.getRawY() - (float)this.mDraggableIcon.getHeight());
                if (this.mDeleteIconHolder != null) {
                    this.calculateWiggle(x, y);
                    if (this.mEnableWiggle) {
                        this.mDeleteIconHolder.setTranslationX((float)this.mWiggle.x);
                        this.mDeleteIconHolder.setTranslationY((float)this.mWiggle.y);
                    }
                    if (this.mIsInDeleteMode && this.isDeleteMode(x, y) && !this.mIsAnimatingToDeleteMode) {
                        Point point = this.calculatorIconPositionInDeleteMode();
                        this.mDraggableIcon.setTranslationX((float)point.x);
                        this.mDraggableIcon.setTranslationY((float)point.y);
                    }
                }
                if (this.isDeleteMode(x, y)) {
                    if (!this.mIsInDeleteMode) {
                        this.animateToDeleteBoxCenter();
                    }
                } else if (this.isDeleteMode() && !this.mIsAnimationLocked) {
                    this.mIsInDeleteMode = false;
                    if (this.mAnimationTask != null) {
                        this.mAnimationTask.cancel();
                    }
                    this.mAnimationTask = new AnimationTask(x, y);
                    this.mAnimationTask.setDuration(50L);
                    this.mAnimationTask.setInterpolator((Interpolator)new LinearInterpolator());
                    this.mAnimationTask.setAnimationFinishedListener(new AnimationFinishedListener(){

                        @Override
                        public void onAnimationFinished() {
                            FloatingView.this.mIsAnimationLocked = false;
                        }
                    });
                    this.mAnimationTask.run();
                    this.mIsAnimationLocked = true;
                    if (this.mDeleteIcon != null) {
                        this.mDeleteIcon.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L);
                    }
                } else {
                    if (this.mIsInDeleteMode) {
                        if (this.mDeleteIcon != null) {
                            this.mDeleteIcon.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L);
                        }
                        this.mIsInDeleteMode = false;
                    }
                    if (!this.mIsAnimationLocked && this.mDragged) {
                        if (this.mAnimationTask != null) {
                            this.mAnimationTask.cancel();
                        }
                        this.updateIconPosition(x, y);
                        this.mDontVibrate = false;
                    }
                }
                float deltaX = event.getRawX() - this.mPrevDragX;
                float deltaY = event.getRawY() - this.mPrevDragY;
                this.mDeltaXArray.add(Float.valueOf(deltaX));
                this.mDeltaYArray.add(Float.valueOf(deltaY));
                this.mPrevDragX = event.getRawX();
                this.mPrevDragY = event.getRawY();
                deltaX = event.getRawX() - this.mOrigX;
                deltaY = event.getRawY() - this.mOrigY;
                boolean bl = this.mDragged = this.mDragged || Math.abs(deltaX) > (float)this.DRAG_DELTA || Math.abs(deltaY) > (float)this.DRAG_DELTA;
                if (!this.mDragged) break;
                this.close(false);
                this.showDeleteBox();
            }
        }
        return true;
    }

    private void updateIconPosition(int x, int y) {
        this.mCurrentPosX = x;
        this.mCurrentPosY = y;
        if (!this.mIsDestroyed) {
            this.mDraggableIcon.setTranslationX((float)this.mCurrentPosX);
            this.mDraggableIcon.setTranslationY((float)this.mCurrentPosY);
        }
    }

    private boolean isDeleteMode() {
        return this.isDeleteMode(this.mCurrentPosX, this.mCurrentPosY);
    }

    private boolean isDeleteMode(int x, int y) {
        int screenWidth = this.getScreenWidth();
        int screenHeight = this.getScreenHeight();
        int boxWidth = this.DELETE_BOX_WIDTH;
        int boxHeight = this.DELETE_BOX_HEIGHT;
        boolean horz = x + (this.mDraggableIcon == null ? 0 : this.mDraggableIcon.getWidth()) > screenWidth / 2 - boxWidth / 2 && x < screenWidth / 2 + boxWidth / 2;
        boolean vert = y + (this.mDraggableIcon == null ? 0 : this.mDraggableIcon.getHeight()) > screenHeight - boxHeight;
        return this.mEnableWiggle && horz && vert;
    }

    private void showDeleteBox() {
        if (!this.mDeleteBoxVisible) {
            this.mDeleteBoxVisible = true;
            if (this.mDeleteView == null) {
                this.mDeleteView = new FrameLayout(this.getContext());
                View.inflate((Context)this.getContext(), (int)R.layout.floating_delete_box, (ViewGroup)this.mDeleteView);
                this.mDeleteIcon = this.mDeleteView.findViewById(R.id.delete_icon);
                this.mDeleteIconHolder = this.mDeleteView.findViewById(R.id.delete_icon_holder);
                this.mDeleteBoxView = this.mDeleteView.findViewById(R.id.box);
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
                params.gravity = 80;
                this.mRootView.addView((View)this.mDeleteView, (ViewGroup.LayoutParams)params);
            } else {
                this.mDeleteView.setVisibility(0);
            }
            this.mEnableWiggle = false;
            this.mDeleteBoxView.setAlpha(0.0f);
            this.mDeleteBoxView.animate().alpha(1.0f);
            this.mDeleteIconHolder.setTranslationX(0.0f);
            this.mDeleteIconHolder.setTranslationY((float)this.CLOSE_ANIMATION_DISTANCE);
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, 100});
            animator.addUpdateListener(valueAnimator -> {
                float percent = valueAnimator.getAnimatedFraction();
                this.mDeleteIconHolder.setTranslationX((float)this.mWiggle.x * percent);
                int destinationY = this.mWiggle.y;
                float deltaY = destinationY - this.CLOSE_ANIMATION_DISTANCE;
                this.mDeleteIconHolder.setTranslationY((float)this.CLOSE_ANIMATION_DISTANCE + deltaY * percent);
            });
            animator.addListener((Animator.AnimatorListener)new AnimationFinishedListener(){

                @Override
                public void onAnimationFinished() {
                    FloatingView.this.mEnableWiggle = true;
                    if (FloatingView.this.isDeleteMode() && !FloatingView.this.mIsInDeleteMode) {
                        FloatingView.this.animateToDeleteBoxCenter();
                    }
                }
            });
            animator.start();
        }
    }

    private void hideDeleteBox(boolean shrink) {
        if (this.mDeleteBoxVisible) {
            this.mDeleteBoxVisible = false;
            if (this.mDeleteView != null) {
                this.mDeleteBoxView.animate().alpha(0.0f).setDuration(300L);
                this.mDeleteIconHolder.animate().scaleX(shrink ? 0.3f : 1.0f).scaleY(shrink ? 0.3f : 1.0f).translationYBy((float)this.CLOSE_ANIMATION_DISTANCE).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimationFinishedListener(){

                    @Override
                    public void onAnimationFinished() {
                        if (FloatingView.this.mDeleteView != null) {
                            FloatingView.this.mDeleteView.setVisibility(8);
                        }
                    }
                });
            }
        }
    }

    private void adjustInactivePosition() {
        if (this.mRootView == null) {
            return;
        }
        this.mInactiveButton.setAlpha(1.0f);
        this.mRootView.postDelayed(() -> {
            if (this.mRootView != null && !this.mIsViewOpen) {
                this.mRootView.setVisibility(8);
            }
        }, 30L);
        int x = this.mCurrentPosX;
        int y = this.mCurrentPosY;
        View innerShell = this.mInactiveButton.getChildAt(0);
        innerShell.setTranslationX(0.0f);
        innerShell.setTranslationY(0.0f);
        if (x < 0) {
            innerShell.setTranslationX((float)x);
            x = 0;
        } else if (x > this.getScreenWidth() - this.mIconSize) {
            innerShell.setTranslationX((float)(x - this.getScreenWidth() + this.mIconSize));
            x = this.getScreenWidth() - this.mIconSize;
        }
        if (y < 0) {
            innerShell.setTranslationY((float)y);
            y = 0;
        } else if (y > this.getScreenHeight() - this.mIconSize) {
            innerShell.setTranslationY((float)(y - this.getScreenHeight() + this.mIconSize));
            y = this.getScreenHeight() - this.mIconSize;
        }
        this.mInactiveParams.x = x;
        this.mInactiveParams.y = y;
        if (!this.mIsDestroyed) {
            this.mWindowManager.updateViewLayout((View)this.mInactiveButton, (ViewGroup.LayoutParams)this.mInactiveParams);
        }
    }

    private void vibrate() {
        if (this.mDontVibrate) {
            return;
        }
        Vibrator vi = (Vibrator)this.getSystemService("vibrator");
        if (!vi.hasVibrator()) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.VIBRATE") != 0) {
            return;
        }
        vi.vibrate(25L);
    }

    private void stop() {
        if (this.mIsBeingDestroyed) {
            return;
        }
        this.mIsBeingDestroyed = true;
        this.mDontVibrate = true;
        this.animateToDeleteBoxCenter(new AnimationFinishedListener(){

            @Override
            public void onAnimationFinished() {
                FloatingView.this.mDeleteIconHolder.setTranslationX((float)((FloatingView)FloatingView.this).mWiggle.x);
                FloatingView.this.mDeleteIconHolder.setTranslationY((float)((FloatingView)FloatingView.this).mWiggle.y);
                FloatingView.this.hideDeleteBox(true);
                FloatingView.this.mDraggableIcon.animate().scaleX(0.3f).scaleY(0.3f).translationYBy((float)FloatingView.this.CLOSE_ANIMATION_DISTANCE).setDuration(300L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimationFinishedListener(){

                    @Override
                    public void onAnimationFinished() {
                        FloatingView.this.stopSelf();
                    }
                });
            }
        });
    }

    private Point calculatorIconPositionInDeleteMode() {
        this.mIconPositionInDeleteModePoint.x = this.mWiggle.x + this.getScreenWidth() / 2 - this.mDraggableIcon.getWidth() / 2;
        this.mIconPositionInDeleteModePoint.y = this.mWiggle.y + this.mRootView.getHeight() - this.DELETE_BOX_HEIGHT / 2 - this.mDraggableIcon.getHeight() / 2 + this.MAGIC_OFFSET;
        return this.mIconPositionInDeleteModePoint;
    }

    private void animateToDeleteBoxCenter() {
        this.animateToDeleteBoxCenter(null);
    }

    private void animateToDeleteBoxCenter(final @Nullable AnimationFinishedListener l) {
        if (this.mIsAnimationLocked || this.mRootView == null || this.mDraggableIcon == null) {
            return;
        }
        this.mIsInDeleteMode = true;
        this.mIsAnimatingToDeleteMode = true;
        if (this.mAnimationTask != null) {
            this.mAnimationTask.cancel();
        }
        final float initialX = this.mDraggableIcon.getTranslationX();
        final float initialY = this.mDraggableIcon.getTranslationY();
        this.mAnimationTask = new AnimationTask(new DynamicUpdate(){

            @Override
            public float getTranslationX(float percent) {
                int destinationX = ((FloatingView)FloatingView.this).calculatorIconPositionInDeleteMode().x;
                float delta = (float)destinationX - initialX;
                return initialX + delta * percent;
            }

            @Override
            public float getTranslationY(float percent) {
                int destinationY = ((FloatingView)FloatingView.this).calculatorIconPositionInDeleteMode().y;
                float delta = (float)destinationY - initialY;
                return initialY + delta * percent;
            }
        });
        this.mAnimationTask.setDuration(150L);
        this.mAnimationTask.setAnimationFinishedListener(new AnimationFinishedListener(){

            @Override
            public void onAnimationFinished() {
                FloatingView.this.mIsAnimatingToDeleteMode = false;
                if (l != null) {
                    l.onAnimationFinished();
                }
            }
        });
        this.mAnimationTask.run();
        this.vibrate();
        this.mDeleteIcon.animate().scaleX(1.4f).scaleY(1.4f).setDuration(100L);
    }

    private void calculateWiggle(int x, int y) {
        int closeIconX = this.getScreenWidth() / 2;
        int closeIconY = this.mRootView.getHeight() - this.DELETE_BOX_HEIGHT / 2;
        this.mWiggle.x = (x - closeIconX) / 10;
        this.mWiggle.y = Math.max(-1 * this.DELETE_BOX_HEIGHT / 8, (y - closeIconY) / 10);
    }

    public void open() {
        if (this.mRootView.getVisibility() == 8) {
            this.mRootView.setVisibility(0);
            this.mInactiveButton.setAlpha(0.0f);
        }
        if (!this.mIsViewOpen) {
            if (this.mIsAnimationLocked) {
                return;
            }
            this.mIsViewOpen = true;
            Point openPosition = this.getOpenPosition();
            this.mAnimationTask = new AnimationTask(openPosition.x, openPosition.y);
            this.mAnimationTask.setAnimationFinishedListener(new AnimationFinishedListener(){

                @Override
                public void onAnimationFinished() {
                    FloatingView.this.show();
                }
            });
            this.mAnimationTask.run();
            this.mRootView.setOnTouchListener((v, event) -> {
                this.close();
                return true;
            });
            this.mHomeKeyReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    FloatingView.this.close();
                }
            };
            this.getContext().registerReceiver(this.mHomeKeyReceiver, new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
        }
    }

    protected Point getStartingPosition() {
        this.mStartingPositionPoint.x = this.getIconHorizontalMargin();
        this.mStartingPositionPoint.y = this.STARTING_POINT_Y;
        return this.mStartingPositionPoint;
    }

    protected Point getOpenPosition() {
        this.mOpenPositionPoint.x = this.getScreenWidth() - this.mIconSize - this.getMargin();
        this.mOpenPositionPoint.y = this.STARTING_POINT_Y;
        return this.mOpenPositionPoint;
    }

    protected int getMargin() {
        return (int)(20.0f * this.getDensity());
    }

    protected int getIconHorizontalMargin() {
        return (int)(-10.0f * this.getDensity());
    }

    protected int getIconVerticalMargin() {
        return (int)(5.0f * this.getDensity());
    }

    private float getDensity() {
        return this.getResources().getDisplayMetrics().density;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean returnToOrigin) {
        this.close(returnToOrigin, false);
    }

    public void close(boolean returnToOrigin, boolean destroyView) {
        this.mRootView.setOnTouchListener(null);
        if (this.mIsViewOpen) {
            this.mIsViewOpen = false;
            if (returnToOrigin) {
                if (this.mIsAnimationLocked) {
                    return;
                }
                this.mAnimationTask = new AnimationTask(this.mCurrentPosX, this.mCurrentPosY);
                this.mAnimationTask.setAnimationFinishedListener(new AnimationFinishedListener(){

                    @Override
                    public void onAnimationFinished() {
                        FloatingView.this.adjustInactivePosition();
                    }
                });
                this.mAnimationTask.run();
            }
            this.hide(destroyView);
            if (this.mHomeKeyReceiver != null) {
                this.getContext().unregisterReceiver(this.mHomeKeyReceiver);
                this.mHomeKeyReceiver = null;
            }
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void show() {
        if (this.mView == null) {
            this.mView = this.inflateView(this.mRootView);
            this.mView.setOnTouchListener((view, motionEvent) -> true);
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mView.getLayoutParams();
            params.leftMargin = this.getMargin();
            params.rightMargin = this.getMargin();
            params.gravity = this.getOpenPosition().x < this.getScreenWidth() / 2 ? 3 : 5;
            this.mRootView.addView(this.mView);
            this.mView.measure(View.MeasureSpec.makeMeasureSpec((int)(this.mRootView.getWidth() - this.getMargin()), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)(this.mRootView.getHeight() - this.getMargin() - this.getOpenPosition().y), (int)Integer.MIN_VALUE));
        } else {
            this.mView.setVisibility(0);
        }
        if (!this.mIsDestroyed) {
            this.mView.setTranslationY((float)(this.getOpenPosition().y + this.mDraggableIcon.getHeight()));
        }
        this.mView.setAlpha(0.0f);
        this.mView.animate().setDuration(150L).alpha(1.0f).setListener(null);
        this.onShow();
    }

    public void onShow() {
    }

    public void onHide() {
    }

    private void hide(final boolean destroyView) {
        if (this.mView != null) {
            this.mView.setAlpha(1.0f);
            this.mView.animate().setDuration(150L).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimationFinishedListener(){

                @Override
                public void onAnimationFinished() {
                    FloatingView.this.mView.setVisibility(8);
                    if (destroyView) {
                        Log.d((String)FloatingView.TAG, (String)"View destroyed");
                        FloatingView.this.mRootView.removeView(FloatingView.this.mView);
                        FloatingView.this.mView = null;
                    }
                }
            });
            this.onHide();
        }
    }

    private float calculateVelocityX() {
        int depreciation = this.mDeltaXArray.size() + 1;
        float sum = 0.0f;
        for (Float f : this.mDeltaXArray) {
            if (--depreciation > 5) continue;
            sum += f.floatValue() / (float)depreciation;
        }
        return sum;
    }

    private float calculateVelocityY() {
        int depreciation = this.mDeltaYArray.size() + 1;
        float sum = 0.0f;
        for (Float f : this.mDeltaYArray) {
            if (--depreciation > 5) continue;
            sum += f.floatValue() / (float)depreciation;
        }
        return sum;
    }

    protected Context getContext() {
        return this;
    }

    private int getScreenWidth() {
        return this.getResources().getDisplayMetrics().widthPixels;
    }

    private int getScreenHeight() {
        return this.getResources().getDisplayMetrics().heightPixels - this.getStatusBarHeight();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.close(true, true);
    }

    private int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private float sqr(float f) {
        return f * f;
    }

    public static interface DynamicUpdate {
        public float getTranslationX(float var1);

        public float getTranslationY(float var1);
    }

    private class AnimationTask {
        private final int mDestX;
        private final int mDestY;
        @Nullable
        private final DynamicUpdate mDynamicUpdate;
        private long mDuration = 450L;
        private float mTension = 1.4f;
        private Interpolator mInterpolator = new OvershootInterpolator(this.mTension);
        private AnimationFinishedListener mAnimationFinishedListener;

        AnimationTask(int x, int y) {
            if (FloatingView.this.mIsAnimationLocked) {
                throw new RuntimeException("Returning to user's finger. Avoid animations while mIsAnimationLocked flag is set.");
            }
            this.mDestX = x;
            this.mDestY = y;
            this.mDynamicUpdate = null;
        }

        AnimationTask(DynamicUpdate dynamicUpdate) {
            if (FloatingView.this.mIsAnimationLocked) {
                throw new RuntimeException("Returning to user's finger. Avoid animations while mIsAnimationLocked flag is set.");
            }
            this.mDestX = -1;
            this.mDestY = -1;
            this.mDynamicUpdate = dynamicUpdate;
        }

        AnimationTask() {
            if (FloatingView.this.mIsAnimationLocked) {
                throw new RuntimeException("Returning to user's finger. Avoid animations while mIsAnimationLocked flag is set.");
            }
            this.mDestX = this.calculateX();
            this.mDestY = this.calculateY();
            this.mDynamicUpdate = null;
            this.setAnimationFinishedListener(new AnimationFinishedListener(){

                @Override
                public void onAnimationFinished() {
                    FloatingView.this.adjustInactivePosition();
                }
            });
            float velocityX = FloatingView.this.calculateVelocityX();
            float velocityY = FloatingView.this.calculateVelocityY();
            this.mTension = (float)((double)this.mTension + Math.sqrt(FloatingView.this.sqr(velocityX) + FloatingView.this.sqr(velocityY)) / 200.0);
            this.mInterpolator = new OvershootInterpolator(this.mTension);
            FloatingView.this.mCurrentPosX = this.mDestX;
            FloatingView.this.mCurrentPosY = this.mDestY;
        }

        public void setDuration(long duration) {
            this.mDuration = duration;
        }

        void setAnimationFinishedListener(AnimationFinishedListener l) {
            this.mAnimationFinishedListener = l;
        }

        public void setInterpolator(Interpolator interpolator) {
            this.mInterpolator = interpolator;
        }

        private int calculateX() {
            int destX;
            float velocityX = FloatingView.this.calculateVelocityX();
            int screenWidth = FloatingView.this.getScreenWidth();
            int leftSide = FloatingView.this.getIconHorizontalMargin();
            int rightSide = screenWidth - FloatingView.this.mDraggableIcon.getWidth() - FloatingView.this.getIconHorizontalMargin();
            int n = destX = FloatingView.this.mCurrentPosX + FloatingView.this.mIconSize / 2 > screenWidth / 2 ? rightSide : leftSide;
            if (Math.abs(velocityX) > 50.0f) {
                destX = velocityX > 0.0f ? rightSide : leftSide;
            }
            return destX;
        }

        private int calculateY() {
            float velocityY = FloatingView.this.calculateVelocityY();
            int screenHeight = FloatingView.this.getScreenHeight();
            int destY = FloatingView.this.mCurrentPosY + (int)(velocityY * 3.0f);
            if (destY <= 0) {
                destY = FloatingView.this.getIconVerticalMargin();
            } else if (destY >= screenHeight - FloatingView.this.mIconSize) {
                destY = screenHeight - FloatingView.this.mIconSize - FloatingView.this.getIconVerticalMargin();
            }
            return destY;
        }

        void run() {
            if (this.mDynamicUpdate == null) {
                FloatingView.this.mDraggableIcon.animate().translationX((float)this.mDestX).translationY((float)this.mDestY).setDuration(this.mDuration).setInterpolator((TimeInterpolator)this.mInterpolator).setListener((Animator.AnimatorListener)this.mAnimationFinishedListener);
            } else {
                ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, 100});
                animator.addUpdateListener(valueAnimator -> {
                    float percent = valueAnimator.getAnimatedFraction();
                    FloatingView.this.mDraggableIcon.setTranslationX(this.mDynamicUpdate.getTranslationX(percent));
                    FloatingView.this.mDraggableIcon.setTranslationY(this.mDynamicUpdate.getTranslationY(percent));
                });
                animator.setDuration(this.mDuration);
                animator.setInterpolator((TimeInterpolator)this.mInterpolator);
                animator.addListener((Animator.AnimatorListener)this.mAnimationFinishedListener);
                animator.start();
            }
        }

        void cancel() {
            FloatingView.this.mDraggableIcon.animate().cancel();
        }
    }
}

