/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.inventory;

import com.google.gson.GsonBuilder;
import com.xsolla.android.inventory.api.InventoryApi;
import com.xsolla.android.inventory.callback.ConsumeItemCallback;
import com.xsolla.android.inventory.callback.GetInventoryCallback;
import com.xsolla.android.inventory.callback.GetTimeLimitedItemsCallback;
import com.xsolla.android.inventory.callback.GetVirtualBalanceCallback;
import com.xsolla.android.inventory.entity.request.ConsumeItemBody;
import com.xsolla.android.inventory.entity.response.InventoryResponse;
import com.xsolla.android.inventory.entity.response.TimeLimitedItemsResponse;
import com.xsolla.android.inventory.entity.response.VirtualBalanceResponse;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J/\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/xsolla/android/inventory/RequestExecutor;", "", "projectId", "", "inventoryApi", "Lcom/xsolla/android/inventory/api/InventoryApi;", "(ILcom/xsolla/android/inventory/api/InventoryApi;)V", "consumeItem", "", "sku", "", "quantity", "", "instanceId", "callback", "Lcom/xsolla/android/inventory/callback/ConsumeItemCallback;", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Lcom/xsolla/android/inventory/callback/ConsumeItemCallback;)V", "getErrorMessage", "errorBody", "Lokhttp3/ResponseBody;", "getInventory", "Lcom/xsolla/android/inventory/callback/GetInventoryCallback;", "limit", "offset", "getTimeLimitedItems", "Lcom/xsolla/android/inventory/callback/GetTimeLimitedItemsCallback;", "getVirtualBalance", "Lcom/xsolla/android/inventory/callback/GetVirtualBalanceCallback;", "xsolla-inventory-sdk_release"})
public final class RequestExecutor {
    private final int projectId;
    @NotNull
    private final InventoryApi inventoryApi;

    public RequestExecutor(int projectId, @NotNull InventoryApi inventoryApi) {
        Intrinsics.checkNotNullParameter((Object)inventoryApi, (String)"inventoryApi");
        this.projectId = projectId;
        this.inventoryApi = inventoryApi;
    }

    public final void getInventory(@NotNull GetInventoryCallback callback, int limit, int offset) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.inventoryApi.getInventory(this.projectId, limit, offset, "android_standalone").enqueue((Callback)new Callback<InventoryResponse>(callback, this){
            final /* synthetic */ GetInventoryCallback $callback;
            final /* synthetic */ RequestExecutor this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<InventoryResponse> call, @NotNull Response<InventoryResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    InventoryResponse inventory = (InventoryResponse)response.body();
                    if (inventory != null) {
                        this.$callback.onSuccess(inventory);
                    } else {
                        this.$callback.onError(null, "Empty response");
                    }
                } else {
                    this.$callback.onError(null, RequestExecutor.access$getErrorMessage(this.this$0, response.errorBody()));
                }
            }

            public void onFailure(@NotNull Call<InventoryResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.onError(t, null);
            }
        });
    }

    public final void getVirtualBalance(@NotNull GetVirtualBalanceCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.inventoryApi.getVirtualBalance(this.projectId, "android_standalone").enqueue((Callback)new Callback<VirtualBalanceResponse>(callback, this){
            final /* synthetic */ GetVirtualBalanceCallback $callback;
            final /* synthetic */ RequestExecutor this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<VirtualBalanceResponse> call, @NotNull Response<VirtualBalanceResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    VirtualBalanceResponse virtualBalance = (VirtualBalanceResponse)response.body();
                    if (virtualBalance != null) {
                        this.$callback.onSuccess(virtualBalance);
                    } else {
                        this.$callback.onError(null, "Empty response");
                    }
                } else {
                    this.$callback.onError(null, RequestExecutor.access$getErrorMessage(this.this$0, response.errorBody()));
                }
            }

            public void onFailure(@NotNull Call<VirtualBalanceResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.onError(t, null);
            }
        });
    }

    public final void getTimeLimitedItems(@NotNull GetTimeLimitedItemsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.inventoryApi.getTimeLimitedItems(this.projectId, "android_standalone").enqueue((Callback)new Callback<TimeLimitedItemsResponse>(callback, this){
            final /* synthetic */ GetTimeLimitedItemsCallback $callback;
            final /* synthetic */ RequestExecutor this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<TimeLimitedItemsResponse> call, @NotNull Response<TimeLimitedItemsResponse> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    TimeLimitedItemsResponse timeLimitedItems = (TimeLimitedItemsResponse)response.body();
                    if (timeLimitedItems != null) {
                        this.$callback.onSuccess(timeLimitedItems);
                    } else {
                        this.$callback.onError(null, "Empty response");
                    }
                } else {
                    this.$callback.onError(null, RequestExecutor.access$getErrorMessage(this.this$0, response.errorBody()));
                }
            }

            public void onFailure(@NotNull Call<TimeLimitedItemsResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.onError(t, null);
            }
        });
    }

    public final void consumeItem(@NotNull String sku, @Nullable Long quantity, @Nullable String instanceId, @NotNull ConsumeItemCallback callback) {
        Intrinsics.checkNotNullParameter((Object)sku, (String)"sku");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ConsumeItemBody consumeItemBody = new ConsumeItemBody(sku, quantity, instanceId);
        String string = new GsonBuilder().serializeNulls().create().toJson((Object)consumeItemBody);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GsonBuilder().serializeN\u2026).toJson(consumeItemBody)");
        String jsonString = string;
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString);
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"requestBody");
        this.inventoryApi.consumeItem(this.projectId, "android_standalone", requestBody).enqueue((Callback)new Callback<Void>(callback, this){
            final /* synthetic */ ConsumeItemCallback $callback;
            final /* synthetic */ RequestExecutor this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<Void> call, @NotNull Response<Void> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                if (response.isSuccessful()) {
                    this.$callback.onSuccess();
                } else {
                    this.$callback.onError(null, RequestExecutor.access$getErrorMessage(this.this$0, response.errorBody()));
                }
            }

            public void onFailure(@NotNull Call<Void> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$callback.onError(t, null);
            }
        });
    }

    private final String getErrorMessage(ResponseBody errorBody) {
        try {
            if (errorBody != null) {
                JSONObject errorObject = new JSONObject(errorBody.string());
                return errorObject.getString("errorMessage");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "Unknown Error";
    }

    public static final /* synthetic */ String access$getErrorMessage(RequestExecutor $this, ResponseBody errorBody) {
        return $this.getErrorMessage(errorBody);
    }
}

