/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.inventory;

import android.os.Build;
import com.xsolla.android.inventory.RequestExecutor;
import com.xsolla.android.inventory.api.InventoryApi;
import com.xsolla.android.inventory.callback.ConsumeItemCallback;
import com.xsolla.android.inventory.callback.GetInventoryCallback;
import com.xsolla.android.inventory.callback.GetTimeLimitedItemsCallback;
import com.xsolla.android.inventory.callback.GetVirtualBalanceCallback;
import com.xsolla.android.inventory.util.AnalyticsUtils;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xsolla/android/inventory/XInventory;", "", "requestExecutor", "Lcom/xsolla/android/inventory/RequestExecutor;", "(Lcom/xsolla/android/inventory/RequestExecutor;)V", "Companion", "xsolla-inventory-sdk_release"})
public final class XInventory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestExecutor requestExecutor;
    @NotNull
    private static final String INVENTORY_HOST = "https://store.xsolla.com";
    @Nullable
    private static XInventory instance;

    private XInventory(RequestExecutor requestExecutor) {
        this.requestExecutor = requestExecutor;
    }

    @JvmStatic
    public static final void init(int projectId, @NotNull String token) {
        Companion.init(projectId, token);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getInventory(@NotNull GetInventoryCallback callback, int limit, int offset) {
        Companion.getInventory(callback, limit, offset);
    }

    @JvmStatic
    public static final void getVirtualBalance(@NotNull GetVirtualBalanceCallback callback) {
        Companion.getVirtualBalance(callback);
    }

    @JvmStatic
    public static final void getTimeLimitedItems(@NotNull GetTimeLimitedItemsCallback callback) {
        Companion.getTimeLimitedItems(callback);
    }

    @JvmStatic
    public static final void consumeItem(@NotNull String sku, @Nullable Long quantity, @Nullable String instanceId, @NotNull ConsumeItemCallback callback) {
        Companion.consumeItem(sku, quantity, instanceId, callback);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getInventory(@NotNull GetInventoryCallback callback, int limit) {
        Companion.getInventory(callback, limit);
    }

    @JvmStatic
    @JvmOverloads
    public static final void getInventory(@NotNull GetInventoryCallback callback) {
        Companion.getInventory(callback);
    }

    public /* synthetic */ XInventory(RequestExecutor requestExecutor, DefaultConstructorMarker $constructor_marker) {
        this(requestExecutor);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0006H\u0002J$\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014H\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/xsolla/android/inventory/XInventory$Companion;", "", "()V", "INVENTORY_HOST", "", "instance", "Lcom/xsolla/android/inventory/XInventory;", "consumeItem", "", "sku", "quantity", "", "instanceId", "callback", "Lcom/xsolla/android/inventory/callback/ConsumeItemCallback;", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Lcom/xsolla/android/inventory/callback/ConsumeItemCallback;)V", "getInstance", "getInventory", "Lcom/xsolla/android/inventory/callback/GetInventoryCallback;", "limit", "", "offset", "getRequestExecutor", "Lcom/xsolla/android/inventory/RequestExecutor;", "getTimeLimitedItems", "Lcom/xsolla/android/inventory/callback/GetTimeLimitedItemsCallback;", "getVirtualBalance", "Lcom/xsolla/android/inventory/callback/GetVirtualBalanceCallback;", "init", "projectId", "token", "xsolla-inventory-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        private final XInventory getInstance() {
            if (instance == null) {
                throw new IllegalStateException("Inventory SDK not initialized. Call \"com.xsolla.android.inventory.XInventory.init()\" first");
            }
            XInventory xInventory = instance;
            Intrinsics.checkNotNull((Object)xInventory);
            return xInventory;
        }

        @JvmStatic
        public final void init(int projectId, @NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Interceptor interceptor = arg_0 -> Companion.init$lambda-0(token, arg_0);
            OkHttpClient.Builder httpClient = new OkHttpClient().newBuilder();
            httpClient.addInterceptor(interceptor);
            Retrofit retrofit = new Retrofit.Builder().baseUrl(XInventory.INVENTORY_HOST).client(httpClient.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
            Object object = retrofit.create(InventoryApi.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(InventoryApi::class.java)");
            InventoryApi inventoryApi = (InventoryApi)object;
            RequestExecutor requestExecutor = new RequestExecutor(projectId, inventoryApi);
            instance = new XInventory(requestExecutor, null);
        }

        private final RequestExecutor getRequestExecutor() {
            return this.getInstance().requestExecutor;
        }

        @JvmStatic
        @JvmOverloads
        public final void getInventory(@NotNull GetInventoryCallback callback, int limit, int offset) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.getRequestExecutor().getInventory(callback, limit, offset);
        }

        public static /* synthetic */ void getInventory$default(Companion companion, GetInventoryCallback getInventoryCallback, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 50;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            companion.getInventory(getInventoryCallback, n, n2);
        }

        @JvmStatic
        public final void getVirtualBalance(@NotNull GetVirtualBalanceCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.getRequestExecutor().getVirtualBalance(callback);
        }

        @JvmStatic
        public final void getTimeLimitedItems(@NotNull GetTimeLimitedItemsCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.getRequestExecutor().getTimeLimitedItems(callback);
        }

        @JvmStatic
        public final void consumeItem(@NotNull String sku, @Nullable Long quantity, @Nullable String instanceId, @NotNull ConsumeItemCallback callback) {
            Intrinsics.checkNotNullParameter((Object)sku, (String)"sku");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.getRequestExecutor().consumeItem(sku, quantity, instanceId, callback);
        }

        @JvmStatic
        @JvmOverloads
        public final void getInventory(@NotNull GetInventoryCallback callback, int limit) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            com.xsolla.android.inventory.XInventory$Companion.getInventory$default(this, callback, limit, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void getInventory(@NotNull GetInventoryCallback callback) {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            com.xsolla.android.inventory.XInventory$Companion.getInventory$default(this, callback, 0, 0, 6, null);
        }

        private static final Response init$lambda-0(String $token, Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)$token, (String)"$token");
            Request originalRequest = chain.request();
            Request.Builder builder = originalRequest.newBuilder().addHeader("Authorization", "Bearer " + $token).addHeader("X-ENGINE", "ANDROID").addHeader("X-ENGINE-V", Build.VERSION.RELEASE);
            String string = AnalyticsUtils.getSdk().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            Request.Builder builder2 = builder.addHeader("X-SDK", string);
            String string2 = AnalyticsUtils.getSdkVersion().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            Request.Builder requestBuilder = builder2.addHeader("X-SDK-V", string2);
            HttpUrl.Builder urlBuilder = originalRequest.url().newBuilder().addQueryParameter("engine", "android").addQueryParameter("engine_v", Build.VERSION.RELEASE).addQueryParameter("sdk", AnalyticsUtils.getSdk()).addQueryParameter("sdk_v", AnalyticsUtils.getSdkVersion());
            if (!StringsKt.isBlank((CharSequence)AnalyticsUtils.getGameEngine())) {
                String string3 = AnalyticsUtils.getGameEngine().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                requestBuilder.addHeader("X-GAME-ENGINE", string3);
                urlBuilder.addQueryParameter("game_engine", AnalyticsUtils.getGameEngine());
            }
            if (!StringsKt.isBlank((CharSequence)AnalyticsUtils.getGameEngineVersion())) {
                String string4 = AnalyticsUtils.getGameEngineVersion().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                requestBuilder.addHeader("X-GAME-ENGINE-V", string4);
                urlBuilder.addQueryParameter("game_engine_v", AnalyticsUtils.getGameEngineVersion());
            }
            requestBuilder.url(urlBuilder.build());
            Request newRequest = requestBuilder.build();
            return chain.proceed(newRequest);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

