/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.core.os.BundleKt;
import com.xsolla.android.payments.api.PaymentsApi;
import com.xsolla.android.payments.caching.PayStationCache;
import com.xsolla.android.payments.callbacks.GetStatusCallback;
import com.xsolla.android.payments.callbacks.PayStationClosedCallback;
import com.xsolla.android.payments.callbacks.StatusReceivedCallback;
import com.xsolla.android.payments.data.AccessToken;
import com.xsolla.android.payments.entity.response.InvoicesDataResponse;
import com.xsolla.android.payments.tracker.StatusTracker;
import com.xsolla.android.payments.ui.ActivityOrientationLock;
import com.xsolla.android.payments.ui.ActivityType;
import com.xsolla.android.payments.ui.utils.BrowserUtils;
import com.xsolla.android.payments.ui.utils.TrustedWebActivityImageRef;
import com.xsolla.android.payments.util.AnalyticsUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \r2\u00020\u0001:\u0006\r\u000e\u000f\u0010\u0011\u0012B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/xsolla/android/payments/XPayments;", "", "statusTracker", "Lcom/xsolla/android/payments/tracker/StatusTracker;", "paymentsApi", "Lcom/xsolla/android/payments/api/PaymentsApi;", "(Lcom/xsolla/android/payments/tracker/StatusTracker;Lcom/xsolla/android/payments/api/PaymentsApi;)V", "paymentInfoByToken", "", "", "Lcom/xsolla/android/payments/XPayments$PaymentInfo;", "getPaymentsApi$xsolla_payments_sdk_release", "()Lcom/xsolla/android/payments/api/PaymentsApi;", "Companion", "IntentBuilder", "PayStationVersion", "PaymentInfo", "Result", "Status", "xsolla-payments-sdk_release"})
public final class XPayments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StatusTracker statusTracker;
    @NotNull
    private final PaymentsApi paymentsApi;
    @NotNull
    private Map<String, PaymentInfo> paymentInfoByToken;
    @NotNull
    private static final String TAG = "XPayments";
    @Nullable
    private static XPayments instance;
    @NotNull
    public static final String SERVER_PROD = "secure.xsolla.com";
    @NotNull
    public static final String SERVER_SANDBOX = "sandbox-secure.xsolla.com";

    private XPayments(StatusTracker statusTracker, PaymentsApi paymentsApi) {
        this.statusTracker = statusTracker;
        this.paymentsApi = paymentsApi;
        this.paymentInfoByToken = new LinkedHashMap();
    }

    @NotNull
    public final PaymentsApi getPaymentsApi$xsolla_payments_sdk_release() {
        return this.paymentsApi;
    }

    @JvmStatic
    @NotNull
    public static final IntentBuilder createIntentBuilder(@NotNull Context context) {
        return Companion.createIntentBuilder(context);
    }

    @JvmStatic
    public static final void getStatus(@NotNull String token, boolean isSandbox, @NotNull GetStatusCallback callback) {
        Companion.getStatus(token, isSandbox, callback);
    }

    @JvmStatic
    public static final void payStationWasClosed$xsolla_payments_sdk_release(@NotNull String accessToken, boolean isManually) {
        Companion.payStationWasClosed$xsolla_payments_sdk_release(accessToken, isManually);
    }

    @JvmStatic
    @JvmOverloads
    private static final void addToTracking(String token, boolean isSandbox, StatusReceivedCallback callback, int requestsCount) {
        XPayments.Companion.addToTracking(token, isSandbox, callback, requestsCount);
    }

    @JvmStatic
    @JvmOverloads
    private static final void addToTracking(String token, boolean isSandbox, StatusReceivedCallback callback) {
        XPayments.Companion.addToTracking(token, isSandbox, callback);
    }

    public /* synthetic */ XPayments(StatusTracker statusTracker, PaymentsApi paymentsApi, DefaultConstructorMarker $constructor_marker) {
        this(statusTracker, paymentsApi);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0019\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0019H\u0007J\u001d\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/xsolla/android/payments/XPayments$Companion;", "", "()V", "SERVER_PROD", "", "SERVER_SANDBOX", "TAG", "instance", "Lcom/xsolla/android/payments/XPayments;", "addToTracking", "", "token", "isSandbox", "", "callback", "Lcom/xsolla/android/payments/callbacks/StatusReceivedCallback;", "requestsCount", "", "createIntentBuilder", "Lcom/xsolla/android/payments/XPayments$IntentBuilder;", "context", "Landroid/content/Context;", "getInstance", "(Ljava/lang/Boolean;)Lcom/xsolla/android/payments/XPayments;", "getStatus", "Lcom/xsolla/android/payments/callbacks/GetStatusCallback;", "payStationWasClosed", "accessToken", "isManually", "payStationWasClosed$xsolla_payments_sdk_release", "xsolla-payments-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        private final XPayments getInstance(Boolean isSandbox) {
            if (instance == null) {
                OkHttpClient.Builder httpClient = new OkHttpClient().newBuilder();
                Boolean bl = isSandbox;
                boolean isSandboxLocal = bl != null ? bl : false;
                String baseUrl = "https://" + (isSandboxLocal ? XPayments.SERVER_SANDBOX : XPayments.SERVER_PROD);
                Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(httpClient.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
                PaymentsApi paymentsApi = (PaymentsApi)retrofit.create(PaymentsApi.class);
                StatusTracker statusTracker = new StatusTracker(isSandboxLocal);
                Intrinsics.checkNotNullExpressionValue((Object)paymentsApi, (String)"paymentsApi");
                instance = new XPayments(statusTracker, paymentsApi, null);
            }
            XPayments xPayments = instance;
            Intrinsics.checkNotNull((Object)xPayments);
            return xPayments;
        }

        static /* synthetic */ XPayments getInstance$default(Companion companion, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = null;
            }
            return companion.getInstance(bl);
        }

        @JvmStatic
        @NotNull
        public final IntentBuilder createIntentBuilder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new IntentBuilder(context);
        }

        @JvmStatic
        public final void getStatus(@NotNull String token, boolean isSandbox, @NotNull GetStatusCallback callback) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            this.getInstance(isSandbox).getPaymentsApi$xsolla_payments_sdk_release().getStatus(token).enqueue((Callback)new Callback<InvoicesDataResponse>(callback){
                final /* synthetic */ GetStatusCallback $callback;
                {
                    this.$callback = $callback;
                }

                public void onResponse(@NotNull Call<InvoicesDataResponse> call, @NotNull Response<InvoicesDataResponse> response) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter(response, (String)"response");
                    if (response.isSuccessful()) {
                        InvoicesDataResponse responseBody = (InvoicesDataResponse)response.body();
                        if (responseBody != null) {
                            this.$callback.onSuccess(responseBody);
                        } else {
                            this.$callback.onError(null, "Empty response");
                        }
                    } else {
                        this.$callback.onSuccess(null);
                    }
                }

                public void onFailure(@NotNull Call<InvoicesDataResponse> call, @NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter(call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    this.$callback.onError(null, t.getMessage());
                }
            });
        }

        @JvmStatic
        public final void payStationWasClosed$xsolla_payments_sdk_release(@NotNull String accessToken, boolean isManually) {
            PaymentInfo callbacksObj;
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            if (!com.xsolla.android.payments.XPayments$Companion.getInstance$default(this, null, 1, null).paymentInfoByToken.containsKey(accessToken)) {
                Log.d((String)XPayments.TAG, (String)"Can't find token in callbacks map");
                return;
            }
            PaymentInfo paymentInfo = callbacksObj = (PaymentInfo)com.xsolla.android.payments.XPayments$Companion.getInstance$default(this, null, 1, null).paymentInfoByToken.get(accessToken);
            if (paymentInfo != null) {
                PaymentInfo obj = paymentInfo;
                boolean bl = false;
                PayStationClosedCallback payStationClosedCallback = obj.getPayStationClosedCallback();
                if (payStationClosedCallback != null) {
                    payStationClosedCallback.onSuccess(isManually);
                }
                StatusReceivedCallback statusReceivedCallback = obj.getStatusReceivedCallback();
                if (statusReceivedCallback != null) {
                    StatusReceivedCallback callback = statusReceivedCallback;
                    boolean bl2 = false;
                    if (!obj.isFinishedStatusReceived()) {
                        StatusTracker statusTracker = com.xsolla.android.payments.XPayments$Companion.getInstance$default(Companion, null, 1, null).statusTracker;
                        if (statusTracker != null) {
                            statusTracker.restartTracking(accessToken, 3);
                        }
                    }
                }
            }
            com.xsolla.android.payments.XPayments$Companion.getInstance$default(this, null, 1, null).paymentInfoByToken.remove(accessToken);
        }

        @JvmStatic
        @JvmOverloads
        private final void addToTracking(String token, boolean isSandbox, StatusReceivedCallback callback, int requestsCount) {
            this.getInstance(isSandbox).statusTracker.addToTracking(new StatusReceivedCallback(callback, isSandbox, token){
                final /* synthetic */ StatusReceivedCallback $callback;
                final /* synthetic */ boolean $isSandbox;
                final /* synthetic */ String $token;
                {
                    this.$callback = $callback;
                    this.$isSandbox = $isSandbox;
                    this.$token = $token;
                }

                public void onSuccess(@NotNull InvoicesDataResponse data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    this.$callback.onSuccess(data);
                    if (data.isWithFinishedStatus()) {
                        PaymentInfo paymentInfo = (PaymentInfo)XPayments.access$getPaymentInfoByToken$p(com.xsolla.android.payments.XPayments$Companion.access$getInstance(XPayments.Companion, this.$isSandbox)).get(this.$token);
                        if (paymentInfo != null) {
                            paymentInfo.setFinishedStatusReceived(true);
                        }
                    }
                }
            }, token, requestsCount);
        }

        static /* synthetic */ void addToTracking$default(Companion companion, String string, boolean bl, StatusReceivedCallback statusReceivedCallback, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 9999;
            }
            companion.addToTracking(string, bl, statusReceivedCallback, n);
        }

        @JvmStatic
        @JvmOverloads
        private final void addToTracking(String token, boolean isSandbox, StatusReceivedCallback callback) {
            com.xsolla.android.payments.XPayments$Companion.addToTracking$default(this, token, isSandbox, callback, 0, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002J\b\u0010\"\u001a\u00020\u0013H\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0011J\u0010\u0010$\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0010\u0010%\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\fJ\u0010\u0010(\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u0016J\u0010\u00100\u001a\u00020\u00002\b\u00101\u001a\u0004\u0018\u00010\u0018J\u0010\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u00020\fH\u0007R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/xsolla/android/payments/XPayments$IntentBuilder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "accessToken", "Lcom/xsolla/android/payments/data/AccessToken;", "activityOrientationLock", "Lcom/xsolla/android/payments/ui/ActivityOrientationLock;", "activityType", "Lcom/xsolla/android/payments/ui/ActivityType;", "forceSystemBrowser", "", "isSandbox", "payStationClosedCallback", "Lcom/xsolla/android/payments/callbacks/PayStationClosedCallback;", "payStationVersion", "Lcom/xsolla/android/payments/XPayments$PayStationVersion;", "redirectHost", "", "redirectScheme", "statusReceivedCallback", "Lcom/xsolla/android/payments/callbacks/StatusReceivedCallback;", "trustedWebActivityImageRef", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivityImageRef;", "appendAnalytics", "", "builder", "Landroid/net/Uri$Builder;", "build", "Landroid/content/Intent;", "generateUrl", "getPayStationVersionPath", "getServer", "getTokenQueryParameterName", "version", "setActivityOrientationLock", "setActivityType", "setForceSystemBrowser", "force", "setPayStationClosedCallback", "callback", "setRedirectUriHost", "setRedirectUriScheme", "setShortPollingTimeout", "timeout", "", "setStatusReceivedCallback", "setTrustedWebActivityImage", "ref", "useWebview", "xsolla-payments-sdk_release"})
    public static final class IntentBuilder {
        @NotNull
        private final Context context;
        @Nullable
        private AccessToken accessToken;
        private boolean isSandbox;
        @NotNull
        private PayStationVersion payStationVersion;
        @NotNull
        private String redirectScheme;
        @NotNull
        private String redirectHost;
        @Nullable
        private ActivityType activityType;
        @Nullable
        private ActivityOrientationLock activityOrientationLock;
        @Nullable
        private TrustedWebActivityImageRef trustedWebActivityImageRef;
        private boolean forceSystemBrowser;
        @Nullable
        private PayStationClosedCallback payStationClosedCallback;
        @Nullable
        private StatusReceivedCallback statusReceivedCallback;

        public IntentBuilder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.isSandbox = true;
            this.payStationVersion = PayStationVersion.V4;
            this.redirectScheme = "app";
            this.redirectHost = "xpayment." + this.context.getPackageName();
        }

        @NotNull
        public final IntentBuilder accessToken(@NotNull AccessToken accessToken) {
            IntentBuilder intentBuilder;
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            IntentBuilder $this$accessToken_u24lambda_u2d0 = intentBuilder = this;
            boolean bl = false;
            $this$accessToken_u24lambda_u2d0.accessToken = accessToken;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder isSandbox(boolean isSandbox) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$isSandbox_u24lambda_u2d1 = intentBuilder = this;
            boolean bl = false;
            $this$isSandbox_u24lambda_u2d1.isSandbox = isSandbox;
            return intentBuilder;
        }

        @Deprecated(message="WebView usage is not recommended. Also, use `setActivityType()` instead.", replaceWith=@ReplaceWith(expression="setActivityType(ActivityType.WEB_VIEW)", imports={"com.xsolla.android.payments.ui.ActivityType"}))
        @NotNull
        public final IntentBuilder useWebview(boolean useWebview) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$useWebview_u24lambda_u2d2 = intentBuilder = this;
            boolean bl = false;
            $this$useWebview_u24lambda_u2d2.setActivityType(ActivityType.WEB_VIEW);
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setRedirectUriScheme(@NotNull String redirectScheme) {
            IntentBuilder intentBuilder;
            Intrinsics.checkNotNullParameter((Object)redirectScheme, (String)"redirectScheme");
            IntentBuilder $this$setRedirectUriScheme_u24lambda_u2d3 = intentBuilder = this;
            boolean bl = false;
            String string = redirectScheme.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            $this$setRedirectUriScheme_u24lambda_u2d3.redirectScheme = string;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setRedirectUriHost(@NotNull String redirectHost) {
            IntentBuilder intentBuilder;
            Intrinsics.checkNotNullParameter((Object)redirectHost, (String)"redirectHost");
            IntentBuilder $this$setRedirectUriHost_u24lambda_u2d4 = intentBuilder = this;
            boolean bl = false;
            String string = redirectHost.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            $this$setRedirectUriHost_u24lambda_u2d4.redirectHost = string;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder payStationVersion(@NotNull PayStationVersion version) {
            IntentBuilder intentBuilder;
            Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
            IntentBuilder $this$payStationVersion_u24lambda_u2d5 = intentBuilder = this;
            boolean bl = false;
            $this$payStationVersion_u24lambda_u2d5.payStationVersion = version;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setActivityType(@Nullable ActivityType activityType) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$setActivityType_u24lambda_u2d6 = intentBuilder = this;
            boolean bl = false;
            $this$setActivityType_u24lambda_u2d6.activityType = activityType;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setActivityOrientationLock(@Nullable ActivityOrientationLock activityOrientationLock) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$setActivityOrientationLock_u24lambda_u2d7 = intentBuilder = this;
            boolean bl = false;
            $this$setActivityOrientationLock_u24lambda_u2d7.activityOrientationLock = activityOrientationLock;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setTrustedWebActivityImage(@Nullable TrustedWebActivityImageRef ref) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$setTrustedWebActivityImage_u24lambda_u2d8 = intentBuilder = this;
            boolean bl = false;
            $this$setTrustedWebActivityImage_u24lambda_u2d8.trustedWebActivityImageRef = ref;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setForceSystemBrowser(boolean force) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$setForceSystemBrowser_u24lambda_u2d9 = intentBuilder = this;
            boolean bl = false;
            $this$setForceSystemBrowser_u24lambda_u2d9.forceSystemBrowser = force;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setPayStationClosedCallback(@Nullable PayStationClosedCallback callback) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$setPayStationClosedCallback_u24lambda_u2d10 = intentBuilder = this;
            boolean bl = false;
            $this$setPayStationClosedCallback_u24lambda_u2d10.payStationClosedCallback = callback;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setStatusReceivedCallback(@Nullable StatusReceivedCallback callback) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$setStatusReceivedCallback_u24lambda_u2d11 = intentBuilder = this;
            boolean bl = false;
            $this$setStatusReceivedCallback_u24lambda_u2d11.statusReceivedCallback = callback;
            return intentBuilder;
        }

        @NotNull
        public final IntentBuilder setShortPollingTimeout(long timeout) {
            IntentBuilder intentBuilder;
            IntentBuilder $this$setShortPollingTimeout_u24lambda_u2d12 = intentBuilder = this;
            boolean bl = false;
            StatusTracker.Companion.setSHORT_POLLING_TIMEOUT$xsolla_payments_sdk_release(timeout * 1000L);
            return intentBuilder;
        }

        @NotNull
        public final Intent build() {
            Object object;
            String url = this.generateUrl();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)url), TuplesKt.to((Object)"redirect_scheme", (Object)this.redirectScheme), TuplesKt.to((Object)"redirect_host", (Object)this.redirectHost)};
            Bundle bundle = BundleKt.bundleOf((Pair[])pairArray);
            Log.d((String)XPayments.TAG, (String)("generated PayStation url: " + url));
            Log.d((String)XPayments.TAG, (String)("received redirect host: " + this.redirectHost + " and redirect scheme: " + this.redirectScheme));
            AccessToken accessToken = this.accessToken;
            if (accessToken != null) {
                AccessToken token = accessToken;
                boolean bl = false;
                bundle.putString("payment_token", token.getToken());
            }
            ActivityType activityType = this.activityType;
            if (activityType != null) {
                ActivityType activityType2 = activityType;
                boolean bl = false;
                bundle.putString("activity_type", activityType2.toString());
            }
            ActivityOrientationLock activityOrientationLock = this.activityOrientationLock;
            if (activityOrientationLock != null) {
                ActivityOrientationLock activityOrientationLock2 = activityOrientationLock;
                boolean bl = false;
                bundle.putString("activity_orientation_lock", activityOrientationLock2.toString());
            }
            if ((object = this.accessToken) != null && (object = ((AccessToken)object).getBackgroundColor()) != null) {
                int color = ((Number)object).intValue();
                boolean bl = false;
                bundle.putInt("trusted_web_activity_background_color", color);
            }
            TrustedWebActivityImageRef trustedWebActivityImageRef = this.trustedWebActivityImageRef;
            if (trustedWebActivityImageRef != null) {
                TrustedWebActivityImageRef ref = trustedWebActivityImageRef;
                boolean bl = false;
                bundle.putParcelable("trusted_web_activity_image_ref", (Parcelable)ref);
            }
            bundle.putBoolean("force_system_browser", this.forceSystemBrowser);
            AccessToken accessToken2 = this.accessToken;
            if (accessToken2 != null) {
                AccessToken aToken = accessToken2;
                boolean bl = false;
                StatusReceivedCallback statusReceivedCallback = this.statusReceivedCallback;
                if (statusReceivedCallback != null) {
                    StatusReceivedCallback callback = statusReceivedCallback;
                    boolean bl2 = false;
                    Companion.addToTracking(aToken.getToken(), this.isSandbox, callback, 9999);
                }
                if (this.statusReceivedCallback != null || this.payStationClosedCallback != null) {
                    if (Companion.getInstance(this.isSandbox).paymentInfoByToken.containsKey(aToken.getToken())) {
                        Log.d((String)XPayments.TAG, (String)"Pay Station with this token has already opened");
                    } else {
                        Companion.getInstance(this.isSandbox).paymentInfoByToken.put(aToken.getToken(), new PaymentInfo(this.payStationClosedCallback, this.statusReceivedCallback, this.isSandbox, false, 8, null));
                    }
                }
            }
            Intent intent = PayStationCache.Companion.getInstance(this.context).getCachedIntent().putExtras(bundle);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"PayStationCache.getInsta\u2026ntent().putExtras(bundle)");
            return intent;
        }

        private final String generateUrl() {
            AccessToken accessToken = this.accessToken;
            if (accessToken != null) {
                AccessToken it = accessToken;
                boolean bl = false;
                Uri.Builder uriBuilder = new Uri.Builder().scheme("https").authority(this.getServer()).appendPath(this.getPayStationVersionPath()).appendQueryParameter(this.getTokenQueryParameterName(), it.getToken());
                Intrinsics.checkNotNullExpressionValue((Object)uriBuilder, (String)"uriBuilder");
                this.appendAnalytics(uriBuilder);
                String string = uriBuilder.build().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uriBuilder.build().toString()");
                return string;
            }
            throw new IllegalArgumentException("access token isn't specified");
        }

        private final String getServer() {
            return this.isSandbox ? XPayments.SERVER_SANDBOX : XPayments.SERVER_PROD;
        }

        private final void appendAnalytics(Uri.Builder builder) {
            String string;
            if (this.forceSystemBrowser) {
                string = "system";
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[BrowserUtils.INSTANCE.deduceActivityType(this.context, this.activityType).ordinal()]) {
                    case 1: {
                        string = "web_view";
                        break;
                    }
                    case 2: {
                        string = "custom_tabs";
                        break;
                    }
                    case 3: {
                        string = "trusted_web_activity";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            String browserType = string;
            builder.appendQueryParameter("engine", "android");
            builder.appendQueryParameter("engine_v", Build.VERSION.RELEASE);
            builder.appendQueryParameter("sdk", AnalyticsUtils.getSdk());
            builder.appendQueryParameter("sdk_v", AnalyticsUtils.getSdkVersion());
            builder.appendQueryParameter("browser_type", browserType);
            if (!StringsKt.isBlank((CharSequence)AnalyticsUtils.getGameEngine())) {
                builder.appendQueryParameter("game_engine", AnalyticsUtils.getGameEngine());
            }
            if (!StringsKt.isBlank((CharSequence)AnalyticsUtils.getGameEngineVersion())) {
                builder.appendQueryParameter("game_engine_v", AnalyticsUtils.getGameEngineVersion());
            }
        }

        private final String getPayStationVersionPath() {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$1[this.payStationVersion.ordinal()]) {
                case 1: {
                    string = "paystation3";
                    break;
                }
                case 2: {
                    string = "paystation4";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        private final String getTokenQueryParameterName() {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$1[this.payStationVersion.ordinal()]) {
                case 1: {
                    string = "access_token";
                    break;
                }
                case 2: {
                    string = "token";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[ActivityType.values().length];
                nArray[ActivityType.WEB_VIEW.ordinal()] = 1;
                nArray[ActivityType.CUSTOM_TABS.ordinal()] = 2;
                nArray[ActivityType.TRUSTED_WEB_ACTIVITY.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[PayStationVersion.values().length];
                nArray[PayStationVersion.V3.ordinal()] = 1;
                nArray[PayStationVersion.V4.ordinal()] = 2;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\u0019\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/xsolla/android/payments/XPayments$Result;", "Landroid/os/Parcelable;", "status", "Lcom/xsolla/android/payments/XPayments$Status;", "invoiceId", "", "(Lcom/xsolla/android/payments/XPayments$Status;Ljava/lang/String;)V", "getInvoiceId", "()Ljava/lang/String;", "getStatus", "()Lcom/xsolla/android/payments/XPayments$Status;", "component1", "component2", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "Companion", "xsolla-payments-sdk_release"})
    @Parcelize
    public static final class Result
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Status status;
        @Nullable
        private final String invoiceId;
        @NotNull
        public static final Parcelable.Creator<Result> CREATOR;

        public Result(@NotNull Status status, @Nullable String invoiceId) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.status = status;
            this.invoiceId = invoiceId;
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @Nullable
        public final String getInvoiceId() {
            return this.invoiceId;
        }

        @NotNull
        public final Status component1() {
            return this.status;
        }

        @Nullable
        public final String component2() {
            return this.invoiceId;
        }

        @NotNull
        public final Result copy(@NotNull Status status, @Nullable String invoiceId) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            return new Result(status, invoiceId);
        }

        public static /* synthetic */ Result copy$default(Result result, Status status, String string, int n, Object object) {
            if ((n & 1) != 0) {
                status = result.status;
            }
            if ((n & 2) != 0) {
                string = result.invoiceId;
            }
            return result.copy(status, string);
        }

        @NotNull
        public String toString() {
            return "Result(status=" + (Object)((Object)this.status) + ", invoiceId=" + this.invoiceId + ')';
        }

        public int hashCode() {
            int result = this.status.hashCode();
            result = result * 31 + (this.invoiceId == null ? 0 : this.invoiceId.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result = (Result)other;
            if (this.status != result.status) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.invoiceId, (Object)result.invoiceId);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.status.name());
            out.writeString(this.invoiceId);
        }

        @JvmStatic
        @NotNull
        public static final Result fromResultIntent(@Nullable Intent intent) {
            return Companion.fromResultIntent(intent);
        }

        static {
            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Result> {
                @NotNull
                public final Result[] newArray(int size) {
                    return new Result[size];
                }

                @NotNull
                public final Result createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Result(Status.valueOf(parcel.readString()), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/xsolla/android/payments/XPayments$Result$Companion;", "", "()V", "fromResultIntent", "Lcom/xsolla/android/payments/XPayments$Result;", "intent", "Landroid/content/Intent;", "xsolla-payments-sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Result fromResultIntent(@Nullable Intent intent) {
                Intent intent2 = intent;
                Result result = intent2 != null ? (Result)intent2.getParcelableExtra("result") : null;
                return result == null ? new Result(Status.UNKNOWN, null) : result;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/xsolla/android/payments/XPayments$Status;", "", "(Ljava/lang/String;I)V", "COMPLETED", "CANCELLED", "UNKNOWN", "xsolla-payments-sdk_release"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status COMPLETED = new Status();
        public static final /* enum */ Status CANCELLED = new Status();
        public static final /* enum */ Status UNKNOWN = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.COMPLETED, Status.CANCELLED, Status.UNKNOWN};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/xsolla/android/payments/XPayments$PayStationVersion;", "", "(Ljava/lang/String;I)V", "V3", "V4", "xsolla-payments-sdk_release"})
    public static final class PayStationVersion
    extends Enum<PayStationVersion> {
        public static final /* enum */ PayStationVersion V3 = new PayStationVersion();
        public static final /* enum */ PayStationVersion V4 = new PayStationVersion();
        private static final /* synthetic */ PayStationVersion[] $VALUES;

        public static PayStationVersion[] values() {
            return (PayStationVersion[])$VALUES.clone();
        }

        public static PayStationVersion valueOf(String value) {
            return Enum.valueOf(PayStationVersion.class, value);
        }

        static {
            $VALUES = payStationVersionArray = new PayStationVersion[]{PayStationVersion.V3, PayStationVersion.V4};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/xsolla/android/payments/XPayments$PaymentInfo;", "", "payStationClosedCallback", "Lcom/xsolla/android/payments/callbacks/PayStationClosedCallback;", "statusReceivedCallback", "Lcom/xsolla/android/payments/callbacks/StatusReceivedCallback;", "isSandbox", "", "isFinishedStatusReceived", "(Lcom/xsolla/android/payments/callbacks/PayStationClosedCallback;Lcom/xsolla/android/payments/callbacks/StatusReceivedCallback;ZZ)V", "()Z", "setFinishedStatusReceived", "(Z)V", "getPayStationClosedCallback", "()Lcom/xsolla/android/payments/callbacks/PayStationClosedCallback;", "getStatusReceivedCallback", "()Lcom/xsolla/android/payments/callbacks/StatusReceivedCallback;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "xsolla-payments-sdk_release"})
    public static final class PaymentInfo {
        @Nullable
        private final PayStationClosedCallback payStationClosedCallback;
        @Nullable
        private final StatusReceivedCallback statusReceivedCallback;
        private final boolean isSandbox;
        private boolean isFinishedStatusReceived;

        public PaymentInfo(@Nullable PayStationClosedCallback payStationClosedCallback, @Nullable StatusReceivedCallback statusReceivedCallback, boolean isSandbox, boolean isFinishedStatusReceived) {
            this.payStationClosedCallback = payStationClosedCallback;
            this.statusReceivedCallback = statusReceivedCallback;
            this.isSandbox = isSandbox;
            this.isFinishedStatusReceived = isFinishedStatusReceived;
        }

        public /* synthetic */ PaymentInfo(PayStationClosedCallback payStationClosedCallback, StatusReceivedCallback statusReceivedCallback, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            this(payStationClosedCallback, statusReceivedCallback, bl, bl2);
        }

        @Nullable
        public final PayStationClosedCallback getPayStationClosedCallback() {
            return this.payStationClosedCallback;
        }

        @Nullable
        public final StatusReceivedCallback getStatusReceivedCallback() {
            return this.statusReceivedCallback;
        }

        public final boolean isSandbox() {
            return this.isSandbox;
        }

        public final boolean isFinishedStatusReceived() {
            return this.isFinishedStatusReceived;
        }

        public final void setFinishedStatusReceived(boolean bl) {
            this.isFinishedStatusReceived = bl;
        }

        @Nullable
        public final PayStationClosedCallback component1() {
            return this.payStationClosedCallback;
        }

        @Nullable
        public final StatusReceivedCallback component2() {
            return this.statusReceivedCallback;
        }

        public final boolean component3() {
            return this.isSandbox;
        }

        public final boolean component4() {
            return this.isFinishedStatusReceived;
        }

        @NotNull
        public final PaymentInfo copy(@Nullable PayStationClosedCallback payStationClosedCallback, @Nullable StatusReceivedCallback statusReceivedCallback, boolean isSandbox, boolean isFinishedStatusReceived) {
            return new PaymentInfo(payStationClosedCallback, statusReceivedCallback, isSandbox, isFinishedStatusReceived);
        }

        public static /* synthetic */ PaymentInfo copy$default(PaymentInfo paymentInfo, PayStationClosedCallback payStationClosedCallback, StatusReceivedCallback statusReceivedCallback, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                payStationClosedCallback = paymentInfo.payStationClosedCallback;
            }
            if ((n & 2) != 0) {
                statusReceivedCallback = paymentInfo.statusReceivedCallback;
            }
            if ((n & 4) != 0) {
                bl = paymentInfo.isSandbox;
            }
            if ((n & 8) != 0) {
                bl2 = paymentInfo.isFinishedStatusReceived;
            }
            return paymentInfo.copy(payStationClosedCallback, statusReceivedCallback, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "PaymentInfo(payStationClosedCallback=" + this.payStationClosedCallback + ", statusReceivedCallback=" + this.statusReceivedCallback + ", isSandbox=" + this.isSandbox + ", isFinishedStatusReceived=" + this.isFinishedStatusReceived + ')';
        }

        public int hashCode() {
            int result = this.payStationClosedCallback == null ? 0 : this.payStationClosedCallback.hashCode();
            result = result * 31 + (this.statusReceivedCallback == null ? 0 : this.statusReceivedCallback.hashCode());
            int n = this.isSandbox ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.isFinishedStatusReceived ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PaymentInfo)) {
                return false;
            }
            PaymentInfo paymentInfo = (PaymentInfo)other;
            if (!Intrinsics.areEqual((Object)this.payStationClosedCallback, (Object)paymentInfo.payStationClosedCallback)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.statusReceivedCallback, (Object)paymentInfo.statusReceivedCallback)) {
                return false;
            }
            if (this.isSandbox != paymentInfo.isSandbox) {
                return false;
            }
            return this.isFinishedStatusReceived == paymentInfo.isFinishedStatusReceived;
        }
    }
}

