/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.caching;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import androidx.annotation.MainThread;
import androidx.annotation.RequiresApi;
import androidx.browser.customtabs.CustomTabsSession;
import com.xsolla.android.payments.XPayments;
import com.xsolla.android.payments.ui.ActivityPayStation;
import com.xsolla.android.payments.ui.utils.BrowserUtils;
import com.xsolla.android.payments.ui.utils.CustomTabsHelper;
import com.xsolla.android.payments.ui.utils.TrustedWebActivity;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0006J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u001b\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/xsolla/android/payments/caching/PayStationCache;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "cachedIntent", "Landroid/content/Intent;", "getContext", "()Landroid/content/Context;", "customTabHelperHolder", "Lcom/xsolla/android/payments/caching/PayStationCache$CustomTabsHelperHolder;", "preloadingWebView", "Landroid/webkit/WebView;", "ensureHelper", "Lcom/xsolla/android/payments/ui/utils/CustomTabsHelper;", "getCachedIntent", "getCachedSession", "Landroidx/browser/customtabs/CustomTabsSession;", "init", "", "loadUrl", "url", "", "webView", "preloadUrl", "prepareWebView", "setBrowserClients", "setWebViewSettings", "setupWebViewWithDefaults", "Companion", "CustomTabsHelperHolder", "xsolla-payments-sdk_release"})
public final class PayStationCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private WebView preloadingWebView;
    @Nullable
    private Intent cachedIntent;
    private CustomTabsHelperHolder customTabHelperHolder;
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static PayStationCache instance;
    @NotNull
    private static final String TAG = "PayStationCache";

    public PayStationCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void init() {
        this.ensureHelper();
    }

    @NotNull
    public final Intent getCachedIntent() {
        if (this.cachedIntent == null) {
            Intent newIntent = new Intent();
            newIntent.setClass(this.context, ActivityPayStation.class);
            this.cachedIntent = newIntent;
        }
        Intent intent = this.cachedIntent;
        Intrinsics.checkNotNull((Object)intent);
        return intent;
    }

    @Nullable
    public final CustomTabsSession getCachedSession() {
        CustomTabsHelper customTabsHelper = this.ensureHelper();
        return customTabsHelper != null ? customTabsHelper.getSession() : null;
    }

    private final void preloadUrl(String url) {
        this.preloadingWebView = this.prepareWebView(this.context);
        WebView webView = this.preloadingWebView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"preloadingWebView");
            webView = null;
        }
        this.loadUrl(url, webView);
    }

    private final WebView prepareWebView(Context context) {
        WebView webView = new WebView(context);
        this.setupWebViewWithDefaults(webView);
        return webView;
    }

    private final void setupWebViewWithDefaults(WebView webView) {
        this.setWebViewSettings(webView);
        this.setBrowserClients(webView);
    }

    private final void setWebViewSettings(WebView webView) {
        if (webView == null) {
            boolean bl = false;
            String string = "WebView should not be null!";
            throw new IllegalArgumentException(string.toString());
        }
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setLoadsImagesAutomatically(true);
    }

    private final void setBrowserClients(WebView webView) {
        if (webView == null) {
            boolean $i$a$-requireNotNull-PayStationCache$setBrowserClients$22 = false;
            String $i$a$-requireNotNull-PayStationCache$setBrowserClients$22 = "WebView should not be null!";
            throw new IllegalArgumentException($i$a$-requireNotNull-PayStationCache$setBrowserClients$22.toString());
        }
        try {
            webView.setWebViewClient(new WebViewClient(webView){
                final /* synthetic */ WebView $webView;
                {
                    this.$webView = $webView;
                }

                public boolean shouldOverrideUrlLoading(@NotNull WebView webview, @NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)webview, (String)"webview");
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Log.d((String)"PayStationCache", (String)("shouldOverrideUrlLoading intercept url: " + url));
                    this.$webView.loadUrl(url);
                    return true;
                }

                public void onReceivedError(@NotNull WebView view, int errorCode, @NotNull String description, @NotNull String failingUrl) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                    Intrinsics.checkNotNullParameter((Object)failingUrl, (String)"failingUrl");
                    String url = view.getOriginalUrl();
                    Toast.makeText((Context)view.getContext(), (CharSequence)("Load failed with error: " + description), (int)1).show();
                }

                @RequiresApi(value=26)
                public boolean onRenderProcessGone(@NotNull WebView view, @NotNull RenderProcessGoneDetail detail) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)detail, (String)"detail");
                    if (!detail.didCrash()) {
                        Log.d((String)"PayStationCache", (String)"System killed the WebView rendering process to reclaim memory. Recreating...");
                        if (view.getParent() != null) {
                            ViewGroup webViewContainer;
                            ViewParent viewParent = view.getParent();
                            ViewGroup viewGroup = webViewContainer = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
                            if (webViewContainer != null && webViewContainer.getChildCount() > 0) {
                                webViewContainer.removeView((View)view);
                            }
                            view.destroy();
                        }
                        return true;
                    }
                    return false;
                }
            });
            webView.setWebChromeClient(new WebChromeClient(){

                public void onProgressChanged(@NotNull WebView view, int newProgress) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    super.onProgressChanged(view, newProgress);
                    Log.d((String)"PayStationCache", (String)("onProgressChanged: " + newProgress));
                    if (newProgress == 100) {
                        String url = view.getOriginalUrl();
                        Log.d((String)"PayStationCache", (String)"Preloading is done!");
                    }
                }
            });
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    private final void loadUrl(String url, WebView webView) {
        webView.loadUrl(url);
    }

    private final CustomTabsHelper ensureHelper() {
        CustomTabsHelperHolder customTabsHelperHolder;
        if (this.customTabHelperHolder == null) {
            String locale;
            XPayments.Companion.createIntentBuilder(this.context);
            String string = locale = Locale.getDefault().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locale");
            if (((CharSequence)string).length() == 0) {
                locale = "en";
            }
            if (BrowserUtils.INSTANCE.getCustomTabsBrowserPackageName(this.context) != null) {
                String payStation3WarmUpUrl = "https://secure.xsolla.com/paystation3/" + locale + "/cache-warmup";
                String payStation4WarmUpUrl = "https://secure.xsolla.com/paystation4/" + locale + "/cache-warmup";
                CustomTabsHelper customTabHelper2 = new CustomTabsHelper(this.context, payStation3WarmUpUrl, payStation4WarmUpUrl, (Function1<? super CustomTabsSession, Unit>)((Function1)new Function1<CustomTabsSession, Unit>((Object)TrustedWebActivity.INSTANCE){

                    public final void invoke(@NotNull CustomTabsSession p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((TrustedWebActivity)this.receiver).notifyOnCustomTabsSessionCreated(p0);
                    }
                }));
                this.customTabHelperHolder = new CustomTabsHelperHolder(customTabHelper2);
                customTabHelper2.bindCustomTabsService();
            } else {
                this.customTabHelperHolder = new CustomTabsHelperHolder(null);
                this.preloadUrl("https://secure.xsolla.com/paystation4/" + locale + "/cache-warmup");
            }
        }
        if ((customTabsHelperHolder = this.customTabHelperHolder) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customTabHelperHolder");
            customTabsHelperHolder = null;
        }
        return customTabsHelperHolder.getCustomTabsHelper();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/xsolla/android/payments/caching/PayStationCache$CustomTabsHelperHolder;", "", "customTabsHelper", "Lcom/xsolla/android/payments/ui/utils/CustomTabsHelper;", "(Lcom/xsolla/android/payments/ui/utils/CustomTabsHelper;)V", "getCustomTabsHelper", "()Lcom/xsolla/android/payments/ui/utils/CustomTabsHelper;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "xsolla-payments-sdk_release"})
    public static final class CustomTabsHelperHolder {
        @Nullable
        private final CustomTabsHelper customTabsHelper;

        public CustomTabsHelperHolder(@Nullable CustomTabsHelper customTabsHelper) {
            this.customTabsHelper = customTabsHelper;
        }

        @Nullable
        public final CustomTabsHelper getCustomTabsHelper() {
            return this.customTabsHelper;
        }

        @Nullable
        public final CustomTabsHelper component1() {
            return this.customTabsHelper;
        }

        @NotNull
        public final CustomTabsHelperHolder copy(@Nullable CustomTabsHelper customTabsHelper) {
            return new CustomTabsHelperHolder(customTabsHelper);
        }

        public static /* synthetic */ CustomTabsHelperHolder copy$default(CustomTabsHelperHolder customTabsHelperHolder, CustomTabsHelper customTabsHelper, int n, Object object) {
            if ((n & 1) != 0) {
                customTabsHelper = customTabsHelperHolder.customTabsHelper;
            }
            return customTabsHelperHolder.copy(customTabsHelper);
        }

        @NotNull
        public String toString() {
            return "CustomTabsHelperHolder(customTabsHelper=" + this.customTabsHelper + ')';
        }

        public int hashCode() {
            return this.customTabsHelper == null ? 0 : this.customTabsHelper.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomTabsHelperHolder)) {
                return false;
            }
            CustomTabsHelperHolder customTabsHelperHolder = (CustomTabsHelperHolder)other;
            return Intrinsics.areEqual((Object)this.customTabsHelper, (Object)customTabsHelperHolder.customTabsHelper);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/xsolla/android/payments/caching/PayStationCache$Companion;", "", "()V", "TAG", "", "instance", "Lcom/xsolla/android/payments/caching/PayStationCache;", "getInstance", "context", "Landroid/content/Context;", "xsolla-payments-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @MainThread
        @NotNull
        public final PayStationCache getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (instance == null) {
                PayStationCache payStationCache;
                Context context2 = context.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
                PayStationCache $this$getInstance_u24lambda_u2d0 = payStationCache = new PayStationCache(context2);
                boolean bl = false;
                $this$getInstance_u24lambda_u2d0.init();
                instance = payStationCache;
            }
            PayStationCache payStationCache = instance;
            Intrinsics.checkNotNull((Object)payStationCache);
            return payStationCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

