/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.data;

import android.graphics.Color;
import android.util.Log;
import androidx.annotation.ColorInt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0012\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/xsolla/android/payments/data/AccessToken;", "", "token", "", "(Ljava/lang/String;)V", "getToken", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "extractColor", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getBackgroundColor", "()Ljava/lang/Integer;", "getButtonColor", "hashCode", "toString", "Companion", "xsolla-payments-sdk_release"})
public final class AccessToken {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String token;
    @Deprecated
    @NotNull
    public static final String LOG_TAG = "AccessToken";
    @Deprecated
    @NotNull
    public static final String BACKGROUND_COLOR_TOKEN = "bg";
    @Deprecated
    @NotNull
    public static final String BUTTON_COLOR_TOKEN = "tb";
    @Deprecated
    public static final char TOKEN_VALUE_DELIMITER = '_';

    public AccessToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.token = token;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @ColorInt
    @Nullable
    public final Integer getBackgroundColor() {
        return this.extractColor(BACKGROUND_COLOR_TOKEN);
    }

    @ColorInt
    @Nullable
    public final Integer getButtonColor() {
        return this.extractColor(BUTTON_COLOR_TOKEN);
    }

    @ColorInt
    private final Integer extractColor(String token) {
        String colorStr = StringsKt.substringBefore((String)StringsKt.substringAfter((String)this.token, (String)(token + '_'), (String)""), (char)'_', (String)"");
        try {
            return Color.parseColor((String)('#' + colorStr));
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"[AccessToken] Failed to parse color", (Throwable)e);
            return null;
        }
    }

    @NotNull
    public final String component1() {
        return this.token;
    }

    @NotNull
    public final AccessToken copy(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return new AccessToken(token);
    }

    public static /* synthetic */ AccessToken copy$default(AccessToken accessToken, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = accessToken.token;
        }
        return accessToken.copy(string);
    }

    @NotNull
    public String toString() {
        return "AccessToken(token=" + this.token + ')';
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AccessToken)) {
            return false;
        }
        AccessToken accessToken = (AccessToken)other;
        return Intrinsics.areEqual((Object)this.token, (Object)accessToken.token);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/xsolla/android/payments/data/AccessToken$Companion;", "", "()V", "BACKGROUND_COLOR_TOKEN", "", "BUTTON_COLOR_TOKEN", "LOG_TAG", "TOKEN_VALUE_DELIMITER", "", "xsolla-payments-sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

