/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.tracker;

import android.util.Log;
import com.xsolla.android.payments.callbacks.StatusReceivedCallback;
import com.xsolla.android.payments.entity.response.InvoicesDataResponse;
import com.xsolla.android.payments.tracker.InvoiceStatusListener;
import com.xsolla.android.payments.tracker.TrackingCallback;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/xsolla/android/payments/tracker/StatusTracker;", "", "isSandbox", "", "(Z)V", "listeners", "", "", "Lcom/xsolla/android/payments/tracker/InvoiceStatusListener;", "addToTracking", "", "callback", "Lcom/xsolla/android/payments/callbacks/StatusReceivedCallback;", "token", "requestsCount", "", "restartTracking", "Companion", "xsolla-payments-sdk_release"})
public final class StatusTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isSandbox;
    @NotNull
    private Map<String, InvoiceStatusListener> listeners;
    @NotNull
    private static final String TAG = "StatusTracker";
    private static long SHORT_POLLING_TIMEOUT = 3000L;
    public static final int MAX_REQUESTS_COUNT = 9999;

    public StatusTracker(boolean isSandbox) {
        this.isSandbox = isSandbox;
        this.listeners = new LinkedHashMap();
    }

    public final void addToTracking(@NotNull StatusReceivedCallback callback, @NotNull String token, int requestsCount) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Log.d((String)TAG, (String)("addToTracking. initial listeners count = " + this.listeners.size() + ". token = " + token));
        if (this.listeners.containsKey(token)) {
            Log.d((String)TAG, (String)"This payment token has already added to the tracker");
            return;
        }
        Map<String, InvoiceStatusListener> $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, InvoiceStatusListener>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, InvoiceStatusListener> element$iv;
            Map.Entry<String, InvoiceStatusListener> entry = element$iv = iterator.next();
            boolean bl = false;
            String token2 = entry.getKey();
            InvoiceStatusListener listener = entry.getValue();
            Timer it = listener.getDelayTimer();
            boolean bl2 = false;
            listener.setRemainRequestsCount(0);
            Timer timer = listener.getDelayTimer();
            if (timer != null) {
                timer.cancel();
            }
            listener.setDelayTimer(null);
            Log.d((String)TAG, (String)("Listener with token " + token2 + "  was removed from tracking listeners"));
        }
        this.listeners.clear();
        this.listeners.put(token, new InvoiceStatusListener(token, this.isSandbox, new TrackingCallback(callback, this, token){
            final /* synthetic */ StatusReceivedCallback $callback;
            final /* synthetic */ StatusTracker this$0;
            final /* synthetic */ String $token;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
                this.$token = $token;
            }

            public void onUniqueStatusReceived(@NotNull InvoicesDataResponse data, boolean isFinishedStatus) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$callback.onSuccess(data);
                if (isFinishedStatus && StatusTracker.access$getListeners$p(this.this$0).containsKey(this.$token)) {
                    StatusTracker.access$getListeners$p(this.this$0).remove(this.$token);
                }
            }

            public void onRunOutOfRequests() {
                Log.d((String)"StatusTracker", (String)"TrackingCallback. onRunOutOfRequests");
                StatusTracker.access$getListeners$p(this.this$0).remove(this.$token);
            }
        }));
        this.restartTracking(token, requestsCount);
    }

    public final void restartTracking(@NotNull String token, int requestsCount) {
        block4: {
            InvoiceStatusListener listener;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            if (!this.listeners.containsKey(token)) {
                Log.d((String)TAG, (String)("Can't restart tracking with token = " + token + " Probably finished status has already received and StatusReceivedCallback is fired."));
                return;
            }
            InvoiceStatusListener invoiceStatusListener = listener = this.listeners.get(token);
            if (invoiceStatusListener == null) break block4;
            InvoiceStatusListener lst = invoiceStatusListener;
            boolean bl = false;
            lst.setRemainRequestsCount(requestsCount);
            if (lst.isRequestInProgress()) {
                return;
            }
            Timer it = lst.getDelayTimer();
            boolean bl2 = false;
            Timer timer = lst.getDelayTimer();
            if (timer != null) {
                timer.cancel();
            }
            lst.setDelayTimer(null);
            Runnable runnable = lst.getSingleRunTask();
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public static final /* synthetic */ Map access$getListeners$p(StatusTracker $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/xsolla/android/payments/tracker/StatusTracker$Companion;", "", "()V", "MAX_REQUESTS_COUNT", "", "SHORT_POLLING_TIMEOUT", "", "getSHORT_POLLING_TIMEOUT$xsolla_payments_sdk_release", "()J", "setSHORT_POLLING_TIMEOUT$xsolla_payments_sdk_release", "(J)V", "TAG", "", "xsolla-payments-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getSHORT_POLLING_TIMEOUT$xsolla_payments_sdk_release() {
            return SHORT_POLLING_TIMEOUT;
        }

        public final void setSHORT_POLLING_TIMEOUT$xsolla_payments_sdk_release(long l) {
            SHORT_POLLING_TIMEOUT = l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

