/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.xsolla.android.payments.ui.utils.AsyncUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/xsolla/android/payments/ui/utils/AsyncUtils;", "", "()V", "LOG_TAG", "", "kotlin.jvm.PlatformType", "sMainThreadExecutor", "com/xsolla/android/payments/ui/utils/AsyncUtils$sMainThreadExecutor$1", "Lcom/xsolla/android/payments/ui/utils/AsyncUtils$sMainThreadExecutor$1;", "sThreadFactory", "Lcom/xsolla/android/payments/ui/utils/AsyncUtils$InternalThreadFactory;", "sThreadPool", "Ljava/util/concurrent/ExecutorService;", "run", "Ljava/util/concurrent/Future;", "runnable", "Ljava/lang/Runnable;", "runOnMainThread", "", "InternalThreadFactory", "xsolla-payments-sdk_release"})
public final class AsyncUtils {
    @NotNull
    public static final AsyncUtils INSTANCE = new AsyncUtils();
    private static final String LOG_TAG = INSTANCE.getClass().getSimpleName();
    @NotNull
    private static final InternalThreadFactory sThreadFactory = new InternalThreadFactory();
    private static final ExecutorService sThreadPool = Executors.newCachedThreadPool(sThreadFactory);
    @NotNull
    private static final sMainThreadExecutor.1 sMainThreadExecutor = new Executor(){
        @NotNull
        private final Handler mainHandler;
        {
            this.mainHandler = new Handler(Looper.getMainLooper());
        }

        public void execute(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            this.mainHandler.post(r);
        }
    };

    private AsyncUtils() {
    }

    @Nullable
    public final Future<?> run(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            return sThreadPool.submit(runnable);
        }
        catch (Exception e) {
            Log.d((String)LOG_TAG, (String)"Failed to execute a task asynchronously.", (Throwable)e);
            return null;
        }
    }

    public final void runOnMainThread(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        sMainThreadExecutor.execute(runnable);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/xsolla/android/payments/ui/utils/AsyncUtils$InternalThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "nextThreadId", "Ljava/util/concurrent/atomic/AtomicInteger;", "threadFactory", "kotlin.jvm.PlatformType", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "Companion", "xsolla-payments-sdk_release"})
    public static final class InternalThreadFactory
    implements ThreadFactory {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final ThreadFactory threadFactory = Executors.defaultThreadFactory();
        @NotNull
        private final AtomicInteger nextThreadId = new AtomicInteger(1);
        @NotNull
        private static final String THREAD_PREFIX = "XsollaPayments";

        @Override
        @NotNull
        public Thread newThread(@Nullable Runnable r) {
            Thread thread = this.threadFactory.newThread(r);
            int threadId = this.nextThreadId.getAndIncrement();
            thread.setName("XsollaPayments-" + threadId);
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
            return thread;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/xsolla/android/payments/ui/utils/AsyncUtils$InternalThreadFactory$Companion;", "", "()V", "THREAD_PREFIX", "", "xsolla-payments-sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

