/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;
import com.google.androidbrowserhelper.trusted.ChromeLegacyUtils;
import com.xsolla.android.payments.R;
import com.xsolla.android.payments.caching.PayStationCache;
import com.xsolla.android.payments.ui.ActivityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/xsolla/android/payments/ui/utils/BrowserUtils;", "", "()V", "BLACKLISTED_CUSTOM_TABS_BROWSER_PACKAGE_NAMES", "", "", "cachedBrowserPackagesByCustomTabsSupportLevel", "", "Lcom/xsolla/android/payments/ui/utils/BrowserUtils$BrowserProvider$CustomTabsSupportLevel;", "cachedBrowserProviders", "Lcom/xsolla/android/payments/ui/utils/BrowserUtils$BrowserProvider;", "browserProviders", "context", "Landroid/content/Context;", "browserProvidersByCustomTabsSupportLevel", "level", "deduceActivityType", "Lcom/xsolla/android/payments/ui/ActivityType;", "preferredType", "getAvailableCustomTabsBrowsers", "getAvailablePlainBrowsers", "getAvailableTWABrowsers", "getCustomTabsBrowserPackageName", "isCustomTabsBrowserAvailable", "", "isTWABrowserAvailable", "launchCustomTabsBrowser", "", "url", "launchPlainBrowser", "activity", "Landroid/app/Activity;", "BrowserProvider", "xsolla-payments-sdk_release"})
public final class BrowserUtils {
    @NotNull
    public static final BrowserUtils INSTANCE = new BrowserUtils();
    @NotNull
    private static final List<String> BLACKLISTED_CUSTOM_TABS_BROWSER_PACKAGE_NAMES;
    @Nullable
    private static List<BrowserProvider> cachedBrowserProviders;
    @NotNull
    private static Map<BrowserProvider.CustomTabsSupportLevel, List<String>> cachedBrowserPackagesByCustomTabsSupportLevel;

    private BrowserUtils() {
    }

    public final boolean isCustomTabsBrowserAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.getCustomTabsBrowserPackageName(context) != null && PayStationCache.Companion.getInstance(context).getCachedSession() != null;
    }

    @Nullable
    public final String getCustomTabsBrowserPackageName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (String)CollectionsKt.firstOrNull(this.getAvailableCustomTabsBrowsers(context));
    }

    public final void launchCustomTabsBrowser(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CustomTabColorSchemeParams customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setNavigationBarColor(ContextCompat.getColor((Context)context, (int)R.color.xsolla_payments_tab)).setToolbarColor(ContextCompat.getColor((Context)context, (int)R.color.xsolla_payments_tab)).setSecondaryToolbarColor(ContextCompat.getColor((Context)context, (int)R.color.xsolla_payments_tab)).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"Builder()\n            .s\u2026   )\n            .build()");
        CustomTabColorSchemeParams colorSchemeParams = customTabColorSchemeParams;
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(PayStationCache.Companion.getInstance(context).getCachedSession()).setDefaultColorSchemeParams(colorSchemeParams).setShowTitle(true).setUrlBarHidingEnabled(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"Builder(PayStationCache.\u2026rue)\n            .build()");
        CustomTabsIntent customTabsIntent2 = customTabsIntent;
        customTabsIntent2.intent.setPackage(this.getCustomTabsBrowserPackageName(context));
        customTabsIntent2.launchUrl(context, Uri.parse((String)url));
    }

    public final void launchPlainBrowser(@NotNull Activity activity, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intent intent = new Intent().setAction("android.intent.action.VIEW").setData(Uri.parse((String)url)).setPackage((String)CollectionsKt.firstOrNull(this.getAvailablePlainBrowsers((Context)activity)));
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent()\n            .se\u2026(activity).firstOrNull())");
        Intent intent2 = intent;
        activity.startActivity(intent2);
    }

    @NotNull
    public final ActivityType deduceActivityType(@NotNull Context context, @Nullable ActivityType preferredType) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return preferredType != null ? (preferredType == ActivityType.TRUSTED_WEB_ACTIVITY && this.isTWABrowserAvailable(context) ? ActivityType.TRUSTED_WEB_ACTIVITY : (preferredType == ActivityType.CUSTOM_TABS && this.isCustomTabsBrowserAvailable(context) ? ActivityType.CUSTOM_TABS : ActivityType.WEB_VIEW)) : (this.isTWABrowserAvailable(context) ? ActivityType.TRUSTED_WEB_ACTIVITY : (this.isCustomTabsBrowserAvailable(context) ? ActivityType.CUSTOM_TABS : ActivityType.WEB_VIEW));
    }

    private final boolean isTWABrowserAvailable(Context context) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getAvailableTWABrowsers(context);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!TextUtils.isEmpty((CharSequence)it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null && PayStationCache.Companion.getInstance(context).getCachedSession() != null;
    }

    private final List<String> getAvailableCustomTabsBrowsers(Context context) {
        return this.browserProvidersByCustomTabsSupportLevel(context, BrowserProvider.CustomTabsSupportLevel.SUPPORTED);
    }

    private final List<String> getAvailableTWABrowsers(Context context) {
        return this.browserProvidersByCustomTabsSupportLevel(context, BrowserProvider.CustomTabsSupportLevel.SUPPORTED_WITH_TWA);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAvailablePlainBrowsers(Context context) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.browserProviders(context);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BrowserProvider browserProvider = (BrowserProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPackageName());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> browserProvidersByCustomTabsSupportLevel(Context context, BrowserProvider.CustomTabsSupportLevel level) {
        List packageNames = cachedBrowserPackagesByCustomTabsSupportLevel.get((Object)level);
        if (packageNames == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BrowserProvider it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = this.browserProviders(context);
            boolean $i$f$filter = false;
            void var6_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BrowserProvider)element$iv$iv;
                boolean bl = false;
                if (!(it.getCustomTabsSupportLevel().compareTo((Enum)level) >= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BrowserProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPackageName());
            }
            packageNames = (List)destination$iv$iv;
            cachedBrowserPackagesByCustomTabsSupportLevel.put(level, packageNames);
        }
        return packageNames;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<BrowserProvider> browserProviders(Context context) {
        block12: {
            if (BrowserUtils.cachedBrowserProviders != null) break block12;
            packageManager = context.getPackageManager();
            v0 = packageManager.queryIntentServices(new Intent("android.support.customtabs.action.CustomTabsService"), 64);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"packageManager\n         \u2026_FILTER\n                )");
            var4_3 = v0;
            $i$f$mapNotNull = false;
            var6_6 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var11_15 = $this$forEach$iv$iv$iv.iterator();
            while (var11_15.hasNext()) {
                block14: {
                    block13: {
                        element$iv$iv = element$iv$iv$iv = var11_15.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        resolveInfo = (ResolveInfo)element$iv$iv;
                        $i$a$-mapNotNull-BrowserUtils$browserProviders$customTabsBrowserProviders$1 = false;
                        it = var17_25 = resolveInfo;
                        $i$a$-takeIf-BrowserUtils$browserProviders$customTabsBrowserProviders$1$1 = false;
                        v1 = it.serviceInfo;
                        v2 = packageName = v1 != null ? v1.packageName : null;
                        v3 /* !! */  = var21_34 = (!TextUtils.isEmpty((CharSequence)packageName) && !CollectionsKt.contains((Iterable)BrowserUtils.BLACKLISTED_CUSTOM_TABS_BROWSER_PACKAGE_NAMES, (Object)packageName)) != false ? var17_25 : null;
                        if (var21_34 == null) break block13;
                        it = var21_34;
                        $i$a$-let-BrowserUtils$browserProviders$customTabsBrowserProviders$1$2 = false;
                        if (ChromeLegacyUtils.supportsTrustedWebActivities((PackageManager)packageManager, (String)it.serviceInfo.packageName)) ** GOTO lbl-1000
                        v4 = it.filter;
                        if (v4 != null ? v4.hasCategory("androidx.browser.trusted.category.TrustedWebActivities") : false) lbl-1000:
                        // 2 sources

                        {
                            v5 = true;
                        } else {
                            v5 = false;
                        }
                        isTWASupported = v5;
                        v6 = it.serviceInfo.packageName;
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it.serviceInfo.packageName");
                        v7 = new BrowserProvider(v6, isTWASupported != false ? BrowserProvider.CustomTabsSupportLevel.SUPPORTED_WITH_TWA : BrowserProvider.CustomTabsSupportLevel.SUPPORTED);
                        break block14;
                    }
                    v7 = null;
                }
                if (v7 == null) continue;
                it$iv$iv = v7;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            customTabsBrowserProviders = (List)destination$iv$iv;
            $this$mapNotNullTo$iv$iv = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://"));
            destination$iv$iv = $this$mapNotNullTo$iv$iv;
            var31_39 = context.getPackageManager();
            $i$a$-apply-BrowserUtils$browserProviders$otherBrowserProviders$1 = false;
            $this$browserProviders_u24lambda_u2d7.addCategory("android.intent.category.BROWSABLE");
            v8 = var31_39.queryIntentActivities($this$mapNotNullTo$iv$iv, 0);
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"context.packageManager\n \u2026   }, 0\n                )");
            $i$f$mapNotNull = v8;
            $i$f$mapNotNull = false;
            $this$browserProviders_u24lambda_u2d7 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var12_17 = $this$forEach$iv$iv$iv.iterator();
            while (var12_17.hasNext()) {
                block11: {
                    element$iv$iv = element$iv$iv$iv = var12_17.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    resolveInfo = (ResolveInfo)element$iv$iv;
                    $i$a$-mapNotNull-BrowserUtils$browserProviders$otherBrowserProviders$2 = false;
                    var18_27 = resolveInfo.activityInfo;
                    if (var18_27 == null) ** GOTO lbl-1000
                    activityInfo = var19_30 = var18_27;
                    $i$a$-takeIf-BrowserUtils$browserProviders$otherBrowserProviders$2$1 = false;
                    if (TextUtils.isEmpty((CharSequence)activityInfo.packageName)) ** GOTO lbl-1000
                    $this$none$iv = customTabsBrowserProviders;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v9 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            provider = (BrowserProvider)element$iv;
                            $i$a$-none-BrowserUtils$browserProviders$otherBrowserProviders$2$1$1 = false;
                            if (!(Intrinsics.areEqual((Object)provider.getPackageName(), (Object)activityInfo.packageName) == false)) continue;
                            v9 = false;
                            break block11;
                        }
                        v9 = true;
                    }
                }
                if (v9) {
                    v10 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v10 = false;
                }
                v11 /* !! */  = var28_44 = v10 != false ? var19_30 : null;
                if (var28_44 != null) {
                    it = var28_44;
                    $i$a$-let-BrowserUtils$browserProviders$otherBrowserProviders$2$2 = false;
                    v12 = it.packageName;
                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"it.packageName");
                    v13 = new BrowserProvider(v12, BrowserProvider.CustomTabsSupportLevel.UNSUPPORTED);
                } else lbl-1000:
                // 2 sources

                {
                    v13 = null;
                }
                if (v13 == null) continue;
                it$iv$iv = v13;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            otherBrowserProviders = (List)destination$iv$iv;
            BrowserUtils.cachedBrowserProviders = CollectionsKt.plus((Collection)customTabsBrowserProviders, (Iterable)otherBrowserProviders);
        }
        v14 = BrowserUtils.cachedBrowserProviders;
        Intrinsics.checkNotNull(v14);
        return v14;
    }

    static {
        Object[] objectArray = new String[]{"org.mozilla.firefox", "org.mozilla.klar", "org.mozilla.firefox_beta", "org.mozilla.fenix", "com.yandex.browser"};
        BLACKLISTED_CUSTOM_TABS_BROWSER_PACKAGE_NAMES = CollectionsKt.listOf((Object[])objectArray);
        cachedBrowserPackagesByCustomTabsSupportLevel = new LinkedHashMap();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/xsolla/android/payments/ui/utils/BrowserUtils$BrowserProvider;", "", "packageName", "", "customTabsSupportLevel", "Lcom/xsolla/android/payments/ui/utils/BrowserUtils$BrowserProvider$CustomTabsSupportLevel;", "(Ljava/lang/String;Lcom/xsolla/android/payments/ui/utils/BrowserUtils$BrowserProvider$CustomTabsSupportLevel;)V", "getCustomTabsSupportLevel", "()Lcom/xsolla/android/payments/ui/utils/BrowserUtils$BrowserProvider$CustomTabsSupportLevel;", "getPackageName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "CustomTabsSupportLevel", "xsolla-payments-sdk_release"})
    private static final class BrowserProvider {
        @NotNull
        private final String packageName;
        @NotNull
        private final CustomTabsSupportLevel customTabsSupportLevel;

        public BrowserProvider(@NotNull String packageName, @NotNull CustomTabsSupportLevel customTabsSupportLevel) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)((Object)customTabsSupportLevel), (String)"customTabsSupportLevel");
            this.packageName = packageName;
            this.customTabsSupportLevel = customTabsSupportLevel;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        @NotNull
        public final CustomTabsSupportLevel getCustomTabsSupportLevel() {
            return this.customTabsSupportLevel;
        }

        @NotNull
        public final String component1() {
            return this.packageName;
        }

        @NotNull
        public final CustomTabsSupportLevel component2() {
            return this.customTabsSupportLevel;
        }

        @NotNull
        public final BrowserProvider copy(@NotNull String packageName, @NotNull CustomTabsSupportLevel customTabsSupportLevel) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)((Object)customTabsSupportLevel), (String)"customTabsSupportLevel");
            return new BrowserProvider(packageName, customTabsSupportLevel);
        }

        public static /* synthetic */ BrowserProvider copy$default(BrowserProvider browserProvider, String string, CustomTabsSupportLevel customTabsSupportLevel, int n, Object object) {
            if ((n & 1) != 0) {
                string = browserProvider.packageName;
            }
            if ((n & 2) != 0) {
                customTabsSupportLevel = browserProvider.customTabsSupportLevel;
            }
            return browserProvider.copy(string, customTabsSupportLevel);
        }

        @NotNull
        public String toString() {
            return "BrowserProvider(packageName=" + this.packageName + ", customTabsSupportLevel=" + (Object)((Object)this.customTabsSupportLevel) + ')';
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = result * 31 + this.customTabsSupportLevel.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BrowserProvider)) {
                return false;
            }
            BrowserProvider browserProvider = (BrowserProvider)other;
            if (!Intrinsics.areEqual((Object)this.packageName, (Object)browserProvider.packageName)) {
                return false;
            }
            return this.customTabsSupportLevel == browserProvider.customTabsSupportLevel;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/xsolla/android/payments/ui/utils/BrowserUtils$BrowserProvider$CustomTabsSupportLevel;", "", "(Ljava/lang/String;I)V", "UNSUPPORTED", "SUPPORTED", "SUPPORTED_WITH_TWA", "xsolla-payments-sdk_release"})
        public static final class CustomTabsSupportLevel
        extends Enum<CustomTabsSupportLevel> {
            public static final /* enum */ CustomTabsSupportLevel UNSUPPORTED = new CustomTabsSupportLevel();
            public static final /* enum */ CustomTabsSupportLevel SUPPORTED = new CustomTabsSupportLevel();
            public static final /* enum */ CustomTabsSupportLevel SUPPORTED_WITH_TWA = new CustomTabsSupportLevel();
            private static final /* synthetic */ CustomTabsSupportLevel[] $VALUES;

            public static CustomTabsSupportLevel[] values() {
                return (CustomTabsSupportLevel[])$VALUES.clone();
            }

            public static CustomTabsSupportLevel valueOf(String value) {
                return Enum.valueOf(CustomTabsSupportLevel.class, value);
            }

            static {
                $VALUES = customTabsSupportLevelArray = new CustomTabsSupportLevel[]{CustomTabsSupportLevel.UNSUPPORTED, CustomTabsSupportLevel.SUPPORTED, CustomTabsSupportLevel.SUPPORTED_WITH_TWA};
            }
        }
    }
}

