/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.xsolla.android.payments.ui.utils.AsyncUtils;
import com.xsolla.android.payments.ui.utils.BrowserUtils;
import com.xsolla.android.payments.ui.utils.CustomTabsHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB@\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\rH\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0003J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0007J\b\u0010\u0019\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/xsolla/android/payments/ui/utils/CustomTabsHelper;", "", "context", "Landroid/content/Context;", "payStation3WarmUpUrl", "", "payStation4WarmUpUrl", "onCustomTabsSessionCreated", "Lkotlin/Function1;", "Landroidx/browser/customtabs/CustomTabsSession;", "Lkotlin/ParameterName;", "name", "customTabsSession", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "mBindingInProgress", "", "mClient", "Landroidx/browser/customtabs/CustomTabsClient;", "mConnection", "Landroidx/browser/customtabs/CustomTabsServiceConnection;", "mCustomTabsSession", "bindCustomTabsService", "ensureCustomTabsSession", "getSession", "unbindCustomTabsService", "Companion", "xsolla-payments-sdk_release"})
public final class CustomTabsHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String payStation3WarmUpUrl;
    @NotNull
    private final String payStation4WarmUpUrl;
    @NotNull
    private final Function1<CustomTabsSession, Unit> onCustomTabsSessionCreated;
    @Nullable
    private CustomTabsClient mClient;
    @Nullable
    private CustomTabsSession mCustomTabsSession;
    private boolean mBindingInProgress;
    @NotNull
    private CustomTabsServiceConnection mConnection;
    @NotNull
    private static final String LOG_TAG;

    public CustomTabsHelper(@NotNull Context context, @NotNull String payStation3WarmUpUrl, @NotNull String payStation4WarmUpUrl, @NotNull Function1<? super CustomTabsSession, Unit> onCustomTabsSessionCreated) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)payStation3WarmUpUrl, (String)"payStation3WarmUpUrl");
        Intrinsics.checkNotNullParameter((Object)payStation4WarmUpUrl, (String)"payStation4WarmUpUrl");
        Intrinsics.checkNotNullParameter(onCustomTabsSessionCreated, (String)"onCustomTabsSessionCreated");
        this.context = context;
        this.payStation3WarmUpUrl = payStation3WarmUpUrl;
        this.payStation4WarmUpUrl = payStation4WarmUpUrl;
        this.onCustomTabsSessionCreated = onCustomTabsSessionCreated;
        this.mConnection = new CustomTabsServiceConnection(this){
            final /* synthetic */ CustomTabsHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCustomTabsServiceConnected(@NotNull ComponentName name, @NotNull CustomTabsClient client) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                Log.d((String)CustomTabsHelper.access$getLOG_TAG$cp(), (String)("onCustomTabsServiceConnected: '" + name + '\''));
                AsyncUtils.INSTANCE.runOnMainThread(() -> mConnection.1.onCustomTabsServiceConnected$lambda-0(this.this$0, client));
            }

            public void onServiceDisconnected(@NotNull ComponentName name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Log.d((String)CustomTabsHelper.access$getLOG_TAG$cp(), (String)("onServiceDisconnected: '" + name + '\''));
                AsyncUtils.INSTANCE.runOnMainThread(() -> mConnection.1.onServiceDisconnected$lambda-1(this.this$0));
            }

            private static final void onCustomTabsServiceConnected$lambda-0(CustomTabsHelper this$0, CustomTabsClient $client) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
                if (CustomTabsHelper.access$getMBindingInProgress$p(this$0)) {
                    CustomTabsHelper.access$setMBindingInProgress$p(this$0, false);
                    CustomTabsHelper.access$setMClient$p(this$0, $client);
                    CustomTabsClient customTabsClient = CustomTabsHelper.access$getMClient$p(this$0);
                    Intrinsics.checkNotNull((Object)customTabsClient);
                    customTabsClient.warmup(0L);
                    CustomTabsHelper.access$ensureCustomTabsSession(this$0);
                }
            }

            private static final void onServiceDisconnected$lambda-1(CustomTabsHelper this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                CustomTabsHelper.access$setMClient$p(this$0, null);
                CustomTabsHelper.access$setMCustomTabsSession$p(this$0, null);
                CustomTabsHelper.access$setMBindingInProgress$p(this$0, false);
            }
        };
    }

    @MainThread
    public final void bindCustomTabsService() {
        if (!this.mBindingInProgress && this.mClient == null) {
            String browserPackageName = BrowserUtils.INSTANCE.getCustomTabsBrowserPackageName(this.context);
            if (browserPackageName != null) {
                Log.d((String)LOG_TAG, (String)("Attempting to bind to custom tabs service using the '" + browserPackageName + "' browser."));
                this.mCustomTabsSession = null;
                this.mBindingInProgress = true;
                CustomTabsClient.bindCustomTabsService((Context)this.context, (String)browserPackageName, (CustomTabsServiceConnection)this.mConnection);
            } else {
                Log.w((String)LOG_TAG, (String)"No suitable browser could be found to start the custom tabs service binding process.");
            }
        }
    }

    @MainThread
    public final void unbindCustomTabsService() {
        if (this.mBindingInProgress) {
            this.mClient = null;
            this.mCustomTabsSession = null;
            this.mBindingInProgress = false;
        } else if (this.mClient != null) {
            this.context.unbindService((ServiceConnection)this.mConnection);
        }
    }

    @MainThread
    @Nullable
    public final CustomTabsSession getSession() {
        return this.ensureCustomTabsSession();
    }

    @MainThread
    private final CustomTabsSession ensureCustomTabsSession() {
        if (this.mClient != null && this.mCustomTabsSession == null) {
            CustomTabsClient customTabsClient = this.mClient;
            Intrinsics.checkNotNull((Object)customTabsClient);
            this.mCustomTabsSession = customTabsClient.newSession(null);
            if (this.mCustomTabsSession != null) {
                CustomTabsSession customTabsSession = this.mCustomTabsSession;
                Intrinsics.checkNotNull((Object)customTabsSession);
                customTabsSession.mayLaunchUrl(Uri.parse((String)this.payStation3WarmUpUrl), null, null);
                CustomTabsSession customTabsSession2 = this.mCustomTabsSession;
                Intrinsics.checkNotNull((Object)customTabsSession2);
                customTabsSession2.mayLaunchUrl(Uri.parse((String)this.payStation4WarmUpUrl), null, null);
                CustomTabsSession customTabsSession3 = this.mCustomTabsSession;
                Intrinsics.checkNotNull((Object)customTabsSession3);
                this.onCustomTabsSessionCreated.invoke((Object)customTabsSession3);
            }
        }
        return this.mCustomTabsSession;
    }

    public static final /* synthetic */ String access$getLOG_TAG$cp() {
        return LOG_TAG;
    }

    public static final /* synthetic */ boolean access$getMBindingInProgress$p(CustomTabsHelper $this) {
        return $this.mBindingInProgress;
    }

    public static final /* synthetic */ void access$setMBindingInProgress$p(CustomTabsHelper $this, boolean bl) {
        $this.mBindingInProgress = bl;
    }

    public static final /* synthetic */ void access$setMClient$p(CustomTabsHelper $this, CustomTabsClient customTabsClient) {
        $this.mClient = customTabsClient;
    }

    public static final /* synthetic */ CustomTabsClient access$getMClient$p(CustomTabsHelper $this) {
        return $this.mClient;
    }

    public static final /* synthetic */ CustomTabsSession access$ensureCustomTabsSession(CustomTabsHelper $this) {
        return $this.ensureCustomTabsSession();
    }

    public static final /* synthetic */ void access$setMCustomTabsSession$p(CustomTabsHelper $this, CustomTabsSession customTabsSession) {
        $this.mCustomTabsSession = customTabsSession;
    }

    static {
        String string = CustomTabsHelper.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CustomTabsHelper::class.java.simpleName");
        LOG_TAG = string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/xsolla/android/payments/ui/utils/CustomTabsHelper$Companion;", "", "()V", "LOG_TAG", "", "xsolla-payments-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

