/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.net.Uri;
import android.util.Log;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsSession;
import androidx.browser.trusted.TrustedWebActivityIntentBuilder;
import androidx.core.content.ContextCompat;
import com.google.androidbrowserhelper.trusted.QualityEnforcer;
import com.google.androidbrowserhelper.trusted.TwaLauncher;
import com.google.androidbrowserhelper.trusted.splashscreens.SplashScreenStrategy;
import com.xsolla.android.payments.R;
import com.xsolla.android.payments.caching.PayStationCache;
import com.xsolla.android.payments.ui.utils.TrustedWebActivityImageRef;
import com.xsolla.android.payments.ui.utils.TrustedWebActivitySplashScreenStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u001a\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity;", "", "()V", "LOG_TAG", "", "kotlin.jvm.PlatformType", "activeLaunchers", "", "Lcom/google/androidbrowserhelper/trusted/TwaLauncher;", "activeLaunchersLock", "Ljava/lang/Object;", "pendingRequests", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$Request;", "pendingRequestsLock", "pendingSplashScreenStrategies", "Lcom/google/androidbrowserhelper/trusted/splashscreens/SplashScreenStrategy;", "pendingSplashScreenStrategiesLock", "launch", "", "request", "launchImpl", "customTabsSession", "Landroidx/browser/customtabs/CustomTabsSession;", "notifyOnCustomTabsSessionCreated", "notifyOnDestroy", "ignorePending", "", "notifyOnEnterAnimationComplete", "Request", "SplashScreen", "xsolla-payments-sdk_release"})
public final class TrustedWebActivity {
    @NotNull
    public static final TrustedWebActivity INSTANCE = new TrustedWebActivity();
    private static final String LOG_TAG = INSTANCE.getClass().getSimpleName();
    @NotNull
    private static final Object pendingRequestsLock = new Object();
    @NotNull
    private static List<Request> pendingRequests = CollectionsKt.emptyList();
    @NotNull
    private static final Object pendingSplashScreenStrategiesLock = new Object();
    @NotNull
    private static List<? extends SplashScreenStrategy> pendingSplashScreenStrategies = CollectionsKt.emptyList();
    @NotNull
    private static final Object activeLaunchersLock = new Object();
    @NotNull
    private static List<? extends TwaLauncher> activeLaunchers = CollectionsKt.emptyList();

    private TrustedWebActivity() {
    }

    public final void launch(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PayStationCache cache = PayStationCache.Companion.getInstance(request.getContext());
        CustomTabsSession customTabsSession = cache.getCachedSession();
        this.launchImpl(request, customTabsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyOnDestroy(boolean ignorePending) {
        List<? extends TwaLauncher> activeLaunchers_ = null;
        Object object = activeLaunchersLock;
        synchronized (object) {
            boolean $i$a$-synchronized-TrustedWebActivity$notifyOnDestroy$22 = false;
            activeLaunchers_ = activeLaunchers;
            activeLaunchers = CollectionsKt.emptyList();
            Unit $i$a$-synchronized-TrustedWebActivity$notifyOnDestroy$22 = Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = activeLaunchers_;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TwaLauncher launcher = (TwaLauncher)element$iv;
            boolean bl = false;
            launcher.destroy();
        }
        if (!ignorePending) {
            Object object2 = pendingRequestsLock;
            synchronized (object2) {
                boolean bl = false;
                pendingRequests = CollectionsKt.emptyList();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public static /* synthetic */ void notifyOnDestroy$default(TrustedWebActivity trustedWebActivity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        trustedWebActivity.notifyOnDestroy(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyOnCustomTabsSessionCreated(@NotNull CustomTabsSession customTabsSession) {
        Intrinsics.checkNotNullParameter((Object)customTabsSession, (String)"customTabsSession");
        List<Request> pendingLaunches_ = null;
        Object object = pendingRequestsLock;
        synchronized (object) {
            boolean bl = false;
            pendingLaunches_ = pendingRequests;
            pendingRequests = CollectionsKt.emptyList();
            Unit unit = Unit.INSTANCE;
        }
        Iterable $this$forEach$iv = pendingLaunches_;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Request request = (Request)element$iv;
            boolean bl = false;
            INSTANCE.launchImpl(request, customTabsSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void notifyOnEnterAnimationComplete() {
        void $this$filterIsInstanceTo$iv$iv;
        Object $i$a$-synchronized-TrustedWebActivity$notifyOnEnterAnimationComplete$22;
        List<? extends SplashScreenStrategy> pendingSplashScreenStrategies_ = null;
        Object object = pendingSplashScreenStrategiesLock;
        synchronized (object) {
            boolean $i$a$-synchronized-TrustedWebActivity$notifyOnEnterAnimationComplete$22 = false;
            pendingSplashScreenStrategies_ = pendingSplashScreenStrategies;
            pendingSplashScreenStrategies = CollectionsKt.emptyList();
            $i$a$-synchronized-TrustedWebActivity$notifyOnEnterAnimationComplete$22 = Unit.INSTANCE;
        }
        Iterable $this$filterIsInstance$iv = pendingSplashScreenStrategies_;
        boolean $i$f$filterIsInstance = false;
        $i$a$-synchronized-TrustedWebActivity$notifyOnEnterAnimationComplete$22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TrustedWebActivitySplashScreenStrategy)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TrustedWebActivitySplashScreenStrategy strategy = (TrustedWebActivitySplashScreenStrategy)element$iv;
            boolean bl = false;
            strategy.onActivityEnterAnimationComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void launchImpl(Request request, CustomTabsSession customTabsSession) {
        Object object;
        if (customTabsSession == null) {
            Log.v((String)LOG_TAG, (String)"CustomTabs session is not available, queuing up the TWA launch.");
            Object object2 = pendingRequestsLock;
            synchronized (object2) {
                boolean $i$a$-synchronized-TrustedWebActivity$launchImpl$22 = false;
                pendingRequests = CollectionsKt.plus((Collection)pendingRequests, (Object)request);
                Unit $i$a$-synchronized-TrustedWebActivity$launchImpl$22 = Unit.INSTANCE;
            }
            return;
        }
        Context context = request.getContext();
        Uri uri = Uri.parse((String)request.getUrl());
        SplashScreenStrategy splashScreenStrategy = null;
        SplashScreen splashScreen = request.getSplashScreen();
        int referenceColor = 0;
        if (splashScreen != null && context instanceof Activity) {
            void ref;
            TrustedWebActivityImageRef finalImageRef;
            Integer n = splashScreen.getBackgroundColor();
            referenceColor = n != null ? n : ContextCompat.getColor((Context)request.getContext(), (int)R.color.xsolla_payments_twa_background);
            TrustedWebActivityImageRef trustedWebActivityImageRef = splashScreen.getImageRef();
            if (trustedWebActivityImageRef == null) {
                TrustedWebActivityImageRef trustedWebActivityImageRef2 = TrustedWebActivityImageRef.getDefault();
                trustedWebActivityImageRef = trustedWebActivityImageRef2;
                Intrinsics.checkNotNullExpressionValue((Object)trustedWebActivityImageRef2, (String)"getDefault()");
            }
            TrustedWebActivityImageRef trustedWebActivityImageRef3 = finalImageRef = trustedWebActivityImageRef;
            Activity activity = (Activity)context;
            boolean bl = false;
            String string2 = ((Activity)context).getPackageName() + ((Activity)context).getResources().getString(R.string.xsolla_payments_fileprovider_authority);
            int n2 = splashScreen.getFadeOutTimeInMillis();
            Matrix matrix = null;
            ImageView.ScaleType scaleType = splashScreen.getImageScaleType();
            int n3 = referenceColor;
            TrustedWebActivitySplashScreenStrategy.Image image = TrustedWebActivitySplashScreenStrategy.Image.Companion.forRef(context, (TrustedWebActivityImageRef)ref);
            Activity activity2 = activity;
            splashScreenStrategy = new TrustedWebActivitySplashScreenStrategy(activity2, image, n3, scaleType, matrix, n2, string2);
        } else {
            splashScreenStrategy = null;
            referenceColor = ContextCompat.getColor((Context)request.getContext(), (int)R.color.xsolla_payments_twa_statusbar_darker);
        }
        CustomTabColorSchemeParams customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setNavigationBarColor(referenceColor).setToolbarColor(referenceColor).setSecondaryToolbarColor(referenceColor).setNavigationBarDividerColor(referenceColor).build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"Builder()\n            .s\u2026lor)\n            .build()");
        CustomTabColorSchemeParams colorSchemeParams = customTabColorSchemeParams;
        Integer n = request.getScreenOrientation();
        TrustedWebActivityIntentBuilder trustedWebActivityIntentBuilder = new TrustedWebActivityIntentBuilder(uri).setDefaultColorSchemeParams(colorSchemeParams).setScreenOrientation(n != null ? n : 0);
        Intrinsics.checkNotNullExpressionValue((Object)trustedWebActivityIntentBuilder, (String)"TrustedWebActivityIntent\u2026creenOrientation.DEFAULT)");
        TrustedWebActivityIntentBuilder builder = trustedWebActivityIntentBuilder;
        TwaLauncher launcher = new TwaLauncher(context);
        launcher.launch(builder, (CustomTabsCallback)new QualityEnforcer(), splashScreenStrategy, null);
        if (splashScreenStrategy != null) {
            object = pendingSplashScreenStrategiesLock;
            synchronized (object) {
                boolean $i$a$-synchronized-TrustedWebActivity$launchImpl$52 = false;
                pendingSplashScreenStrategies = CollectionsKt.plus((Collection)pendingSplashScreenStrategies, (Object)splashScreenStrategy);
                Unit $i$a$-synchronized-TrustedWebActivity$launchImpl$52 = Unit.INSTANCE;
            }
        }
        object = activeLaunchersLock;
        synchronized (object) {
            boolean bl = false;
            activeLaunchers = CollectionsKt.plus((Collection)activeLaunchers, (Object)launcher);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J:\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$Request;", "", "context", "Landroid/content/Context;", "url", "", "screenOrientation", "", "splashScreen", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$SplashScreen;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Integer;Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$SplashScreen;)V", "getContext", "()Landroid/content/Context;", "getScreenOrientation", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSplashScreen", "()Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$SplashScreen;", "getUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Integer;Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$SplashScreen;)Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$Request;", "equals", "", "other", "hashCode", "toString", "xsolla-payments-sdk_release"})
    public static final class Request {
        @NotNull
        private final Context context;
        @NotNull
        private final String url;
        @Nullable
        private final Integer screenOrientation;
        @Nullable
        private final SplashScreen splashScreen;

        public Request(@NotNull Context context, @NotNull String url, @Nullable Integer screenOrientation, @Nullable SplashScreen splashScreen) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.context = context;
            this.url = url;
            this.screenOrientation = screenOrientation;
            this.splashScreen = splashScreen;
        }

        public /* synthetic */ Request(Context context, String string, Integer n, SplashScreen splashScreen, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = null;
            }
            if ((n2 & 8) != 0) {
                splashScreen = null;
            }
            this(context, string, n, splashScreen);
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final Integer getScreenOrientation() {
            return this.screenOrientation;
        }

        @Nullable
        public final SplashScreen getSplashScreen() {
            return this.splashScreen;
        }

        @NotNull
        public final Context component1() {
            return this.context;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @Nullable
        public final Integer component3() {
            return this.screenOrientation;
        }

        @Nullable
        public final SplashScreen component4() {
            return this.splashScreen;
        }

        @NotNull
        public final Request copy(@NotNull Context context, @NotNull String url, @Nullable Integer screenOrientation, @Nullable SplashScreen splashScreen) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new Request(context, url, screenOrientation, splashScreen);
        }

        public static /* synthetic */ Request copy$default(Request request, Context context, String string, Integer n, SplashScreen splashScreen, int n2, Object object) {
            if ((n2 & 1) != 0) {
                context = request.context;
            }
            if ((n2 & 2) != 0) {
                string = request.url;
            }
            if ((n2 & 4) != 0) {
                n = request.screenOrientation;
            }
            if ((n2 & 8) != 0) {
                splashScreen = request.splashScreen;
            }
            return request.copy(context, string, n, splashScreen);
        }

        @NotNull
        public String toString() {
            return "Request(context=" + this.context + ", url=" + this.url + ", screenOrientation=" + this.screenOrientation + ", splashScreen=" + this.splashScreen + ')';
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + (this.screenOrientation == null ? 0 : ((Object)this.screenOrientation).hashCode());
            result = result * 31 + (this.splashScreen == null ? 0 : this.splashScreen.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Request)) {
                return false;
            }
            Request request = (Request)other;
            if (!Intrinsics.areEqual((Object)this.context, (Object)request.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)request.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.screenOrientation, (Object)request.screenOrientation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.splashScreen, (Object)request.splashScreen);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J:\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0003\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$SplashScreen;", "", "imageRef", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivityImageRef;", "imageScaleType", "Landroid/widget/ImageView$ScaleType;", "backgroundColor", "", "fadeOutTimeInMillis", "(Lcom/xsolla/android/payments/ui/utils/TrustedWebActivityImageRef;Landroid/widget/ImageView$ScaleType;Ljava/lang/Integer;I)V", "getBackgroundColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getFadeOutTimeInMillis", "()I", "getImageRef", "()Lcom/xsolla/android/payments/ui/utils/TrustedWebActivityImageRef;", "getImageScaleType", "()Landroid/widget/ImageView$ScaleType;", "component1", "component2", "component3", "component4", "copy", "(Lcom/xsolla/android/payments/ui/utils/TrustedWebActivityImageRef;Landroid/widget/ImageView$ScaleType;Ljava/lang/Integer;I)Lcom/xsolla/android/payments/ui/utils/TrustedWebActivity$SplashScreen;", "equals", "", "other", "hashCode", "toString", "", "xsolla-payments-sdk_release"})
    public static final class SplashScreen {
        @Nullable
        private final TrustedWebActivityImageRef imageRef;
        @NotNull
        private final ImageView.ScaleType imageScaleType;
        @Nullable
        private final Integer backgroundColor;
        private final int fadeOutTimeInMillis;

        public SplashScreen(@Nullable TrustedWebActivityImageRef imageRef, @NotNull ImageView.ScaleType imageScaleType, @ColorInt @Nullable Integer backgroundColor, int fadeOutTimeInMillis) {
            Intrinsics.checkNotNullParameter((Object)imageScaleType, (String)"imageScaleType");
            this.imageRef = imageRef;
            this.imageScaleType = imageScaleType;
            this.backgroundColor = backgroundColor;
            this.fadeOutTimeInMillis = fadeOutTimeInMillis;
        }

        public /* synthetic */ SplashScreen(TrustedWebActivityImageRef trustedWebActivityImageRef, ImageView.ScaleType scaleType, Integer n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                scaleType = ImageView.ScaleType.FIT_CENTER;
            }
            if ((n3 & 4) != 0) {
                n = null;
            }
            if ((n3 & 8) != 0) {
                n2 = 300;
            }
            this(trustedWebActivityImageRef, scaleType, n, n2);
        }

        @Nullable
        public final TrustedWebActivityImageRef getImageRef() {
            return this.imageRef;
        }

        @NotNull
        public final ImageView.ScaleType getImageScaleType() {
            return this.imageScaleType;
        }

        @Nullable
        public final Integer getBackgroundColor() {
            return this.backgroundColor;
        }

        public final int getFadeOutTimeInMillis() {
            return this.fadeOutTimeInMillis;
        }

        @Nullable
        public final TrustedWebActivityImageRef component1() {
            return this.imageRef;
        }

        @NotNull
        public final ImageView.ScaleType component2() {
            return this.imageScaleType;
        }

        @Nullable
        public final Integer component3() {
            return this.backgroundColor;
        }

        public final int component4() {
            return this.fadeOutTimeInMillis;
        }

        @NotNull
        public final SplashScreen copy(@Nullable TrustedWebActivityImageRef imageRef, @NotNull ImageView.ScaleType imageScaleType, @ColorInt @Nullable Integer backgroundColor, int fadeOutTimeInMillis) {
            Intrinsics.checkNotNullParameter((Object)imageScaleType, (String)"imageScaleType");
            return new SplashScreen(imageRef, imageScaleType, backgroundColor, fadeOutTimeInMillis);
        }

        public static /* synthetic */ SplashScreen copy$default(SplashScreen splashScreen, TrustedWebActivityImageRef trustedWebActivityImageRef, ImageView.ScaleType scaleType, Integer n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                trustedWebActivityImageRef = splashScreen.imageRef;
            }
            if ((n3 & 2) != 0) {
                scaleType = splashScreen.imageScaleType;
            }
            if ((n3 & 4) != 0) {
                n = splashScreen.backgroundColor;
            }
            if ((n3 & 8) != 0) {
                n2 = splashScreen.fadeOutTimeInMillis;
            }
            return splashScreen.copy(trustedWebActivityImageRef, scaleType, n, n2);
        }

        @NotNull
        public String toString() {
            return "SplashScreen(imageRef=" + this.imageRef + ", imageScaleType=" + this.imageScaleType + ", backgroundColor=" + this.backgroundColor + ", fadeOutTimeInMillis=" + this.fadeOutTimeInMillis + ')';
        }

        public int hashCode() {
            int result = this.imageRef == null ? 0 : this.imageRef.hashCode();
            result = result * 31 + this.imageScaleType.hashCode();
            result = result * 31 + (this.backgroundColor == null ? 0 : ((Object)this.backgroundColor).hashCode());
            result = result * 31 + Integer.hashCode(this.fadeOutTimeInMillis);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SplashScreen)) {
                return false;
            }
            SplashScreen splashScreen = (SplashScreen)other;
            if (!Intrinsics.areEqual((Object)this.imageRef, (Object)splashScreen.imageRef)) {
                return false;
            }
            if (this.imageScaleType != splashScreen.imageScaleType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.backgroundColor, (Object)splashScreen.backgroundColor)) {
                return false;
            }
            return this.fadeOutTimeInMillis == splashScreen.fadeOutTimeInMillis;
        }
    }
}

