/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.xsolla.android.payments.R;

public final class TrustedWebActivityImageRef
implements Parcelable {
    private static final String TAG = TrustedWebActivityImageRef.class.getSimpleName();
    public static final Parcelable.Creator<TrustedWebActivityImageRef> CREATOR = new Parcelable.Creator<TrustedWebActivityImageRef>(){

        @Nullable
        public TrustedWebActivityImageRef createFromParcel(@NonNull Parcel source) {
            Value value;
            block11: {
                String valueTypeName = source.readString();
                if (TextUtils.isEmpty((CharSequence)valueTypeName)) {
                    return null;
                }
                value = null;
                if (valueTypeName.compareToIgnoreCase(Value.DrawableId.class.getSimpleName()) == 0) {
                    try {
                        value = new Value.DrawableId(source.readInt());
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Failed to read drawable ID from the parcel", (Throwable)e);
                    }
                } else if (valueTypeName.compareToIgnoreCase(Value.Filepath.class.getSimpleName()) == 0) {
                    try {
                        String filepath = source.readString();
                        if (filepath != null) {
                            value = new Value.Filepath(filepath);
                            break block11;
                        }
                        Log.e((String)TAG, (String)"Failed to read filepath from the parcel");
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"Failed to read filepath from the parcel", (Throwable)e);
                    }
                } else if (valueTypeName.compareToIgnoreCase(Value.Empty.class.getSimpleName()) == 0) {
                    value = new Value.Empty();
                }
            }
            return value != null ? new TrustedWebActivityImageRef(value) : null;
        }

        public TrustedWebActivityImageRef[] newArray(int size) {
            return new TrustedWebActivityImageRef[size];
        }
    };
    @NonNull
    private final Value value;

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.value.getClass().getSimpleName());
        this.value.writeToParcel(dest);
    }

    public <T> T fold(@NonNull DrawableIdCallback<T> onDrawableId, @NonNull FilepathCallback<T> onFilepath, @NonNull EmptyCallback<T> onEmpty) {
        if (this.value instanceof Value.DrawableId) {
            return onDrawableId.onInvoke(((Value.DrawableId)this.value).drawableId);
        }
        if (this.value instanceof Value.Filepath) {
            return onFilepath.onInvoke(((Value.Filepath)this.value).filepath);
        }
        assert (this.value instanceof Value.Empty);
        return onEmpty.onInvoke();
    }

    @NonNull
    public static TrustedWebActivityImageRef forDrawableId(@DrawableRes int drawableId) {
        return new TrustedWebActivityImageRef(new Value.DrawableId(drawableId));
    }

    @NonNull
    public static TrustedWebActivityImageRef forFilepath(@NonNull String filepath) {
        return new TrustedWebActivityImageRef(new Value.Filepath(filepath));
    }

    @NonNull
    public static TrustedWebActivityImageRef getDefault() {
        return DefaultInstanceHolder.INSTANCE;
    }

    @NonNull
    public static TrustedWebActivityImageRef getEmpty() {
        return EmptyInstanceHolder.INSTANCE;
    }

    private TrustedWebActivityImageRef(@NonNull Value value) {
        this.value = value;
    }

    private static class EmptyInstanceHolder {
        private static final TrustedWebActivityImageRef INSTANCE = new TrustedWebActivityImageRef(new Value.Empty());

        private EmptyInstanceHolder() {
        }
    }

    private static class DefaultInstanceHolder {
        private static final TrustedWebActivityImageRef INSTANCE = TrustedWebActivityImageRef.forDrawableId(R.drawable.xsolla_payments_trusted_web_activity_background);

        private DefaultInstanceHolder() {
        }
    }

    private static abstract class Value {
        private Value() {
        }

        public abstract void writeToParcel(@NonNull Parcel var1);

        public static final class Empty
        extends Value {
            @Override
            public void writeToParcel(@NonNull Parcel dest) {
            }
        }

        public static final class Filepath
        extends Value {
            @NonNull
            public final String filepath;

            public Filepath(@NonNull String filepath) {
                this.filepath = filepath;
            }

            @Override
            public void writeToParcel(@NonNull Parcel dest) {
                dest.writeString(this.filepath);
            }
        }

        public static final class DrawableId
        extends Value {
            @DrawableRes
            public final int drawableId;

            public DrawableId(@DrawableRes int drawableId) {
                this.drawableId = drawableId;
            }

            @Override
            public void writeToParcel(@NonNull Parcel dest) {
                dest.writeInt(this.drawableId);
            }
        }
    }

    public static interface EmptyCallback<T> {
        public T onInvoke();
    }

    public static interface FilepathCallback<T> {
        public T onInvoke(@NonNull String var1);
    }

    public static interface DrawableIdCallback<T> {
        public T onInvoke(@DrawableRes int var1);
    }
}

