/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsSession;
import androidx.browser.customtabs.TrustedWebUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;

final class TrustedWebActivitySplashImageTransferTask {
    private static final String TAG = "SplashImageTransferTask";
    private static final String FOLDER_NAME = "twa_splash";
    private static final String FILE_NAME = "splash_image.png";
    private static final String PREFS_FILE = "splashImagePrefs";
    private static final String PREF_LAST_UPDATE_TIME = "lastUpdateTime";
    @NonNull
    private final Context mContext;
    @NonNull
    private final Bitmap mBitmap;
    @NonNull
    private final String mAuthority;
    @NonNull
    private final CustomTabsSession mSession;
    @NonNull
    private final String mProviderPackage;
    @Nullable
    private Callback mCallback;
    @SuppressLint(value={"StaticFieldLeak"})
    private final AsyncTask<Void, Void, Boolean> mAsyncTask = new AsyncTask<Void, Void, Boolean>(){

        protected Boolean doInBackground(Void ... args) {
            boolean mkDirSuccessful;
            if (this.isCancelled()) {
                return false;
            }
            File dir = new File(TrustedWebActivitySplashImageTransferTask.this.mContext.getFilesDir(), TrustedWebActivitySplashImageTransferTask.FOLDER_NAME);
            if (!dir.exists() && !(mkDirSuccessful = dir.mkdir())) {
                Log.w((String)TrustedWebActivitySplashImageTransferTask.TAG, (String)"Failed to create a directory for storing a splash image");
                return false;
            }
            File file = new File(dir, TrustedWebActivitySplashImageTransferTask.FILE_NAME);
            Log.e((String)TrustedWebActivitySplashImageTransferTask.TAG, (String)Arrays.toString(dir.listFiles()));
            SharedPreferences prefs = TrustedWebActivitySplashImageTransferTask.this.mContext.getSharedPreferences(TrustedWebActivitySplashImageTransferTask.PREFS_FILE, 0);
            long lastUpdateTime = this.getLastAppUpdateTime();
            if (file.exists() && lastUpdateTime == prefs.getLong(TrustedWebActivitySplashImageTransferTask.PREF_LAST_UPDATE_TIME, 0L)) {
                return this.transferToCustomTabsProvider(file);
            }
            try {
                FileOutputStream os = new FileOutputStream(file);
                boolean success = false;
                try {
                    if (!this.isCancelled()) {
                        TrustedWebActivitySplashImageTransferTask.this.mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
                        os.flush();
                        prefs.edit().putLong(TrustedWebActivitySplashImageTransferTask.PREF_LAST_UPDATE_TIME, lastUpdateTime).apply();
                        if (!this.isCancelled()) {
                            success = this.transferToCustomTabsProvider(file);
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Exception e1) {
                        e.addSuppressed(e1);
                    }
                    throw e;
                }
                ((OutputStream)os).close();
                return success;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean transferToCustomTabsProvider(@NonNull File f) {
            return TrustedWebUtils.transferSplashImage((Context)TrustedWebActivitySplashImageTransferTask.this.mContext, (File)f, (String)TrustedWebActivitySplashImageTransferTask.this.mAuthority, (String)TrustedWebActivitySplashImageTransferTask.this.mProviderPackage, (CustomTabsSession)TrustedWebActivitySplashImageTransferTask.this.mSession);
        }

        private long getLastAppUpdateTime() {
            try {
                PackageInfo packageInfo = TrustedWebActivitySplashImageTransferTask.this.mContext.getPackageManager().getPackageInfo(TrustedWebActivitySplashImageTransferTask.this.mContext.getPackageName(), 0);
                return packageInfo.lastUpdateTime;
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        protected void onPostExecute(Boolean success) {
            if (TrustedWebActivitySplashImageTransferTask.this.mCallback != null && !this.isCancelled()) {
                TrustedWebActivitySplashImageTransferTask.this.mCallback.onFinished(success);
            }
        }
    };

    public TrustedWebActivitySplashImageTransferTask(@NonNull Context context, @NonNull Bitmap bitmap, @NonNull String authority, @NonNull CustomTabsSession session, @NonNull String providerPackage) {
        this.mContext = context.getApplicationContext();
        this.mBitmap = bitmap;
        this.mAuthority = authority;
        this.mSession = session;
        this.mProviderPackage = providerPackage;
    }

    public void execute(@NonNull Callback callback) {
        assert (this.mAsyncTask.getStatus() == AsyncTask.Status.PENDING);
        this.mCallback = callback;
        this.mAsyncTask.execute((Object[])new Void[0]);
    }

    public void cancel() {
        this.mAsyncTask.cancel(true);
        this.mCallback = null;
    }

    public static interface Callback {
        public void onFinished(boolean var1);
    }
}

