/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.browser.customtabs.CustomTabsSession;
import androidx.browser.customtabs.TrustedWebUtils;
import androidx.browser.trusted.TrustedWebActivityIntentBuilder;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.graphics.drawable.DrawableKt;
import com.google.androidbrowserhelper.trusted.Utils;
import com.google.androidbrowserhelper.trusted.splashscreens.SplashScreenStrategy;
import com.xsolla.android.payments.ui.utils.TrustedWebActivityImageRef;
import com.xsolla.android.payments.ui.utils.TrustedWebActivitySplashImageTransferTask;
import com.xsolla.android.payments.ui.utils.TrustedWebActivitySystemBarColorPredictor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 -2\u00020\u0001:\u0002-.BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0016J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010#\u001a\u00020\u001bJ\b\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020\u001bJ \u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0013H\u0002J\b\u0010,\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashScreenStrategy;", "Lcom/google/androidbrowserhelper/trusted/splashscreens/SplashScreenStrategy;", "mActivity", "Landroid/app/Activity;", "mImage", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashScreenStrategy$Image;", "mBackgroundColor", "", "mScaleType", "Landroid/widget/ImageView$ScaleType;", "mTransformationMatrix", "Landroid/graphics/Matrix;", "mFadeOutDurationMillis", "mFileProviderAuthority", "", "(Landroid/app/Activity;Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashScreenStrategy$Image;ILandroid/widget/ImageView$ScaleType;Landroid/graphics/Matrix;ILjava/lang/String;)V", "mEnterAnimationComplete", "", "mOnEnterAnimationCompleteRunnable", "Ljava/lang/Runnable;", "mProviderPackage", "mProviderSupportsSplashScreens", "mSplashImage", "Landroid/graphics/Bitmap;", "mSplashImageTransferTask", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashImageTransferTask;", "configureTwaBuilder", "", "builder", "Landroidx/browser/trusted/TrustedWebActivityIntentBuilder;", "session", "Landroidx/browser/customtabs/CustomTabsSession;", "onReadyCallback", "customizeStatusAndNavBarDuringSplashScreen", "providerPackage", "destroy", "makeSplashScreenParamsBundle", "Landroid/os/Bundle;", "onActivityEnterAnimationComplete", "onSplashImageTransferred", "success", "onTwaLaunchInitiated", "runWhenEnterAnimationComplete", "runnable", "showSplashScreen", "Companion", "Image", "xsolla-payments-sdk_release"})
public final class TrustedWebActivitySplashScreenStrategy
implements SplashScreenStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity mActivity;
    @Nullable
    private final Image mImage;
    private final int mBackgroundColor;
    @NotNull
    private final ImageView.ScaleType mScaleType;
    @Nullable
    private final Matrix mTransformationMatrix;
    private final int mFadeOutDurationMillis;
    @NotNull
    private final String mFileProviderAuthority;
    @Nullable
    private Bitmap mSplashImage;
    @Nullable
    private TrustedWebActivitySplashImageTransferTask mSplashImageTransferTask;
    @Nullable
    private String mProviderPackage;
    private boolean mProviderSupportsSplashScreens;
    private boolean mEnterAnimationComplete;
    @Nullable
    private Runnable mOnEnterAnimationCompleteRunnable;
    @NotNull
    private static final String TAG = "SplashScreenStrategy";
    @NotNull
    private static final TrustedWebActivitySystemBarColorPredictor sSystemBarColorPredictor = new TrustedWebActivitySystemBarColorPredictor();

    public TrustedWebActivitySplashScreenStrategy(@NotNull Activity mActivity, @Nullable Image mImage, @ColorInt int mBackgroundColor, @NotNull ImageView.ScaleType mScaleType, @Nullable Matrix mTransformationMatrix, int mFadeOutDurationMillis, @NotNull String mFileProviderAuthority) {
        Intrinsics.checkNotNullParameter((Object)mActivity, (String)"mActivity");
        Intrinsics.checkNotNullParameter((Object)mScaleType, (String)"mScaleType");
        Intrinsics.checkNotNullParameter((Object)mFileProviderAuthority, (String)"mFileProviderAuthority");
        this.mActivity = mActivity;
        this.mImage = mImage;
        this.mBackgroundColor = mBackgroundColor;
        this.mScaleType = mScaleType;
        this.mTransformationMatrix = mTransformationMatrix;
        this.mFadeOutDurationMillis = mFadeOutDurationMillis;
        this.mFileProviderAuthority = mFileProviderAuthority;
        this.mEnterAnimationComplete = Build.VERSION.SDK_INT < 21;
    }

    public void onTwaLaunchInitiated(@NotNull String providerPackage, @NotNull TrustedWebActivityIntentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)providerPackage, (String)"providerPackage");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.mProviderPackage = providerPackage;
        this.mProviderSupportsSplashScreens = TrustedWebUtils.areSplashScreensSupported((Context)((Context)this.mActivity), (String)providerPackage, (String)"androidx.browser.trusted.category.TrustedWebActivitySplashScreensV1");
        if (!this.mProviderSupportsSplashScreens) {
            Log.w((String)TAG, (String)("Provider " + providerPackage + " doesn't support splash screens"));
        } else {
            this.showSplashScreen();
            if (this.mSplashImage != null) {
                this.customizeStatusAndNavBarDuringSplashScreen(providerPackage, builder);
            }
        }
    }

    private final void showSplashScreen() {
        Image image = this.mImage;
        Object object = this.mSplashImage = image != null ? image.getBitmap() : null;
        if (this.mSplashImage == null) {
            Log.w((String)TAG, (String)"Failed to retrieve splash image");
        } else {
            ImageView view = new ImageView((Context)this.mActivity);
            view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            view.setImageBitmap(this.mSplashImage);
            view.setBackgroundColor(this.mBackgroundColor);
            view.setScaleType(this.mScaleType);
            if (this.mScaleType == ImageView.ScaleType.MATRIX) {
                view.setImageMatrix(this.mTransformationMatrix);
            }
            this.mActivity.setContentView((View)view);
        }
    }

    private final void customizeStatusAndNavBarDuringSplashScreen(String providerPackage, TrustedWebActivityIntentBuilder builder) {
        Integer statusBarColor;
        Integer navbarColor = sSystemBarColorPredictor.getExpectedNavbarColor((Context)this.mActivity, providerPackage, builder);
        if (navbarColor != null) {
            Utils.setNavigationBarColor((Activity)this.mActivity, (int)navbarColor);
        }
        if ((statusBarColor = sSystemBarColorPredictor.getExpectedStatusBarColor((Context)this.mActivity, providerPackage, builder)) != null) {
            Utils.setStatusBarColor((Activity)this.mActivity, (int)statusBarColor);
        }
    }

    public void configureTwaBuilder(@NotNull TrustedWebActivityIntentBuilder builder, @NotNull CustomTabsSession session, @NotNull Runnable onReadyCallback) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)onReadyCallback, (String)"onReadyCallback");
        if (this.mProviderSupportsSplashScreens && this.mSplashImage != null && this.mProviderPackage != null) {
            if (TextUtils.isEmpty((CharSequence)this.mFileProviderAuthority)) {
                Log.w((String)TAG, (String)"FileProvider authority not specified, can't transfer splash image.");
                onReadyCallback.run();
            } else {
                Context context = (Context)this.mActivity;
                Bitmap bitmap = this.mSplashImage;
                Intrinsics.checkNotNull((Object)bitmap);
                String string2 = this.mProviderPackage;
                Intrinsics.checkNotNull((Object)string2);
                TrustedWebActivitySplashImageTransferTask trustedWebActivitySplashImageTransferTask = this.mSplashImageTransferTask = new TrustedWebActivitySplashImageTransferTask(context, bitmap, this.mFileProviderAuthority, session, string2);
                Intrinsics.checkNotNull((Object)trustedWebActivitySplashImageTransferTask);
                trustedWebActivitySplashImageTransferTask.execute(arg_0 -> TrustedWebActivitySplashScreenStrategy.configureTwaBuilder$lambda-0(this, builder, onReadyCallback, arg_0));
            }
        } else {
            onReadyCallback.run();
        }
    }

    private final void onSplashImageTransferred(TrustedWebActivityIntentBuilder builder, boolean success, Runnable onReadyCallback) {
        if (!success) {
            Log.w((String)TAG, (String)"Failed to transfer splash image.");
            onReadyCallback.run();
        } else {
            builder.setSplashScreenParams(this.makeSplashScreenParamsBundle());
            this.runWhenEnterAnimationComplete(() -> TrustedWebActivitySplashScreenStrategy.onSplashImageTransferred$lambda-1(onReadyCallback, this));
        }
    }

    private final void runWhenEnterAnimationComplete(Runnable runnable) {
        if (this.mEnterAnimationComplete) {
            runnable.run();
        } else {
            this.mOnEnterAnimationCompleteRunnable = runnable;
        }
    }

    private final Bundle makeSplashScreenParamsBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("androidx.browser.trusted.KEY_SPLASH_SCREEN_VERSION", "androidx.browser.trusted.category.TrustedWebActivitySplashScreensV1");
        bundle.putInt("androidx.browser.trusted.KEY_SPLASH_SCREEN_FADE_OUT_DURATION", this.mFadeOutDurationMillis);
        bundle.putInt("androidx.browser.trusted.trusted.KEY_SPLASH_SCREEN_BACKGROUND_COLOR", this.mBackgroundColor);
        bundle.putInt("androidx.browser.trusted.KEY_SPLASH_SCREEN_SCALE_TYPE", this.mScaleType.ordinal());
        if (this.mTransformationMatrix != null) {
            float[] values = new float[9];
            this.mTransformationMatrix.getValues(values);
            bundle.putFloatArray("androidx.browser.trusted.KEY_SPLASH_SCREEN_TRANSFORMATION_MATRIX", values);
        }
        return bundle;
    }

    public final void onActivityEnterAnimationComplete() {
        this.mEnterAnimationComplete = true;
        if (this.mOnEnterAnimationCompleteRunnable != null) {
            Runnable runnable = this.mOnEnterAnimationCompleteRunnable;
            Intrinsics.checkNotNull((Object)runnable);
            runnable.run();
            this.mOnEnterAnimationCompleteRunnable = null;
        }
    }

    public final void destroy() {
        if (this.mSplashImageTransferTask != null) {
            TrustedWebActivitySplashImageTransferTask trustedWebActivitySplashImageTransferTask = this.mSplashImageTransferTask;
            Intrinsics.checkNotNull((Object)trustedWebActivitySplashImageTransferTask);
            trustedWebActivitySplashImageTransferTask.cancel();
        }
    }

    private static final void configureTwaBuilder$lambda-0(TrustedWebActivitySplashScreenStrategy this$0, TrustedWebActivityIntentBuilder $builder, Runnable $onReadyCallback, boolean success) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)$onReadyCallback, (String)"$onReadyCallback");
        this$0.onSplashImageTransferred($builder, success, $onReadyCallback);
    }

    private static final void onSplashImageTransferred$lambda-1(Runnable $onReadyCallback, TrustedWebActivitySplashScreenStrategy this$0) {
        Intrinsics.checkNotNullParameter((Object)$onReadyCallback, (String)"$onReadyCallback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $onReadyCallback.run();
        this$0.mActivity.overridePendingTransition(0, 0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashScreenStrategy$Image;", "", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "Companion", "xsolla-payments-sdk_release"})
    public static final class Image {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Bitmap bitmap;

        private Image(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public /* synthetic */ Image(Bitmap bitmap, DefaultConstructorMarker $constructor_marker) {
            this(bitmap);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashScreenStrategy$Image$Companion;", "", "()V", "forDrawable", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashScreenStrategy$Image;", "drawable", "Landroid/graphics/drawable/Drawable;", "forDrawableId", "context", "Landroid/content/Context;", "id", "", "forEmpty", "", "forFilepath", "filepath", "", "forRef", "ref", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivityImageRef;", "xsolla-payments-sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Image forRef(@NotNull Context context, @NotNull TrustedWebActivityImageRef ref) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                return ref.fold(arg_0 -> Companion.forRef$lambda-0(context, arg_0), arg_0 -> Companion.forRef$lambda-1(context, arg_0), Companion::forRef$lambda-2);
            }

            private final Image forDrawable(Drawable drawable) {
                try {
                    float aspect;
                    float f;
                    Drawable drawable2 = DrawableCompat.wrap((Drawable)drawable);
                    Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"wrap(drawable)");
                    Drawable wrappedDrawable = drawable2;
                    int MAX_WIDTH = 1024;
                    int MAX_HEIGHT = 1024;
                    int width = 0;
                    width = wrappedDrawable.getIntrinsicWidth();
                    int height = wrappedDrawable.getIntrinsicHeight();
                    Integer n = height;
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    Integer n2 = it > 0 ? n : null;
                    if (n2 != null) {
                        int it2 = ((Number)n2).intValue();
                        boolean bl2 = false;
                        f = (float)width / (float)it2;
                    } else {
                        f = aspect = 1.0f;
                    }
                    if (width > MAX_WIDTH) {
                        width = MAX_WIDTH;
                        height = (int)((float)width / aspect);
                        Log.d((String)TrustedWebActivitySplashScreenStrategy.TAG, (String)("Splash screen drawable is too wide, limiting to " + MAX_WIDTH));
                    } else if (height > MAX_HEIGHT) {
                        height = MAX_HEIGHT;
                        width = (int)((float)height * aspect);
                        Log.d((String)TrustedWebActivitySplashScreenStrategy.TAG, (String)("Splash screen drawable is too tall, limiting to " + MAX_HEIGHT));
                    }
                    Bitmap bitmap = DrawableKt.toBitmap$default((Drawable)wrappedDrawable, (int)width, (int)height, null, (int)4, null);
                    return new Image(bitmap, null);
                }
                catch (Exception e) {
                    Log.e((String)TrustedWebActivitySplashScreenStrategy.TAG, (String)"Failed to create an image for a drawable", (Throwable)e);
                    return null;
                }
            }

            private final Image forDrawableId(Context context, @DrawableRes int id2) {
                Image image;
                Drawable drawable;
                Drawable drawable2 = drawable = ContextCompat.getDrawable((Context)context, (int)id2);
                if (drawable2 != null) {
                    Drawable p0 = drawable2;
                    boolean bl = false;
                    image = this.forDrawable(p0);
                } else {
                    image = null;
                }
                return image;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final Image forFilepath(Context context, String filepath) {
                InputStream stream = null;
                try {
                    stream = new FileInputStream(filepath);
                }
                catch (IOException e) {
                    try {
                        stream = context.getAssets().open(filepath);
                    }
                    catch (IOException e1) {
                        Log.e((String)TrustedWebActivitySplashScreenStrategy.TAG, (String)("Failed to locate splash screen image at: " + filepath));
                        return null;
                    }
                }
                InputStream inputStream = stream;
                if (inputStream == null) return null;
                InputStream it = inputStream;
                boolean bl = false;
                Drawable drawable = Drawable.createFromStream((InputStream)it, null);
                if (drawable == null) return null;
                Drawable p0 = drawable;
                boolean bl2 = false;
                Image image = this.forDrawable(p0);
                return image;
            }

            private final Void forEmpty() {
                return null;
            }

            private static final Image forRef$lambda-0(Context $context, int drawableId) {
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                return Companion.forDrawableId($context, drawableId);
            }

            private static final Image forRef$lambda-1(Context $context, String filepath) {
                Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
                Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
                return Companion.forFilepath($context, filepath);
            }

            private static final Image forRef$lambda-2() {
                return (Image)((Object)Companion.forEmpty());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySplashScreenStrategy$Companion;", "", "()V", "TAG", "", "sSystemBarColorPredictor", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySystemBarColorPredictor;", "xsolla-payments-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

