/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.payments.ui.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.trusted.TrustedWebActivityIntentBuilder;
import com.google.androidbrowserhelper.trusted.ChromeLegacyUtils;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySystemBarColorPredictor;", "", "()V", "mSupportedFeaturesCache", "", "", "Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySystemBarColorPredictor$SupportedFeatures;", "getExpectedNavbarColor", "", "context", "Landroid/content/Context;", "providerPackage", "builder", "Landroidx/browser/trusted/TrustedWebActivityIntentBuilder;", "(Landroid/content/Context;Ljava/lang/String;Landroidx/browser/trusted/TrustedWebActivityIntentBuilder;)Ljava/lang/Integer;", "getExpectedStatusBarColor", "getSupportedFeatures", "providerSupportsColorSchemeParams", "", "providerSupportsNavBarColorCustomization", "Companion", "SupportedFeatures", "xsolla-payments-sdk_release"})
public final class TrustedWebActivitySystemBarColorPredictor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, SupportedFeatures> mSupportedFeaturesCache = new HashMap();

    @Nullable
    public final Integer getExpectedStatusBarColor(@NotNull Context context, @NotNull String providerPackage, @NotNull TrustedWebActivityIntentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)providerPackage, (String)"providerPackage");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intent intent = builder.buildCustomTabsIntent().intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"builder.buildCustomTabsIntent().intent");
        Intent intent2 = intent;
        if (this.providerSupportsColorSchemeParams(context, providerPackage)) {
            int colorScheme = TrustedWebActivitySystemBarColorPredictor.Companion.getExpectedColorScheme(context, builder);
            CustomTabColorSchemeParams customTabColorSchemeParams = CustomTabsIntent.getColorSchemeParams((Intent)intent2, (int)colorScheme);
            Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"getColorSchemeParams(intent, colorScheme)");
            CustomTabColorSchemeParams params = customTabColorSchemeParams;
            return params.toolbarColor;
        }
        Bundle extras = intent2.getExtras();
        return extras != null ? (Integer)extras.get("android.support.customtabs.extra.TOOLBAR_COLOR") : null;
    }

    @Nullable
    public final Integer getExpectedNavbarColor(@NotNull Context context, @NotNull String providerPackage, @NotNull TrustedWebActivityIntentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)providerPackage, (String)"providerPackage");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intent intent = builder.buildCustomTabsIntent().intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"builder.buildCustomTabsIntent().intent");
        Intent intent2 = intent;
        if (this.providerSupportsNavBarColorCustomization(context, providerPackage)) {
            Integer n;
            Bundle extras;
            if (this.providerSupportsColorSchemeParams(context, providerPackage)) {
                int colorScheme = TrustedWebActivitySystemBarColorPredictor.Companion.getExpectedColorScheme(context, builder);
                CustomTabColorSchemeParams customTabColorSchemeParams = CustomTabsIntent.getColorSchemeParams((Intent)intent2, (int)colorScheme);
                Intrinsics.checkNotNullExpressionValue((Object)customTabColorSchemeParams, (String)"getColorSchemeParams(intent, colorScheme)");
                CustomTabColorSchemeParams params = customTabColorSchemeParams;
                return params.navigationBarColor;
            }
            Bundle bundle = extras = intent2.getExtras();
            if (bundle != null) {
                Bundle it = bundle;
                boolean bl = false;
                n = (Integer)it.get("androidx.browser.customtabs.extra.NAVIGATION_BAR_COLOR");
            } else {
                n = null;
            }
            return n;
        }
        return ChromeLegacyUtils.usesWhiteNavbar((String)providerPackage) ? Integer.valueOf(-1) : null;
    }

    private final boolean providerSupportsNavBarColorCustomization(Context context, String providerPackage) {
        return this.getSupportedFeatures(context, providerPackage).getNavbarColorCustomization();
    }

    private final boolean providerSupportsColorSchemeParams(Context context, String providerPackage) {
        return this.getSupportedFeatures(context, providerPackage).getColorSchemeCustomization();
    }

    private final SupportedFeatures getSupportedFeatures(Context context, String providerPackage) {
        SupportedFeatures cached = this.mSupportedFeaturesCache.get(providerPackage);
        if (cached != null) {
            return cached;
        }
        if (ChromeLegacyUtils.supportsNavbarAndColorCustomization((PackageManager)context.getPackageManager(), (String)providerPackage)) {
            SupportedFeatures features = new SupportedFeatures(true, true);
            this.mSupportedFeaturesCache.put(providerPackage, features);
            return features;
        }
        Intent intent = new Intent().setAction("android.support.customtabs.action.CustomTabsService").setPackage(providerPackage);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent()\n               \u2026tPackage(providerPackage)");
        Intent serviceIntent = intent;
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(serviceIntent, 64);
        SupportedFeatures features = new SupportedFeatures(TrustedWebActivitySystemBarColorPredictor.Companion.hasCategory(resolveInfo, "androidx.browser.customtabs.category.NavBarColorCustomization"), TrustedWebActivitySystemBarColorPredictor.Companion.hasCategory(resolveInfo, "androidx.browser.customtabs.category.ColorSchemeCustomization"));
        this.mSupportedFeaturesCache.put(providerPackage, features);
        return features;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySystemBarColorPredictor$SupportedFeatures;", "", "navbarColorCustomization", "", "colorSchemeCustomization", "(ZZ)V", "getColorSchemeCustomization", "()Z", "getNavbarColorCustomization", "xsolla-payments-sdk_release"})
    private static final class SupportedFeatures {
        private final boolean navbarColorCustomization;
        private final boolean colorSchemeCustomization;

        public SupportedFeatures(boolean navbarColorCustomization, boolean colorSchemeCustomization) {
            this.navbarColorCustomization = navbarColorCustomization;
            this.colorSchemeCustomization = colorSchemeCustomization;
        }

        public final boolean getNavbarColorCustomization() {
            return this.navbarColorCustomization;
        }

        public final boolean getColorSchemeCustomization() {
            return this.colorSchemeCustomization;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/xsolla/android/payments/ui/utils/TrustedWebActivitySystemBarColorPredictor$Companion;", "", "()V", "getExpectedColorScheme", "", "context", "Landroid/content/Context;", "builder", "Landroidx/browser/trusted/TrustedWebActivityIntentBuilder;", "hasCategory", "", "info", "Landroid/content/pm/ResolveInfo;", "category", "", "xsolla-payments-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasCategory(ResolveInfo info, String category) {
            ResolveInfo resolveInfo = info;
            return (resolveInfo != null ? resolveInfo.filter : null) != null && info.filter.hasCategory(category);
        }

        private final int getExpectedColorScheme(Context context, TrustedWebActivityIntentBuilder builder) {
            Integer scheme;
            Integer n;
            Bundle extras;
            Intent intent = builder.buildCustomTabsIntent().intent;
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"builder.buildCustomTabsIntent().intent");
            Intent intent2 = intent;
            Bundle bundle = extras = intent2.getExtras();
            if (bundle != null) {
                Bundle it = bundle;
                boolean bl = false;
                n = (Integer)it.get("androidx.browser.customtabs.extra.COLOR_SCHEME");
            } else {
                n = scheme = null;
            }
            if (scheme != null && scheme != 0) {
                return scheme;
            }
            boolean systemIsInDarkMode = (context.getResources().getConfiguration().uiMode & 0x30) == 32;
            return systemIsInDarkMode ? 2 : 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

