/*
 * Decompiled with CFR 0.152.
 */
package com.xsolla.android.store.orders;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.xsolla.android.store.api.StoreApi;
import com.xsolla.android.store.callbacks.OrderStatusListener;
import com.xsolla.android.store.entity.response.order.OrderResponse;
import com.xsolla.android.store.entity.response.order.WsOrderResponse;
import io.github.centrifugal.centrifuge.Client;
import io.github.centrifugal.centrifuge.ClientState;
import io.github.centrifugal.centrifuge.ErrorEvent;
import io.github.centrifugal.centrifuge.EventListener;
import io.github.centrifugal.centrifuge.Options;
import io.github.centrifugal.centrifuge.ServerPublicationEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\fH\u0002J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/xsolla/android/store/orders/OrdersTracker;", "", "storeApi", "Lcom/xsolla/android/store/api/StoreApi;", "(Lcom/xsolla/android/store/api/StoreApi;)V", "centrifugoClient", "Lio/github/centrifugal/centrifuge/Client;", "listeners", "", "", "Lcom/xsolla/android/store/callbacks/OrderStatusListener;", "addToTracking", "", "listener", "orderId", "accessToken", "projectId", "", "onListenersModified", "startOrderShortPolling", "switchToShortPolling", "CentrifugeConnectionData", "Companion", "xsolla-store-sdk_release"})
public final class OrdersTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StoreApi storeApi;
    @NotNull
    private Map<String, OrderStatusListener> listeners;
    @Nullable
    private Client centrifugoClient;
    @NotNull
    private static final String CENTRIFUGO_ENDPOINT = "wss://ws-store.xsolla.com/connection/websocket";
    private static final long SHORT_POLLING_TIMEOUT = 3000L;

    public OrdersTracker(@NotNull StoreApi storeApi) {
        Intrinsics.checkNotNullParameter((Object)storeApi, (String)"storeApi");
        this.storeApi = storeApi;
        this.listeners = new LinkedHashMap();
    }

    public final void addToTracking(@NotNull OrderStatusListener listener, @NotNull String orderId, @NotNull String accessToken, int projectId) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)orderId, (String)"orderId");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.listeners.put(orderId, listener);
            if (this.centrifugoClient != null) {
                return;
            }
            EventListener centrifugeListener2 = new EventListener(this, projectId){
                final /* synthetic */ OrdersTracker this$0;
                final /* synthetic */ int $projectId;
                {
                    this.this$0 = $receiver;
                    this.$projectId = $projectId;
                }

                public void onError(@Nullable Client client, @NotNull ErrorEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Object[] objectArray = new ClientState[]{ClientState.CONNECTED, ClientState.CONNECTING};
                    Client client2 = OrdersTracker.access$getCentrifugoClient$p(this.this$0);
                    if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)(client2 != null ? client2.getState() : null))) {
                        event.getError().printStackTrace();
                        OrdersTracker.access$switchToShortPolling(this.this$0, this.$projectId);
                    }
                }

                public void onPublication(@Nullable Client client, @Nullable ServerPublicationEvent event) {
                    byte[] data;
                    ServerPublicationEvent serverPublicationEvent = event;
                    Object object = data = (Object)(serverPublicationEvent != null ? serverPublicationEvent.getData() : null);
                    if (data != null) {
                        WsOrderResponse wsOrderResponse;
                        try {
                            wsOrderResponse = (WsOrderResponse)new Gson().fromJson(new String(data, Charsets.UTF_8), WsOrderResponse.class);
                        }
                        catch (JsonSyntaxException e) {
                            e.printStackTrace();
                            OrdersTracker.access$switchToShortPolling(this.this$0, this.$projectId);
                            return;
                        }
                        WsOrderResponse response = wsOrderResponse;
                        String listenerKey = String.valueOf(response.getOrderId());
                        OrderStatusListener orderListener = (OrderStatusListener)OrdersTracker.access$getListeners$p(this.this$0).get(listenerKey);
                        if (orderListener != null) {
                            orderListener.onStatusUpdate(response.getStatus());
                            OrderResponse.Status[] statusArray = new OrderResponse.Status[]{OrderResponse.Status.DONE, OrderResponse.Status.CANCELED};
                            if (CollectionsKt.listOf((Object[])statusArray).contains((Object)((Object)response.getStatus()))) {
                                OrdersTracker.access$getListeners$p(this.this$0).remove(listenerKey);
                                OrdersTracker.access$onListenersModified(this.this$0);
                            }
                        }
                    }
                }
            };
            Options centrifugeOptions = new Options();
            CentrifugeConnectionData centrifugeData = new CentrifugeConnectionData(accessToken, projectId);
            String string = new Gson().toJson((Object)centrifugeData);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(centrifugeData)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            centrifugeOptions.setData(byArray);
            Client client = this.centrifugoClient = new Client(CENTRIFUGO_ENDPOINT, centrifugeOptions, centrifugeListener2);
            if (client == null) break block1;
            client.connect();
        }
    }

    private final void onListenersModified() {
        if (this.listeners.isEmpty()) {
            Client client = this.centrifugoClient;
            if (client != null) {
                client.close(0L);
            }
            this.centrifugoClient = null;
        }
    }

    private final void switchToShortPolling(int projectId) {
        Map<String, OrderStatusListener> $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, OrderStatusListener>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, OrderStatusListener> element$iv;
            Map.Entry<String, OrderStatusListener> it = element$iv = iterator.next();
            boolean bl = false;
            this.startOrderShortPolling(it.getValue(), it.getKey(), projectId);
        }
        this.listeners.clear();
        this.onListenersModified();
    }

    private final void startOrderShortPolling(OrderStatusListener listener, String orderId, int projectId) {
        Runnable runnable;
        Timer delayTimer = new Timer();
        Ref.ObjectRef singleRunTask = new Ref.ObjectRef();
        singleRunTask.element = () -> OrdersTracker.startOrderShortPolling$lambda-1(this, projectId, orderId, delayTimer, listener, singleRunTask);
        if (singleRunTask.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"singleRunTask");
            runnable = null;
        } else {
            runnable = (Runnable)singleRunTask.element;
        }
        runnable.run();
    }

    private static final void startOrderShortPolling$lambda-1(OrdersTracker this$0, int $projectId, String $orderId, Timer $delayTimer, OrderStatusListener $listener, Ref.ObjectRef $singleRunTask) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$orderId, (String)"$orderId");
        Intrinsics.checkNotNullParameter((Object)$delayTimer, (String)"$delayTimer");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)$singleRunTask, (String)"$singleRunTask");
        this$0.storeApi.getOrder($projectId, $orderId).enqueue((Callback)new Callback<OrderResponse>($delayTimer, $listener, (Ref.ObjectRef<Runnable>)$singleRunTask){
            final /* synthetic */ Timer $delayTimer;
            final /* synthetic */ OrderStatusListener $listener;
            final /* synthetic */ Ref.ObjectRef<Runnable> $singleRunTask;
            {
                this.$delayTimer = $delayTimer;
                this.$listener = $listener;
                this.$singleRunTask = $singleRunTask;
            }

            public void onResponse(@NotNull Call<OrderResponse> call, @NotNull Response<OrderResponse> response) {
                OrderResponse.Status status;
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                OrderResponse orderResponse = (OrderResponse)response.body();
                OrderResponse.Status status2 = status = orderResponse != null ? orderResponse.getStatus() : null;
                if (response.isSuccessful() && status != null) {
                    OrderResponse.Status[] statusArray = new OrderResponse.Status[]{OrderResponse.Status.DONE, OrderResponse.Status.CANCELED};
                    if (!CollectionsKt.listOf((Object[])statusArray).contains((Object)((Object)status))) {
                        this.$delayTimer.schedule(new TimerTask(this.$singleRunTask){
                            final /* synthetic */ Ref.ObjectRef<Runnable> $singleRunTask;
                            {
                                this.$singleRunTask = $singleRunTask;
                            }

                            public void run() {
                                Runnable runnable;
                                if (this.$singleRunTask.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"singleRunTask");
                                    runnable = null;
                                } else {
                                    runnable = (Runnable)this.$singleRunTask.element;
                                }
                                runnable.run();
                            }
                        }, 3000L);
                    }
                    this.$listener.onStatusUpdate(status);
                } else {
                    this.$listener.onFailure();
                }
            }

            public void onFailure(@NotNull Call<OrderResponse> call, @NotNull Throwable t) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$delayTimer.schedule(new TimerTask(this.$singleRunTask){
                    final /* synthetic */ Ref.ObjectRef<Runnable> $singleRunTask;
                    {
                        this.$singleRunTask = $singleRunTask;
                    }

                    public void run() {
                        Runnable runnable;
                        if (this.$singleRunTask.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"singleRunTask");
                            runnable = null;
                        } else {
                            runnable = (Runnable)this.$singleRunTask.element;
                        }
                        runnable.run();
                    }
                }, 3000L);
            }
        });
    }

    public static final /* synthetic */ Client access$getCentrifugoClient$p(OrdersTracker $this) {
        return $this.centrifugoClient;
    }

    public static final /* synthetic */ void access$switchToShortPolling(OrdersTracker $this, int projectId) {
        $this.switchToShortPolling(projectId);
    }

    public static final /* synthetic */ Map access$getListeners$p(OrdersTracker $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$onListenersModified(OrdersTracker $this) {
        $this.onListenersModified();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/xsolla/android/store/orders/OrdersTracker$Companion;", "", "()V", "CENTRIFUGO_ENDPOINT", "", "SHORT_POLLING_TIMEOUT", "", "xsolla-store-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/xsolla/android/store/orders/OrdersTracker$CentrifugeConnectionData;", "", "Token", "", "ProjectId", "", "(Ljava/lang/String;I)V", "getProjectId", "()I", "getToken", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "xsolla-store-sdk_release"})
    private static final class CentrifugeConnectionData {
        @SerializedName(value="auth")
        @NotNull
        private final String Token;
        @SerializedName(value="project_id")
        private final int ProjectId;

        public CentrifugeConnectionData(@NotNull String Token, int ProjectId) {
            Intrinsics.checkNotNullParameter((Object)Token, (String)"Token");
            this.Token = Token;
            this.ProjectId = ProjectId;
        }

        @NotNull
        public final String getToken() {
            return this.Token;
        }

        public final int getProjectId() {
            return this.ProjectId;
        }

        @NotNull
        public final String component1() {
            return this.Token;
        }

        public final int component2() {
            return this.ProjectId;
        }

        @NotNull
        public final CentrifugeConnectionData copy(@NotNull String Token, int ProjectId) {
            Intrinsics.checkNotNullParameter((Object)Token, (String)"Token");
            return new CentrifugeConnectionData(Token, ProjectId);
        }

        public static /* synthetic */ CentrifugeConnectionData copy$default(CentrifugeConnectionData centrifugeConnectionData, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = centrifugeConnectionData.Token;
            }
            if ((n2 & 2) != 0) {
                n = centrifugeConnectionData.ProjectId;
            }
            return centrifugeConnectionData.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "CentrifugeConnectionData(Token=" + this.Token + ", ProjectId=" + this.ProjectId + ')';
        }

        public int hashCode() {
            int result = this.Token.hashCode();
            result = result * 31 + Integer.hashCode(this.ProjectId);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CentrifugeConnectionData)) {
                return false;
            }
            CentrifugeConnectionData centrifugeConnectionData = (CentrifugeConnectionData)other;
            if (!Intrinsics.areEqual((Object)this.Token, (Object)centrifugeConnectionData.Token)) {
                return false;
            }
            return this.ProjectId == centrifugeConnectionData.ProjectId;
        }
    }
}

