/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.cache.impl;

import com.xuanner.dt.cache.DtCacheClient;
import com.xuanner.dt.common.MapUtil;
import com.xuanner.dt.common.redis.JedisBase;
import java.util.Collection;
import java.util.Map;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class JedisDtCacheClient
extends JedisBase
implements DtCacheClient {
    @Override
    public String get(String key) {
        return this.getJedis().get(key);
    }

    @Override
    public Map<String, String> getBulk(Collection<String> keys) {
        Pipeline pip = this.getJedis().pipelined();
        Map<String, Response> key2ResponseMap = MapUtil.newHashMap(keys.size());
        keys.forEach(key -> key2ResponseMap.put((String)key, pip.get(key)));
        pip.sync();
        Map<String, String> key2ValueMap = MapUtil.newHashMap(keys.size());
        key2ResponseMap.forEach((key, response) -> {
            String cfr_ignored_0 = (String)key2ValueMap.put((String)key, (String)response.get());
        });
        return key2ValueMap;
    }

    @Override
    public void set(String key, String value, int seconds) {
        this.getJedis().setex(key, seconds, value);
    }

    @Override
    public void setBulk(Map<String, String> map, int seconds) {
        Pipeline pip = this.getJedis().pipelined();
        map.forEach((key, value) -> pip.setex(key, seconds, value));
        pip.sync();
    }

    @Override
    public void del(String key) {
        this.getJedis().del(key);
    }

    @Override
    public void delBulk(Collection<String> keys) {
        Pipeline pip = this.getJedis().pipelined();
        keys.forEach(arg_0 -> ((Pipeline)pip).del(arg_0));
        pip.sync();
    }
}

