/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.common.redis;

import com.xuanner.dt.common.redis.JedisDirectConfig;
import com.xuanner.dt.common.redis.JedisFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisDirectFactory
implements JedisFactory {
    private JedisDirectConfig config;
    private JedisPool jedisPool;

    @Override
    public Jedis getJedis() {
        Jedis jedis = this.jedisPool.getResource();
        if (null != this.config.getAuth()) {
            jedis.auth(this.config.getAuth());
        }
        return jedis;
    }

    @Override
    public void init() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(500);
        jedisPoolConfig.setMaxIdle(5);
        jedisPoolConfig.setMaxWaitMillis(10000L);
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.config.getHost(), this.config.getPort(), 10000);
    }

    @Override
    public void destroy() {
        if (null != this.jedisPool) {
            this.jedisPool.destroy();
        }
    }

    public JedisDirectConfig getConfig() {
        return this.config;
    }

    public void setConfig(JedisDirectConfig config) {
        this.config = config;
    }
}

