/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.common.redis;

import com.xuanner.dt.common.redis.JedisFactory;
import com.xuanner.dt.common.redis.JedisSentinelConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class JedisSentinelFactory
implements JedisFactory {
    private JedisSentinelConfig config;
    private JedisSentinelPool jedisSentinelPool;

    @Override
    public Jedis getJedis() {
        Jedis jedis = this.jedisSentinelPool.getResource();
        if (null != this.config.getAuth()) {
            jedis.auth(this.config.getAuth());
        }
        return jedis;
    }

    @Override
    public void init() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(500);
        jedisPoolConfig.setMaxIdle(5);
        jedisPoolConfig.setMaxWaitMillis(10000L);
        this.jedisSentinelPool = new JedisSentinelPool(this.config.getMasterName(), this.config.getSentineSet(), (GenericObjectPoolConfig)jedisPoolConfig, this.config.getAuth());
    }

    @Override
    public void destroy() {
        if (null != this.jedisSentinelPool) {
            this.jedisSentinelPool.destroy();
        }
    }

    public JedisSentinelConfig getConfig() {
        return this.config;
    }

    public void setConfig(JedisSentinelConfig config) {
        this.config = config;
    }
}

