/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.core.impl;

import com.xuanner.dt.common.UuidUtil;
import com.xuanner.dt.common.redis.JedisBase;
import com.xuanner.dt.core.DtSemaphore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JedisDtSemaphore
extends JedisBase
implements DtSemaphore {
    private static final int DEFAULT_TIMEOUT_SECOND = 30;
    private long permits;
    private String semaphoreSetName;
    private int timeoutSecond;

    public JedisDtSemaphore(String name, long permits, int timeoutSecond) {
        this.permits = permits;
        this.semaphoreSetName = name + ":DtSemaphore";
        this.timeoutSecond = timeoutSecond;
    }

    public JedisDtSemaphore(String name, long permits) {
        this(name, permits, 30);
    }

    @Override
    public String acquire() {
        String success = "1";
        String zremrangeByScore = "redis.call('zremrangeByScore', KEYS[1], 0, tonumber(ARGV[1])) ";
        String zcard = "local count = redis.call('zcard', KEYS[1]) ";
        String zadd = "redis.call('zadd', KEYS[1], tonumber(ARGV[2]), ARGV[3]) ";
        String script = zremrangeByScore + zcard;
        script = script + "if count < tonumber(ARGV[4]) then " + zadd + "return " + success + " ";
        script = script + "else return 0 end";
        List<String> keyList = Collections.singletonList(this.semaphoreSetName);
        String sId = UuidUtil.uuid();
        long now = System.currentTimeMillis();
        long endTime = now - (long)(this.timeoutSecond * 1000);
        ArrayList<String> argvList = new ArrayList<String>();
        argvList.add(String.valueOf(endTime));
        argvList.add(String.valueOf(now));
        argvList.add(sId);
        argvList.add(String.valueOf(this.permits));
        Object result = this.getJedis().eval(script, keyList, argvList);
        return success.equals(result.toString()) ? sId : null;
    }

    @Override
    public void release(String sId) {
        this.getJedis().zrem(this.semaphoreSetName, new String[]{sId});
    }
}

