/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.core.impl;

import com.xuanner.dt.common.redis.JedisBase;
import com.xuanner.dt.core.DtSortedSet;
import redis.clients.jedis.ZParams;

public class JedisDtSortedSet
extends JedisBase
implements DtSortedSet {
    public JedisDtSortedSet(String name) {
        this.setKeyName(name + ":DtSortedSet");
    }

    @Override
    public String getName() {
        return this.getKeyName();
    }

    @Override
    public void add(double score, String element) {
        this.getJedis().zadd(this.getKeyName(), score, element);
    }

    @Override
    public void removeByScoreRange(double scoreFrom, double scoreTo) {
        this.getJedis().zremrangeByScore(this.getKeyName(), scoreFrom, scoreTo);
    }

    @Override
    public void remove(String element) {
        this.getJedis().zrem(this.getKeyName(), new String[]{element});
    }

    @Override
    public long rank(String element) {
        return this.getJedis().zrank(this.getKeyName(), element);
    }

    @Override
    public long size() {
        return this.getJedis().zcard(this.getKeyName());
    }

    @Override
    public void intersectFrom(DtSortedSet fromSet, DtSortedSet resultSet) {
        ZParams params = new ZParams();
        params.weightsByDouble(new double[]{1.0, 0.0});
        this.getJedis().zinterstore(resultSet.getName(), params, new String[]{this.getName(), fromSet.getName()});
    }

    @Override
    public double getScore(String element) {
        return this.getJedis().zscore(this.getKeyName(), element);
    }
}

