/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.lock.impl;

import com.xuanner.dt.common.UuidUtil;
import com.xuanner.dt.common.redis.JedisBase;
import com.xuanner.dt.lock.DtLock;
import java.util.Collections;

public class JedisDtLock
extends JedisBase
implements DtLock {
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    private static final int DEFAULT_OWN_TIMEOUT = 30;
    private int ownTimeoutSecond = 30;

    public JedisDtLock(String name) {
        this.setKeyName(name + ":DtLock");
    }

    @Override
    public String tryLock() {
        String kId = UuidUtil.uuid();
        String result = this.getJedis().set(this.getKeyName(), kId, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, this.ownTimeoutSecond * 1000);
        return LOCK_SUCCESS.equals(result) ? kId : null;
    }

    @Override
    public void unLock(String kId) {
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        this.getJedis().eval(script, Collections.singletonList(this.getKeyName()), Collections.singletonList(kId));
    }

    public int getOwnTimeoutSecond() {
        return this.ownTimeoutSecond;
    }

    public void setOwnTimeoutSecond(int ownTimeoutSecond) {
        this.ownTimeoutSecond = ownTimeoutSecond;
    }
}

