/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.pubsub.impl;

import com.xuanner.dt.common.redis.JedisBase;
import com.xuanner.dt.pubsub.DtMessageListener;
import com.xuanner.dt.pubsub.DtSubscriber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import redis.clients.jedis.JedisPubSub;

public class JedisDtSubscriber
extends JedisBase
implements DtSubscriber {
    private Map<String, List<DtMessageListener>> listenerMap = new ConcurrentHashMap<String, List<DtMessageListener>>();

    @Override
    public void addListener(DtMessageListener listener) {
        List<DtMessageListener> listenerList = this.listenerMap.putIfAbsent(listener.topic(), new ArrayList());
        if (null == listenerList) {
            listenerList = this.listenerMap.get(listener.topic());
        }
        listenerList.add(listener);
    }

    @Override
    public void init() {
        Set<String> topicSet = this.listenerMap.keySet();
        String[] topics = topicSet.toArray(new String[topicSet.size()]);
        new Thread(() -> this.getJedis().subscribe(new JedisPubSub(){

            public void onMessage(String channel, String message) {
                List lList = (List)JedisDtSubscriber.this.listenerMap.get(channel);
                if (null != lList) {
                    lList.forEach(l -> l.onMessage(message));
                }
            }
        }, topics)).start();
    }
}

