/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.sequence.impl;

import com.xuanner.dt.common.redis.JedisBase;
import com.xuanner.dt.sequence.DtSequence;
import com.xuanner.dt.sequence.DtSequenceException;
import com.xuanner.dt.sequence.impl.SequenceRange;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class JedisDtSequence
extends JedisBase
implements DtSequence {
    private static final int DEFAULT_STEP = 1000;
    private static final int DEFAULT_STEP_START = 0;
    private final Lock lock = new ReentrantLock();
    private int step = 1000;
    private long stepStart = 0L;
    private volatile boolean keyAlreadyExist;
    private volatile SequenceRange currentRange;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextId(String name) throws DtSequenceException {
        long value;
        String realName = this.getRealName(name);
        if (null == this.currentRange) {
            this.lock.lock();
            try {
                if (null == this.currentRange) {
                    this.currentRange = this.nextRange(realName);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if ((value = this.currentRange.getAndIncrement()) == -1L) {
            this.lock.lock();
            try {
                while (true) {
                    if (this.currentRange.isOver()) {
                        this.currentRange = this.nextRange(realName);
                    }
                    if ((value = this.currentRange.getAndIncrement()) == -1L) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (value < 0L) {
            throw new DtSequenceException("Sequence value overflow, value = " + value);
        }
        return value;
    }

    private SequenceRange nextRange(String name) {
        if (!this.keyAlreadyExist) {
            Boolean isExists = this.getJedis().exists(name);
            if (!isExists.booleanValue()) {
                this.getJedis().setnx(name, String.valueOf(this.stepStart));
            }
            this.keyAlreadyExist = true;
        }
        Long max = this.getJedis().incrBy(name, (long)this.step);
        Long min = max - (long)this.step + 1L;
        return new SequenceRange(min, max);
    }

    public void setStep(int step) {
        this.step = step;
    }

    public void setStepStart(long stepStart) {
        this.stepStart = stepStart;
    }

    private String getRealName(String name) {
        return name + ":DtSequence";
    }
}

