/*
 * Decompiled with CFR 0.152.
 */
package com.xuanner.dt.sequence.impl;

import java.util.concurrent.atomic.AtomicLong;

class SequenceRange {
    private final long min;
    private final long max;
    private final AtomicLong value;
    private volatile boolean over = false;

    SequenceRange(long min, long max) {
        this.min = min;
        this.max = max;
        this.value = new AtomicLong(min);
    }

    long getAndIncrement() {
        long currentValue = this.value.getAndIncrement();
        if (currentValue > this.max) {
            this.over = true;
            return -1L;
        }
        return currentValue;
    }

    boolean isOver() {
        return this.over;
    }

    public String toString() {
        return "max: " + this.max + ", min: " + this.min + ", value: " + this.value;
    }
}

