/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.cloudjdbc.LobClass;
import com.xugu.cloudjdbc.OracleMethod;
import com.xugu.cloudjdbc.PreparedStatement;
import com.xugu.cloudjdbc.ResultSet;
import com.xugu.cloudjdbc.Statement;
import com.xugu.cloudjdbc.WatchableOutputStream;
import com.xugu.common.ReplaceEnum;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;

public class Blob
extends LobClass
implements java.sql.Blob,
Serializable {
    static final long serialVersionUID = 0L;
    Connection blobConnection = null;
    static Blob bb = new Blob("0".getBytes());
    ResultSet blob_rs;
    int colNum;

    public Blob(byte[] data) {
        super(data);
    }

    Blob(byte[] blobData, ResultSet rs, Connection clobConn, int col_index) {
        this.setBinaryData(blobData);
        this.blobConnection = clobConn;
        this.blob_rs = rs;
        this.colNum = col_index;
    }

    Blob(byte[] data, boolean is_path, Statement st, ResultSet rs, int col_index) {
        this.is_path = is_path;
        this.lobStm = st;
        this.blob_rs = rs;
        this.colNum = col_index;
        if (is_path) {
            String dataString = new String(data);
            int sepIndex = dataString.indexOf(32);
            this.lobDesciptor = dataString.substring(0, sepIndex);
            this.lobLen = Long.parseLong(dataString.substring(sepIndex + 1));
        } else {
            this.setBinaryData(data, 1, data.length - 1);
        }
    }

    Blob(byte[] data, boolean is_path, Statement st) {
        this.is_path = is_path;
        this.lobStm = st;
        if (is_path) {
            String dataString = new String(data);
            int sepIndex = dataString.indexOf(32);
            this.lobDesciptor = dataString.substring(0, sepIndex);
            this.lobLen = Long.parseLong(dataString.substring(sepIndex + 1));
        }
    }

    public Blob(InputStream in) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        byte[] temp = new byte[PreparedStatement.byteSize];
        int readLength = 0;
        try {
            while ((readLength = in.read(temp)) != -1) {
                byteOut.write(temp, 0, readLength);
            }
            this.setBinaryData(byteOut.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    byte[] getBinaryData() throws SQLException {
        return this.binaryData;
    }

    protected byte[] getBinaryData(long start, long len) throws SQLException {
        this.checkGetIndexAndLength(start, len, true);
        if (this.islobEmpty()) {
            return new byte[0];
        }
        if (this.getIsPath()) {
            byte[] binaryBytes = null;
            java.sql.ResultSet rs = null;
            rs = len == -1L ? this.lobStm.getLobResultSet(this.lobDesciptor, start - 1L, this.lobLen) : this.lobStm.getLobResultSet(this.lobDesciptor, start - 1L, len);
            if (rs.next()) {
                binaryBytes = rs.getBytes(1);
            }
            rs.close();
            return binaryBytes;
        }
        this.checkBlob();
        if (len == -1L) {
            return this.binaryData;
        }
        byte[] subData = new byte[(int)len];
        System.arraycopy(this.binaryData, (int)start - 1, subData, 0, (int)len);
        return subData;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getBinaryData(1L, -1L));
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        return this.getBinaryData(pos, length);
    }

    @Override
    public long length() throws SQLException {
        return super.length();
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkBlob();
        this.checkIndex(start);
        int pos = -1;
        if (this.checkObjectParam(pattern) == -1) {
            return pos;
        }
        byte[] subLobData = this.getBinaryData(start, this.length() - start);
        byte[] ssData = new byte[pattern.length];
        for (int i = 0; i < subLobData.length && subLobData.length - i > pattern.length; ++i) {
            if (subLobData[i] != pattern[0]) continue;
            System.arraycopy(subLobData, i, ssData, 0, ssData.length);
            if (!Arrays.equals(ssData, pattern)) continue;
            pos = i;
            break;
        }
        return pos == -1 ? -1L : (long)pos + start;
    }

    @Override
    public long position(java.sql.Blob pattern, long start) throws SQLException {
        return this.position(((Blob)pattern).getBinaryData(1L, -1L), start);
    }

    void setBinaryData(byte[] newBinaryData) {
        this.setLobData(newBinaryData, "blob", null, this.blobConnection == null ? false : this.blobConnection.useLobDescribMode());
        this.setIsPath(false);
    }

    void setBinaryData(byte[] newBinaryData, int start, int length) {
        if (this.checkObjectParam(newBinaryData) == -1) {
            return;
        }
        try {
            this.checkGetIndexAndLength(start, length, false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.binaryData = new byte[length];
        System.arraycopy(newBinaryData, start, this.binaryData, 0, length);
        this.setLobEmpty(false);
    }

    @Override
    public OutputStream setBinaryStream(long indexToWriteAt) throws SQLException {
        this.checkBlob();
        this.checkIndex(indexToWriteAt);
        WatchableOutputStream bytesOut = new WatchableOutputStream();
        if (this.binaryData != null) {
            if (!this.getIsPath()) {
                bytesOut.setWatcher(this, (int)indexToWriteAt);
            } else {
                if (this.lobLen == 0L) {
                    return null;
                }
                this.lobStm.checkClosed();
                java.sql.ResultSet rs = this.lobStm.getLobResultSet(this.lobDesciptor, 0L, this.lobLen);
                if (rs.next()) {
                    this.binaryData = rs.getBytes(1);
                    bytesOut.setWatcher(this, (int)indexToWriteAt);
                    this.setIsPath(false);
                }
                rs.close();
            }
            this.setLobEmpty(false);
            return bytesOut;
        }
        return null;
    }

    @Override
    public int setBytes(long writeAt, byte[] bytes) throws SQLException {
        return this.setBytes(writeAt, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long writeAt, byte[] bytes, int offset, int length) throws SQLException {
        this.checkBlob();
        if (this.checkObjectParam(bytes) == -1) {
            return 0;
        }
        this.checkIndex(writeAt);
        if (offset > bytes.length || offset < 0) {
            throw Error.createSQLException("[E50051]Blob: \u5199\u5165\u53c2\u6570\u9519\u8bef", ReplaceEnum.excStr.getReplaceStr() + 50051, 50051);
        }
        if (length > bytes.length) {
            throw Error.createSQLException("[E50051]Blob: \u5199\u5165\u53c2\u6570\u9519\u8bef", ReplaceEnum.excStr.getReplaceStr() + 50051, 50051);
        }
        byte[] lobData = this.getBinaryData(1L, -1L);
        if ((long)length > this.length() - (writeAt - 1L)) {
            byte[] newData = new byte[(int)(writeAt - 1L) + length];
            System.arraycopy(lobData, 0, newData, 0, (int)writeAt - 1);
            System.arraycopy(bytes, offset, newData, (int)writeAt - 1, length);
            this.binaryData = newData;
        } else {
            System.arraycopy(bytes, offset, lobData, (int)writeAt - 1, length);
            this.binaryData = lobData;
        }
        this.is_path = false;
        this.setLobEmpty(false);
        return length;
    }

    @Override
    public void truncate(long length) throws SQLException {
        this.binaryData = this.getBinaryData(1L, length);
        this.is_path = false;
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.isFree) {
            return;
        }
        this.isFree = true;
        this.binaryData = null;
        this.lobDesciptor = null;
        this.blob_rs = null;
        this.lobStm = null;
        this.blobConnection = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new ByteArrayInputStream(this.getBinaryData(pos, length));
    }

    public void streamClosed(byte[] byteData) {
        this.binaryData = byteData;
    }

    public void streamClosed(WatchableOutputStream out) {
        int streamSize = out.size();
        if (streamSize < this.binaryData.length) {
            out.write(this.binaryData, streamSize, this.binaryData.length - streamSize);
        }
        this.binaryData = out.toByteArray();
    }

    void updateBlob(byte[] blobBytes) {
        this.setBinaryData(blobBytes);
    }

    public static Blob getEmptyBLOB() {
        return OracleMethod.getEmptyBLOB();
    }

    ResultSet getBlobRS() {
        return this.blob_rs;
    }

    int getColNum() {
        return this.colNum;
    }

    public String getBlobDesciptor() {
        return this.lobDesciptor + "," + this.lobLen;
    }

    private void checkBlob() throws SQLException {
        this.checkLobFree();
        if (this.binaryData == null && this.lobDesciptor == null) {
            throw Error.createSQLException("[E51003]lob: lob\u5bf9\u8c61\u4e3a\u7a7a\u5bf9\u8c61", ReplaceEnum.excStr.getReplaceStr() + 51003, 51003);
        }
    }

    Connection getBlobConnection() {
        return this.blobConnection;
    }

    public static Blob createTemporary(Connection blobConnection, boolean cache, int duration) {
        return OracleMethod.createTemporary(blobConnection, cache, duration);
    }

    public static void freeTemporary(Blob temBlob) throws SQLException {
        OracleMethod.freeTemporary(temBlob);
    }

    public void freeTemporary() throws SQLException {
        OracleMethod.freeTemporary(this);
    }
}

