/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc.rowset;

import com.xugu.cloudjdbc.Error;
import com.xugu.common.ReplaceEnum;
import com.xugu.common.SQLCommon;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private ResultSetMetaData innerRsmd;
    private int columnCount;
    private int[] nullable;
    private int[] columnDisplaySize;
    private int[] precision;
    private int[] scale;
    private int[] columnType;
    private boolean[] searchable;
    private boolean[] caseSensitive;
    private boolean[] readOnly;
    private boolean[] writable;
    private boolean[] definatelyWritable;
    private boolean[] currency;
    private boolean[] autoIncrement;
    private boolean[] signed;
    private String[] columnLabel;
    private String[] schemaName;
    private String[] columnName;
    private String[] tableName;
    private String[] columnTypeName;
    private String[] catalogName;
    private String[] columnClassName;

    RowSetMetaDataImpl(int rowCount) {
        this.columnCount = rowCount;
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int index = 0; index < this.columnCount; ++index) {
            this.searchable[index] = false;
            this.caseSensitive[index] = false;
            this.readOnly[index] = false;
            this.nullable[index] = 1;
            this.signed[index] = false;
            this.columnDisplaySize[index] = 0;
            this.columnType[index] = 0;
            this.columnLabel[index] = "";
            this.columnName[index] = "";
            this.schemaName[index] = "";
            this.precision[index] = 0;
            this.scale[index] = 0;
            this.tableName[index] = "";
            this.columnTypeName[index] = "";
            this.writable[index] = false;
            this.definatelyWritable[index] = false;
            this.currency[index] = false;
            this.autoIncrement[index] = true;
            this.catalogName[index] = "";
            this.columnClassName[index] = "";
        }
    }

    RowSetMetaDataImpl(ResultSetMetaData rsmd) throws SQLException {
        this.innerRsmd = rsmd;
        this.columnCount = rsmd.getColumnCount();
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int colIndex = 0; colIndex < this.columnCount; ++colIndex) {
            this.searchable[colIndex] = rsmd.isSearchable(colIndex + 1);
            this.caseSensitive[colIndex] = rsmd.isCaseSensitive(colIndex + 1);
            this.readOnly[colIndex] = rsmd.isReadOnly(colIndex + 1);
            this.nullable[colIndex] = rsmd.isNullable(colIndex + 1);
            this.signed[colIndex] = rsmd.isSigned(colIndex + 1);
            this.columnDisplaySize[colIndex] = rsmd.getColumnDisplaySize(colIndex + 1);
            this.columnType[colIndex] = rsmd.getColumnType(colIndex + 1);
            this.columnLabel[colIndex] = rsmd.getColumnLabel(colIndex + 1);
            this.columnName[colIndex] = rsmd.getColumnName(colIndex + 1);
            this.schemaName[colIndex] = rsmd.getSchemaName(colIndex + 1);
            this.precision[colIndex] = rsmd.getPrecision(colIndex + 1);
            this.scale[colIndex] = rsmd.getScale(colIndex + 1);
            this.tableName[colIndex] = rsmd.getTableName(colIndex + 1);
            this.columnTypeName[colIndex] = rsmd.getColumnTypeName(colIndex + 1);
            this.writable[colIndex] = rsmd.isWritable(colIndex + 1);
            this.definatelyWritable[colIndex] = rsmd.isDefinitelyWritable(colIndex + 1);
            this.currency[colIndex] = rsmd.isCurrency(colIndex + 1);
            this.autoIncrement[colIndex] = rsmd.isAutoIncrement(colIndex + 1);
            this.catalogName[colIndex] = rsmd.getCatalogName(colIndex + 1);
            this.columnClassName[colIndex] = rsmd.getColumnClassName(colIndex + 1);
        }
    }

    @Override
    public String getCatalogName(int index) throws SQLException {
        this.checkColIndex(index);
        return this.catalogName[index - 1];
    }

    @Override
    public String getColumnClassName(int index) throws SQLException {
        this.checkColIndex(index);
        return this.columnClassName[index - 1];
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int index) throws SQLException {
        this.checkColIndex(index);
        return this.columnDisplaySize[index - 1];
    }

    @Override
    public String getColumnLabel(int index) throws SQLException {
        this.checkColIndex(index);
        return this.columnLabel[index - 1];
    }

    @Override
    public String getColumnName(int index) throws SQLException {
        this.checkColIndex(index);
        return this.columnName[index - 1];
    }

    @Override
    public int getColumnType(int index) throws SQLException {
        this.checkColIndex(index);
        return this.columnType[index - 1];
    }

    @Override
    public String getColumnTypeName(int index) throws SQLException {
        this.checkColIndex(index);
        return this.columnTypeName[index - 1];
    }

    @Override
    public int getPrecision(int index) throws SQLException {
        this.checkColIndex(index);
        return this.precision[index - 1];
    }

    @Override
    public int getScale(int index) throws SQLException {
        this.checkColIndex(index);
        return this.scale[index - 1];
    }

    @Override
    public String getSchemaName(int index) throws SQLException {
        this.checkColIndex(index);
        return this.schemaName[index - 1];
    }

    @Override
    public String getTableName(int index) throws SQLException {
        this.checkColIndex(index);
        return this.tableName[index - 1];
    }

    @Override
    public boolean isAutoIncrement(int index) throws SQLException {
        this.checkColIndex(index);
        return this.autoIncrement[index - 1];
    }

    @Override
    public boolean isCaseSensitive(int index) throws SQLException {
        this.checkColIndex(index);
        return this.caseSensitive[index - 1];
    }

    @Override
    public boolean isCurrency(int index) throws SQLException {
        this.checkColIndex(index);
        return this.currency[index - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int index) throws SQLException {
        this.checkColIndex(index);
        return this.definatelyWritable[index - 1];
    }

    @Override
    public int isNullable(int index) throws SQLException {
        this.checkColIndex(index);
        return this.nullable[index - 1];
    }

    @Override
    public boolean isReadOnly(int index) throws SQLException {
        this.checkColIndex(index);
        return this.readOnly[index - 1];
    }

    @Override
    public boolean isSearchable(int index) throws SQLException {
        this.checkColIndex(index);
        return this.searchable[index - 1];
    }

    @Override
    public boolean isSigned(int index) throws SQLException {
        this.checkColIndex(index);
        return this.signed[index - 1];
    }

    @Override
    public boolean isWritable(int index) throws SQLException {
        this.checkColIndex(index);
        return this.writable[index - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw SQLCommon.unSupportException("RowSetData.unwrap", "Class<T>");
    }

    @Override
    public void setAutoIncrement(int index, boolean value) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.autoIncrement[index - 1] = value;
    }

    @Override
    public void setCaseSensitive(int index, boolean value) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.caseSensitive[index - 1] = value;
    }

    @Override
    public void setCatalogName(int index, String catalog) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.catalogName[index - 1] = catalog;
    }

    @Override
    public void setColumnCount(int columnCount) throws SQLException {
        this.checkRowSetTypeForSet();
        this.columnCount = columnCount;
    }

    @Override
    public void setColumnDisplaySize(int index, int size) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.columnDisplaySize[index - 1] = size;
    }

    @Override
    public void setColumnLabel(int index, String colLable) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.columnLabel[index - 1] = colLable;
    }

    @Override
    public void setColumnName(int index, String colName) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.columnName[index - 1] = colName;
    }

    @Override
    public void setColumnType(int index, int colType) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.columnType[index - 1] = colType;
    }

    @Override
    public void setColumnTypeName(int index, String colTypeName) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.columnTypeName[index - 1] = colTypeName;
    }

    @Override
    public void setCurrency(int index, boolean currency) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.currency[index - 1] = currency;
    }

    @Override
    public void setNullable(int index, int nullable) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.nullable[index - 1] = nullable;
    }

    @Override
    public void setPrecision(int index, int precision) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.precision[index - 1] = precision;
    }

    @Override
    public void setScale(int index, int scale) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.scale[index - 1] = scale;
    }

    @Override
    public void setSchemaName(int index, String schemaName) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.schemaName[index - 1] = schemaName;
    }

    @Override
    public void setSearchable(int index, boolean searchable) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.searchable[index - 1] = searchable;
    }

    @Override
    public void setSigned(int index, boolean signed) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.signed[index - 1] = signed;
    }

    @Override
    public void setTableName(int index, String tableName) throws SQLException {
        this.checkRowSetTypeForSet();
        this.checkColIndex(index);
        this.tableName[index - 1] = tableName;
    }

    private void checkRowSetTypeForSet() throws SQLException {
        if (this.innerRsmd != null) {
            throw Error.createSQLException("[E51033]RowSetMetaData\uff1aexecute\u83b7\u5f97Rowset\u5bf9\u8c61\u7684RowSetMetaData\u5c5e\u6027\u4e0d\u80fd\u8bbe\u7f6e", ReplaceEnum.excStr.getReplaceStr() + 51033, 51033);
        }
    }

    private void checkColIndex(int index) throws SQLException {
        if (index < 1 || index > this.columnCount) {
            throw Error.createSQLException("[E50007] \u53c2\u6570\u4e0b\u6807\u8d8a\u754c\u5f02\u5e38", ReplaceEnum.excStr.getReplaceStr() + 50007, 50007);
        }
    }
}

