package com.xzchaoo.commons.basic;

import java.util.concurrent.Executor;

/**
 * Ack helper
 *
 * @author xzchaoo
 */
public final class Acks {
    public static void run(Ack ack, Runnable r) {
        try {
            r.run();
        } finally {
            ack.ack();
        }
    }

    public static void execute(Ack ack, Executor e, Runnable r) {
        try {
            e.execute(() -> run(ack, r));
        } catch (Throwable ex) {
            ack.ack();
            throw ex;
        }
    }
}
