package com.xzchaoo.commons.basic.concurrent;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;

/**
 * Only one thread factory.
 * created at 2020/7/26
 * @author xzchaoo
 */
public class OneThreadFactory implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    private boolean done;

    public OneThreadFactory(String name) {
        this(name, false);
    }

    public OneThreadFactory(String name, boolean daemon) {
        this.name = Objects.requireNonNull(name);
        this.daemon = daemon;
    }

    @Override
    public synchronized Thread newThread(Runnable r) {
        if (done) {
            throw new IllegalStateException("thread has been created");
        }
        done = true;
        Thread t = new Thread(r, name);
        t.setDaemon(daemon);
        return t;
    }
}
