package com.xzchaoo.commons.basic.config;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;

/**
 * <p>created at 2020-08-07
 *
 * @author xiangfeng.xzc
 */
public interface Manager {
    // config 必须属于同一个 Manager
    Config.Composite composite(Config... configs);

    Config.Composite composite(List<Config> configs);

    MapConfig createMapConfig(Map<String, String> map);

    MapConfig createMapConfig(Properties p);

    MapConfig createMapConfig(File file);

    MapConfig createMapConfig(InputStream inputStream);

    MutableMapConfig createMutableMapConfig();

    MutableMapConfig createMutableMapConfig(Map<String, String> map);

    Lock lock();

    /**
     * Scheduler for refresh
     * @return
     */
    ScheduledExecutorService scheduler();
}
