package com.xzchaoo.commons.basic.consistenthash;

import lombok.Data;

/**
 * created at 2020/7/26
 *
 * @author xzchaoo
 */
public interface ConsistentHash<N> {
    /**
     * Select node for hash.
     *
     * @param hash hash value
     * @return null if ring is empty
     */
    N select(int hash);

    /**
     * Get stats of this instance.
     *
     * @return stat
     */
    Stat stat();

    @Data
    class Stat {
        /**
         * Physical node count
         */
        private int nodeSize;
        /**
         * Virtual node count, If two 'Virtual node' has same hash, then only
         * one wins. So we has 'vnodeSize <= nodeSize * vnodeCountForEveryNode'
         */
        private int vnodeSize;
    }
}
