package com.xzchaoo.commons.basic.dispose;

/**
 * Disposable from projectreactor.
 * <p>created at 2020-08-04
 *
 * @author xiangfeng.xzc
 */
public interface Disposable {
    /**
     * Dispose resources.
     */
    void dispose();

    /**
     * Whether this instance is disposed.
     *
     * @return {@code true} is disposed
     */
    boolean isDisposed();

    /**
     * An extension of {@link Disposable}. The inner disposable instance can
     * be replaced with new one.
     * <p>created at 2020-08-04
     *
     * @author xiangfeng.xzc
     */
    interface Swap extends Disposable {
        /**
         * Replace previous disposable with the new one. <em>Do</em> dispose
         * previous one.
         *
         * @param d diposable
         */
        void update(Disposable d);

        /**
         * Replace previous disposable with the new one. <em>Do not</em>
         * dispose previous one.
         *
         * @param d disposable
         */
        void replace(Disposable d);
    }

    /**
     * Disposable的容器, 容器本身是一个Disposable, 如果容器被dispose, 那么
     */
    interface Composite extends Disposable {
        boolean add(Disposable d);

        boolean remove(Disposable d);

        int size();
    }
}
