package com.xzchaoo.commons.basic.dispose;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

/**
 * <p>created at 2020-08-05
 *
 * @author xiangfeng.xzc
 */
class ListCompositeDisposable implements Disposable.Composite {
    volatile boolean          disposed;
    private  List<Disposable> resources;

    ListCompositeDisposable() {
    }

    ListCompositeDisposable(Disposable... resources) {
        this.resources = new LinkedList<>();
        for (Disposable resource : resources) {
            Objects.requireNonNull(resource, "resource is null");
            this.resources.add(resource);
        }
    }

    @Override
    public void dispose() {
        if (disposed) {
            return;
        }
        // 减少在锁内的时间
        List<Disposable> list;
        synchronized (this) {
            if (disposed) {
                return;
            }
            disposed = true;
            list = this.resources;
            this.resources = null;
        }
        if (list != null) {
            for (Disposable resource : list) {
                resource.dispose();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return disposed;
    }

    @Override
    public boolean add(Disposable d) {
        if (disposed) {
            d.dispose();
            return false;
        }
        synchronized (this) {
            if (disposed) {
                return false;
            }
            List<Disposable> list = this.resources;
            if (list == null) {
                list = new LinkedList<>();
                this.resources = list;
            }
            list.add(d);
        }
        return true;
    }

    @Override
    public boolean remove(Disposable d) {
        if (disposed) {
            return false;
        }
        synchronized (this) {
            if (disposed) {
                return false;
            }
            if (resources == null || !resources.remove(d)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        List<Disposable> r = this.resources;
        return r == null ? 0 : r.size();
    }
}
