package com.xzchaoo.commons.basic.drainloop;

import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 基于 {@link Lock} 实现与 {@link DrainLoopDemo} 一样的功能, 其实很简单, 就是每个方法都加锁就行了.
 * <p>created at 2020-08-11
 *
 * @author xiangfeng.xzc
 */
public class LockDrainLoopDemo {
    private final Lock lock = new ReentrantLock();

    private final LinkedList<Action3> a3q = new LinkedList<>();

    private int maxWip = 4;
    private int wip;

    public void a1(Action1 a1) {
        lock.lock();
        try {
            for (int i = 0; i < 2; i++) {
                a2(new Action2());
            }
        } finally {
            lock.unlock();
        }
    }

    public void a2(Action2 a2) {
        lock.lock();
        try {
            a3(new Action3());
        } finally {
            lock.unlock();
        }
    }

    public void a3(Action3 a3) {
        lock.lock();
        try {
            a3q.offer(a3);
            while (wip < maxWip && !a3q.isEmpty()) {
                ++wip;
                a3 = a3q.removeFirst();
                // execute a3
            }
        } finally {
            lock.unlock();
        }
    }

    public void a3Ack() {
        lock.lock();
        try {
            if (!a3q.isEmpty()) {
                Action3 a3 = a3q.removeFirst();
                // execute a3
            } else {
                --wip;
            }
        } finally {
            lock.unlock();
        }
    }

    private static class Action1 {
    }

    private static class Action2 {
    }

    private static class Action3 {
    }
}
