package com.xzchaoo.commons.basic.heap;

/**
 * Heap node function
 * <p>created at 2020-08-11
 *
 * @param <N> node type
 * @author xiangfeng.xzc
 */
public interface NodeFunction<N> {
    /**
     * Compare two node. Must not throw any exception, or else the heap will be in a broken state.
     *
     * @param left
     * @param right
     * @return
     */
    int compare(N left, N right);

    /**
     * Get index of node. Must not throw any exception, or else the heap will be in a broken state.
     *
     * @param n
     * @return
     */
    int getIndex(N n);

    /**
     * Set index of node. Must not throw any exception, or else the heap will be in a broken state.
     *
     * @param n
     * @param index
     */
    void setIndex(N n, int index);
}
