package com.xzchaoo.commons.basic.stringdict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

import javax.annotation.concurrent.NotThreadSafe;

import lombok.Getter;

import com.google.common.annotations.Beta;

/**
 * <p>created at 2021/1/20
 *
 * @author xiangfeng.xzc
 */
@NotThreadSafe
@Getter
@Beta
public class StringDict {
    private final Map<String, Integer> toIndex = new HashMap<>();
    private       List<String>         stringList;
    private       Consumer<String>     consumer;

    public StringDict() {
        stringList = new ArrayList<>();
    }

    public StringDict(List<String> stringList) {
        this.stringList = Objects.requireNonNull(stringList);
    }

    public StringDict(Consumer<String> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
    }

    public void reuse() {
        toIndex.clear();
        stringList.clear();
    }

    public void reuse(List<String> stringList) {
        toIndex.clear();
        this.stringList = stringList;
    }

    public void reuse(Consumer<String> consumer) {
        toIndex.clear();
        this.consumer = consumer;
    }

    public int add(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        Integer index = toIndex.get(str);
        if (index != null) {
            return index;
        }
        index = stringList.size();
        toIndex.put(str, index);
        if (consumer != null) {
            consumer.accept(str);
        } else {
            stringList.add(str);
        }
        return index;
    }
}
