/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

@FunctionalInterface
public interface Ack {
    public static Ack once(Runnable runnable) {
        return new OnceAck(runnable);
    }

    public static Ack noop() {
        return Noop.INSTANCE;
    }

    public void ack();

    @Deprecated
    default public void safelyExecute(Executor executor, Runnable task) {
        try {
            executor.execute(() -> {
                try {
                    task.run();
                }
                finally {
                    this.ack();
                }
            });
        }
        catch (Throwable e) {
            this.ack();
            throw e;
        }
    }

    public static final class OnceAck
    extends AtomicReference<Runnable>
    implements Ack {
        public OnceAck(Runnable runnable) {
            this.lazySet(Objects.requireNonNull(runnable));
        }

        @Override
        public void ack() {
            Runnable task = this.getAndSet(null);
            if (task != null) {
                task.run();
            }
        }
    }

    public static final class Noop
    implements Ack {
        public static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public void ack() {
        }
    }
}

