/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import com.xzchaoo.commons.basic.dispose.Disposable;
import com.xzchaoo.commons.basic.dispose.Disposables;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicScheduledExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicScheduledExecutorService.class);
    private final ScheduledExecutorService scheduler;

    public DynamicScheduledExecutorService(ScheduledExecutorService scheduler) {
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler is null");
    }

    public Disposable dynamic(Runnable task, Duration initDelay, Supplier<Duration> delayProvider) {
        Objects.requireNonNull(task, "task is null");
        Objects.requireNonNull(task, "initDelay is null");
        Objects.requireNonNull(task, "delayProvider is null");
        DynamicTask dt = new DynamicTask(task, delayProvider);
        dt.schedule(initDelay);
        return dt.d;
    }

    public static DynamicScheduledExecutorService wrap(ScheduledExecutorService scheduler) {
        return new DynamicScheduledExecutorService(scheduler);
    }

    private class DynamicTask
    implements Runnable {
        private final Runnable task;
        private final Supplier<Duration> delaySupplier;
        private final Disposable.Swap d = Disposables.swap();
        private Duration lastDelay;

        DynamicTask(Runnable task, Supplier<Duration> delaySupplier) {
            this.task = task;
            this.delaySupplier = delaySupplier;
        }

        @Override
        public void run() {
            try {
                this.task.run();
            }
            catch (Throwable e) {
                LOGGER.error("Exception caught when running task", e);
            }
            Duration delay = this.lastDelay;
            try {
                delay = this.delaySupplier.get();
            }
            catch (Throwable e) {
                LOGGER.error("Exception caught when get next delay", e);
            }
            this.schedule(delay);
        }

        void schedule(Duration delay) {
            this.lastDelay = delay;
            try {
                ScheduledFuture<?> future = DynamicScheduledExecutorService.this.scheduler.schedule(this, delay.toMillis(), TimeUnit.MILLISECONDS);
                Disposable d = Disposables.fromFuture(future);
                this.d.update(d);
            }
            catch (Throwable e) {
                LOGGER.error("Exception caught when schedule next task", e);
                this.d.dispose();
            }
        }
    }
}

