/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import com.xzchaoo.commons.basic.concurrent.DynamicScheduledExecutorService;
import com.xzchaoo.commons.basic.dispose.Disposable;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class SchedulerUtils {
    private SchedulerUtils() {
    }

    public static ScheduledFuture<?> scheduleAtFixedRateAligned(ScheduledExecutorService s, Runnable cmd, long period, TimeUnit unit) {
        return SchedulerUtils.scheduleAtFixedRateAligned(s, cmd, period, 0L, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRateAligned(ScheduledExecutorService s, Runnable cmd, long period, long offset, TimeUnit unit) {
        long periodMs = unit.toMillis(period);
        long now = System.currentTimeMillis();
        long nextTime = now / periodMs * periodMs + periodMs + unit.toMillis(offset);
        long delay = nextTime - now;
        return s.scheduleAtFixedRate(cmd, delay, periodMs, TimeUnit.MILLISECONDS);
    }

    public static Disposable dynamic(ScheduledExecutorService scheduler, Runnable task, Duration initDelay, Supplier<Duration> delayProvider) {
        return DynamicScheduledExecutorService.wrap(scheduler).dynamic(task, initDelay, delayProvider);
    }
}

