/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationContext3<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationContext3.class);
    private static final AtomicReferenceFieldUpdater<SynchronizationContext3, Thread> THREAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SynchronizationContext3.class, Thread.class, "thread");
    private final ConcurrentLinkedQueue<T> q = new ConcurrentLinkedQueue();
    private final Consumer<T> consumer;
    private volatile Thread thread;

    public SynchronizationContext3(Consumer<T> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
    }

    public static <T> SynchronizationContext3<T> create(Consumer<T> consumer) {
        return new SynchronizationContext3<T>(consumer);
    }

    public void add(T t) {
        this.q.offer(t);
        this.drain();
    }

    public boolean isCurrentThreadInContext() {
        return this.thread == Thread.currentThread();
    }

    public void drain() {
        Thread thread = Thread.currentThread();
        ConcurrentLinkedQueue<T> q = this.q;
        do {
            T t;
            if (!THREAD_UPDATER.compareAndSet(this, null, thread)) {
                return;
            }
            while ((t = q.poll()) != null) {
                try {
                    this.consumer.accept(t);
                }
                catch (Throwable e) {
                    LOGGER.error("Exception caught when run task", e);
                }
            }
            THREAD_UPDATER.set(this, null);
        } while (!q.isEmpty());
    }
}

