/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config;

import com.xzchaoo.commons.basic.config.Config;
import com.xzchaoo.commons.basic.config.Event;
import com.xzchaoo.commons.basic.config.Listener;
import com.xzchaoo.commons.basic.config.Manager;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig
implements Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfig.class);
    protected final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    protected final Manager manager;

    protected AbstractConfig(Manager manager) {
        this.manager = Objects.requireNonNull(manager);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        String value = this.getString(key);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    @Override
    public Double getDouble(String key) {
        String value = this.getString(key);
        return value != null ? Double.valueOf(Double.parseDouble(value)) : null;
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    @Override
    public Integer getInteger(String key) {
        String value = this.getString(key);
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    @Override
    public Long getLong(String key) {
        String value = this.getString(key);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        return value != null ? Long.parseLong(value) : defaultValue;
    }

    @Override
    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public Boolean getBoolean(String key) {
        String value = this.getString(key);
        return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @Override
    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Manager manager() {
        return this.manager;
    }

    @Override
    public String name() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void lockAndListen(Runnable runnable, Listener listener) {
        this.lock();
        try {
            runnable.run();
            this.listeners.add(listener);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChange() {
        this.lock();
        try {
            Event event = new Event(Event.Type.CHANGED);
            for (Listener listener : this.listeners) {
                try {
                    listener.onEvent(event);
                }
                catch (Throwable e) {
                    LOGGER.error("Exception caught when calling onEvent on listener {}", (Object)listener, (Object)e);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    protected final void lock() {
        this.manager.lock().lock();
    }

    protected final void unlock() {
        this.manager.lock().unlock();
    }
}

