/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config;

import com.xzchaoo.commons.basic.config.AbstractConfig;
import com.xzchaoo.commons.basic.config.Config;
import com.xzchaoo.commons.basic.config.Event;
import com.xzchaoo.commons.basic.config.Listener;
import com.xzchaoo.commons.basic.config.Manager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultCompositeConfig
extends AbstractConfig
implements Config.Composite {
    private volatile State state = new State(Collections.emptyList());
    private final ChildListener childListener = new ChildListener();

    public DefaultCompositeConfig(Manager manager) {
        super(manager);
        this.state = new State(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCompositeConfig(Manager manager, Config ... configs) {
        super(manager);
        ArrayList<Child> children = new ArrayList<Child>(configs.length);
        this.lock();
        try {
            for (Config config : configs) {
                if (config.manager() != manager) {
                    throw new IllegalArgumentException();
                }
                Child child = new Child(config, this.childListener);
                children.add(child);
            }
            for (Child c : children) {
                c.listen();
            }
            this.state = new State(children);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCompositeConfig(Manager manager, List<Config> configs) {
        super(manager);
        ArrayList<Child> children = new ArrayList<Child>(configs.size());
        this.lock();
        try {
            for (Config config : configs) {
                if (config.manager() != manager) {
                    throw new IllegalArgumentException();
                }
                Child child = new Child(config, this.childListener);
                children.add(child);
            }
            for (Child c : children) {
                c.listen();
            }
            this.state = new State(children);
        }
        finally {
            this.unlock();
        }
    }

    public void addFirst(Config config) {
        this.add(config, true);
    }

    public void addLast(Config config) {
        this.add(config, false);
    }

    @Override
    public Map<String, String> asMap() {
        return this.state.merged;
    }

    @Override
    public String getString(String key) {
        return this.state.merged.get(key);
    }

    @Override
    public List<Config> children() {
        return this.state.childrenConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Config config) {
        this.lock();
        try {
            State oldState = this.state;
            Child child = oldState.findChild(config);
            if (child == null) {
                return;
            }
            child.unListen();
            ArrayList<Child> newConfigs = new ArrayList<Child>(oldState.children);
            newConfigs.remove(child);
            this.state = new State(newConfigs);
            this.fireChange();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Config config, boolean first) {
        if (config.manager() != this.manager) {
            throw new IllegalArgumentException("");
        }
        this.lock();
        try {
            State oldState = this.state;
            Child child = oldState.findChild(config);
            if (child != null) {
                throw new IllegalStateException("duplicated config");
            }
            child = new Child(config, this.childListener);
            child.listen();
            ArrayList<Child> newConfigs = new ArrayList<Child>(oldState.children.size() + 1);
            if (first) {
                newConfigs.add(child);
                newConfigs.addAll(oldState.children);
            } else {
                newConfigs.addAll(oldState.children);
                newConfigs.add(child);
            }
            this.state = new State(newConfigs);
            this.fireChange();
        }
        finally {
            this.unlock();
        }
    }

    private void onChildChange() {
        this.lock();
        try {
            State state = this.state;
            this.state = new State(state.children);
            this.fireChange();
        }
        finally {
            this.unlock();
        }
    }

    private class ChildListener
    implements Listener {
        private ChildListener() {
        }

        @Override
        public void onEvent(Event event) {
            DefaultCompositeConfig.this.onChildChange();
        }
    }

    public class Child {
        final Config config;
        final Listener listener;

        public Child(Config config, Listener listener) {
            this.config = config;
            this.listener = listener;
        }

        public void listen() {
            this.config.addListener(this.listener);
        }

        public void unListen() {
            this.config.removeListener(this.listener);
        }
    }

    private static class State {
        final Map<String, String> merged;
        final List<Child> children;
        final List<Config> childrenConfigs;

        State(List<Child> children) {
            this.children = Collections.unmodifiableList(new ArrayList<Child>(children));
            this.childrenConfigs = new ArrayList<Config>(children.size());
            HashMap<String, String> merged = new HashMap<String, String>();
            for (Child child : children) {
                this.childrenConfigs.add(child.config);
                merged.putAll(child.config.asMap());
            }
            this.merged = Collections.unmodifiableMap(merged);
        }

        public Child findChild(Config config) {
            for (Child child : this.children) {
                if (child.config != config) continue;
                return child;
            }
            return null;
        }
    }
}

