/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config;

import com.xzchaoo.commons.basic.config.AbstractConfig;
import com.xzchaoo.commons.basic.config.Manager;
import com.xzchaoo.commons.basic.config.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MapConfig
extends AbstractConfig {
    private volatile Map<String, String> map = Collections.emptyMap();

    public MapConfig(Manager manager) {
        super(manager);
        this.internalSetMap(Collections.emptyMap(), false);
    }

    public MapConfig(Manager manager, Map<String, String> map) {
        super(manager);
        this.internalSetMap(map, false);
    }

    public MapConfig(Manager manager, Properties p) {
        super(manager);
        this.internalSetMap(p, false);
    }

    @Override
    public Map<String, String> asMap() {
        return this.map;
    }

    @Override
    public String getString(String key) {
        return this.map.get(key);
    }

    protected void internalSetMap(Properties p, boolean fire) {
        this.internalSetMap(Utils.propertiesToMap(p), fire);
    }

    protected void internalSetMap(Map<String, String> map, boolean fire) {
        this.lock();
        try {
            this.map = Collections.unmodifiableMap(new HashMap<String, String>(map));
            if (fire) {
                this.fireChange();
            }
        }
        finally {
            this.unlock();
        }
    }
}

